/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.templating;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.templating.template.core.internal.INoValidationTemplateBean;
import oracle.eclipse.tools.common.util.logging.LoggingService;

public abstract class AbstractTemplateBean
implements INoValidationTemplateBean {
    public static final String DESIGN_TIME_ID_NONE = "none";
    private String _designTimeId = "none";

    public boolean isValid() {
        return true;
    }

    public void dump() {
        if (TraceOptions.TEMPLATE_PROCESSING) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("** Template Processing BEAN DUMP: ");
            buffer.append(this.getClass().getName());
            buffer.append("\n\n");
            buffer.append(this.beanDump());
            TraceOptions.log(buffer.toString());
        }
    }

    public String beanDump() {
        StringBuilder buffer = new StringBuilder();
        try {
            BeanInfo info = Introspector.getBeanInfo(this.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            Object[] noArgs = new Object[]{};
            PropertyDescriptor[] propertyDescriptorArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor nextProp = propertyDescriptorArray[n2];
                String propName = nextProp.getName();
                Method propReader = nextProp.getReadMethod();
                Object propValue = propReader.invoke((Object)this, noArgs);
                if (propValue instanceof AbstractTemplateBean) {
                    buffer.append("   ");
                    buffer.append(propName);
                    buffer.append(" = ");
                    buffer.append(propValue.getClass().getName());
                    buffer.append("\n");
                    buffer.append("   { -------- START NESTED -----------------------\n");
                    buffer.append(((AbstractTemplateBean)propValue).beanDump());
                    buffer.append("   } --------- END NESTED ------------------------\n");
                } else {
                    String propValueOutput = propValue == null ? "(null)" : propValue.toString();
                    buffer.append("   ");
                    buffer.append(propName);
                    buffer.append(" = ");
                    buffer.append(propValueOutput);
                    buffer.append("\n");
                }
                ++n2;
            }
        }
        catch (IntrospectionException ie) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)ie);
        }
        catch (IllegalArgumentException iae) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)iae);
        }
        catch (IllegalAccessException iae) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)ite);
        }
        return buffer.toString();
    }

    public String getDesignTimeId() {
        return this._designTimeId;
    }

    public void setDesignTimeId(String designTimeId) {
        this._designTimeId = designTimeId;
    }
}

