/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.refactoring;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.appgen.compare.IDiffChange;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationStatus;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationStatusEntry;
import oracle.eclipse.tools.common.services.appgen.generators.IGeneratedChange;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationParticipant;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerator;
import oracle.eclipse.tools.common.services.appgen.participants.GenerationRefactoringParticipant;
import oracle.eclipse.tools.common.services.appgen.refactoring.GenerationRefactoringArguments;
import oracle.eclipse.tools.common.services.appgen.refactoring.IResourceChangeFactory;
import oracle.eclipse.tools.common.services.appgen.refactoring.Messages;
import oracle.eclipse.tools.common.services.appgen.resulthandling.IResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.Position;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GenerationRefactoringProcessor
extends RefactoringProcessor {
    private final IGenerator _generator;
    private final IResourceChangeFactory _resourceChangeFactory;
    private List<IGeneratedChange> _generatedChanges = null;

    public GenerationRefactoringProcessor(IGenerator generator, IResourceChangeFactory resourceChangeFactory) {
        this._generator = generator;
        this._resourceChangeFactory = resourceChangeFactory;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return "oracle.eclipse.tools.adf.appgen.generationProcessor";
    }

    public String getProcessorName() {
        return Messages.GenerationRefactoring_name;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        monitor.beginTask("", 2);
        try {
            RefactoringStatus status = new RefactoringStatus();
            List<IResult> results = this._generator.generateContent();
            GenerationRefactoringProcessor.updateStatus(status, this._generator.getStatus());
            if (status.getSeverity() < 3) {
                results = this._generator.mergeContent(results);
                GenerationRefactoringProcessor.updateStatus(status, this._generator.getStatus());
                if (status.getSeverity() < 3) {
                    this._generatedChanges = this._generator.compareContent(results);
                    GenerationRefactoringProcessor.updateStatus(status, this._generator.getStatus());
                }
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor.beginTask(Messages.GenerationRefactoring_creating_changes, 1);
        try {
            CompositeChange change = new CompositeChange(Messages.GenerationRefactoring_name);
            if (this._generatedChanges != null) {
                for (IGeneratedChange genChange : this._generatedChanges) {
                    IFile file = genChange.getFile();
                    if (genChange.forNewResource()) {
                        change.add((Change)this._resourceChangeFactory.getCreateTextFileChange(file, genChange.getContent(), null, "XML"));
                        continue;
                    }
                    if (!genChange.hasDiffs()) continue;
                    TextFileChange fileChange = new TextFileChange(file.getName(), file);
                    MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
                    fileChange.setEdit((TextEdit)fileChangeRootEdit);
                    for (IDiffChange diff : genChange.getChanges()) {
                        GenerationRefactoringProcessor.setEdit(fileChangeRootEdit, diff);
                    }
                    change.add((Change)fileChange);
                }
            }
            CompositeChange compositeChange = change;
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<GenerationRefactoringParticipant> result = new ArrayList<GenerationRefactoringParticipant>();
        List<IGenerationParticipant> generationParticipants = this._generator.getGenerationParticipants();
        if (generationParticipants == null) {
            return null;
        }
        for (IGenerationParticipant generationParticipant : generationParticipants) {
            GenerationRefactoringParticipant participant = new GenerationRefactoringParticipant(generationParticipant);
            if (!participant.initialize(this, null, new GenerationRefactoringArguments())) continue;
            result.add(new GenerationRefactoringParticipant(generationParticipant));
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private static void setEdit(MultiTextEdit fileChangeRootEdit, IDiffChange change) {
        InsertEdit edit = null;
        Position position = change.getSourcePosition();
        String text = change.getChangeContent();
        switch (change.getChangeType()) {
            case ADDITION: {
                edit = new InsertEdit(position.getOffset(), text);
                break;
            }
            case REPLACE: {
                edit = new ReplaceEdit(position.getOffset(), position.getLength(), text);
                break;
            }
            case DELETE: {
                edit = new ReplaceEdit(position.getOffset(), position.getLength(), "");
            }
        }
        if (edit != null) {
            fileChangeRootEdit.addChild(edit);
        }
    }

    private static void updateStatus(RefactoringStatus status, GenerationStatus genStatus) {
        for (GenerationStatusEntry entry : genStatus.getEntries()) {
            GenerationStatus.Severity severity = entry.getSeverity();
            switch (severity) {
                case OK: {
                    break;
                }
                case INFO: {
                    status.addInfo(entry.getMessage());
                    break;
                }
                case WARNING: {
                    status.addWarning(entry.getMessage());
                    break;
                }
                case ERROR: {
                    status.addError(entry.getMessage());
                    break;
                }
                case FATAL: {
                    status.addFatalError(entry.getMessage());
                }
            }
        }
    }
}

