/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.merge.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import oracle.eclipse.tools.common.services.appgen.Messages;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.merge.AppgenFileMerge;
import oracle.eclipse.tools.common.services.appgen.merge.java.JMergerPolicyStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;

public class JavaFileMerge
extends AppgenFileMerge {
    private static final String CTYPE_JAVASOURCE = "org.eclipse.jdt.core.javaSource";
    private static final String EJB3_STATELESS_SOURCE = "oracle.eclipse.tools.weblogic.ejb3stateless";
    private static final String EJB3_STATEFUL_SOURCE = "oracle.eclipse.tools.weblogic.ejb3stateful";
    private static final String EJB3_SINGLETON_SOURCE = "oracle.eclipse.tools.weblogic.ejb3singleton";

    @Override
    public String merge(IFile file, String mergeContent) throws GenerationException {
        JControlModel model = new JControlModel();
        FacadeHelper facadeHelper = this.createFacadeHelper();
        URL url = JMergerPolicyStore.getJMergerPolicy("policies/jmergePolicy/jmerge-policy.xml");
        model.initialize(facadeHelper, url.toString());
        JMerger jMerger = new JMerger(model);
        try {
            String charset = file.getCharset();
            jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForInputStream(this.getInputStream(mergeContent, charset), charset));
            jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(file.getContents(), charset));
            jMerger.merge();
            return jMerger.getTargetCompilationUnitContents();
        }
        catch (CoreException e) {
            String message = Messages.bind((String)Messages.JavaFileMerge_merge_failed, (Object)file.getName(), (Object)e.getLocalizedMessage());
            throw new GenerationException(message, e);
        }
        catch (UnsupportedEncodingException e) {
            String message = Messages.bind((String)Messages.JavaFileMerge_merge_failed, (Object)file.getName(), (Object)e.getLocalizedMessage());
            throw new GenerationException(message, e);
        }
    }

    @Override
    protected boolean hasContentTypeId(IFile file) throws GenerationException {
        try {
            IContentType contentType;
            IContentDescription contentDesc = file.getContentDescription();
            return contentDesc != null && (contentType = contentDesc.getContentType()) != null && (CTYPE_JAVASOURCE.equals(contentType.getId()) || EJB3_STATELESS_SOURCE.equals(contentType.getId()) || EJB3_STATEFUL_SOURCE.equals(contentType.getId()) || EJB3_SINGLETON_SOURCE.equals(contentType.getId()));
        }
        catch (CoreException e) {
            String message = Messages.bind((String)Messages.JavaFileMerge_merge_failed, (Object)file.getName(), (Object)e.getLocalizedMessage());
            throw new GenerationException(message, e);
        }
    }

    protected FacadeHelper createFacadeHelper() {
        return new ASTFacadeHelper();
    }

    private InputStream getInputStream(String content, String charset) throws UnsupportedEncodingException {
        if (charset == null) {
            return new ByteArrayInputStream(content.getBytes(Charset.defaultCharset().name()));
        }
        return new ByteArrayInputStream(content.getBytes(charset));
    }
}

