/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.merge.AppgenFileMerge;
import oracle.eclipse.tools.common.services.appgen.merge.IMergeFactory;
import oracle.eclipse.tools.common.services.appgen.merge.IMerger;
import oracle.eclipse.tools.common.services.appgen.merge.internal.JavaFileMerge;
import oracle.eclipse.tools.common.services.appgen.resulthandling.IResult;
import org.eclipse.core.resources.IFile;

public class AppgenFileMergeFactory
implements IMergeFactory {
    private static final List<AppgenFileMerge> MERGERS = Collections.unmodifiableList(AppgenFileMergeFactory.create());

    protected static List<AppgenFileMerge> create() {
        ArrayList<AppgenFileMerge> indices = new ArrayList<AppgenFileMerge>();
        indices.add(AppgenFileMergeFactory.createJavaMerger());
        return indices;
    }

    protected static AppgenFileMerge createJavaMerger() {
        return new JavaFileMerge();
    }

    public static Collection<? extends AppgenFileMerge> createAppgenFileMergers() {
        return MERGERS;
    }

    public static AppgenFileMerge createAppgenFileMerger(IFile file) throws GenerationException {
        for (AppgenFileMerge appgenFileMerge : MERGERS) {
            if (!appgenFileMerge.matches(file)) continue;
            return appgenFileMerge;
        }
        return null;
    }

    @Override
    public IMerger createMerger(IResult result) throws GenerationException {
        IFile file = result.getContext().getTargetFile();
        return AppgenFileMergeFactory.createAppgenFileMerger(file);
    }
}

