/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.generators;

import oracle.eclipse.tools.common.services.appgen.generators.GenerationStatus;
import org.eclipse.core.runtime.Assert;

public class GenerationStatusEntry {
    public static final int NO_CODE = -1;
    private final GenerationStatus.Severity _severity;
    private final String _message;
    private final int _code;

    public GenerationStatusEntry(GenerationStatus.Severity severity, String msg) {
        this(severity, -1, msg);
    }

    public GenerationStatusEntry(GenerationStatus.Severity severity, int code, String msg) {
        Assert.isNotNull((Object)((Object)severity));
        this._severity = severity;
        this._code = code;
        this._message = msg;
    }

    public GenerationStatus.Severity getSeverity() {
        return this._severity;
    }

    public String getMessage() {
        return this._message;
    }

    public int getCode() {
        return this._code;
    }

    public boolean isFatalError() {
        return this._severity == GenerationStatus.Severity.FATAL;
    }

    public boolean isError() {
        return this._severity == GenerationStatus.Severity.ERROR;
    }

    public boolean isWarning() {
        return this._severity == GenerationStatus.Severity.WARNING;
    }

    public boolean isInfo() {
        return this._severity == GenerationStatus.Severity.INFO;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this._severity.toString()).append(": ");
        sb.append(this._message);
        sb.append(" (code: ");
        sb.append(this._code == -1 ? "none" : Integer.toString(this._code));
        sb.append(")\n");
        return sb.toString();
    }
}

