/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.generators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationStatusEntry;
import org.eclipse.core.runtime.Assert;

public class GenerationStatus {
    private List<GenerationStatusEntry> _entries;
    private Severity _severity = Severity.OK;

    public GenerationStatus() {
        this._entries = new ArrayList<GenerationStatusEntry>(0);
    }

    public List<GenerationStatusEntry> getEntries() {
        if (this._entries.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<GenerationStatusEntry>(this._entries);
    }

    public Severity getSeverity() {
        return this._severity;
    }

    public void addEntry(GenerationStatusEntry entry) {
        Assert.isNotNull((Object)entry);
        this._entries.add(entry);
        this._severity = Severity.max(this._severity, entry.getSeverity());
    }

    public void addEntry(Severity severity, String message) {
        this.addEntry(severity, -1, message);
    }

    public void addEntry(Severity severity, int _code, String message) {
        this.addEntry(new GenerationStatusEntry(severity, _code, message));
    }

    public void addInfo(String msg) {
        this.addEntry(Severity.INFO, msg);
    }

    public void addWarning(String msg) {
        this.addEntry(Severity.WARNING, msg);
    }

    public void addError(String msg) {
        this.addEntry(Severity.ERROR, msg);
    }

    public void addFatalError(String msg) {
        this.addEntry(Severity.FATAL, msg);
    }

    public void merge(GenerationStatus other) {
        if (other == null) {
            return;
        }
        this._entries.addAll(other.getEntries());
        this._severity = Severity.max(this._severity, other.getSeverity());
    }

    public static enum Severity {
        OK("OK"),
        INFO("info"),
        WARNING("warning"),
        ERROR("error"),
        FATAL("fatal");

        private final String _name;

        private Severity(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public static Severity max(Severity severity1, Severity severity2) {
            if (severity1.ordinal() > severity2.ordinal()) {
                return severity1;
            }
            return severity2;
        }
    }
}

