/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.generators;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.appgen.Messages;
import oracle.eclipse.tools.common.services.appgen.compare.IChangeCompareFactory;
import oracle.eclipse.tools.common.services.appgen.compare.IDiffChange;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationStatus;
import oracle.eclipse.tools.common.services.appgen.generators.IGeneratedChange;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContext;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContextFactory;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationParticipant;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerator;
import oracle.eclipse.tools.common.services.appgen.generators.internal.DefaultGeneratedChange;
import oracle.eclipse.tools.common.services.appgen.merge.AppgenFileMergeFactory;
import oracle.eclipse.tools.common.services.appgen.merge.IMergeFactory;
import oracle.eclipse.tools.common.services.appgen.merge.IMerger;
import oracle.eclipse.tools.common.services.appgen.resulthandling.DefaultResult;
import oracle.eclipse.tools.common.services.appgen.resulthandling.IResult;
import oracle.eclipse.tools.common.services.appgen.templating.TemplateProcessor;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;

public class DefaultGenerator
implements IGenerator {
    private final IGenerationContextFactory _contextFactory;
    private final IChangeCompareFactory _changeCompareFactory;
    private IMergeFactory _mergeFactory = new AppgenFileMergeFactory();
    private GenerationStatus _status = new GenerationStatus();

    public DefaultGenerator(IGenerationContextFactory contextFactory, IChangeCompareFactory changeCompareFactory) {
        this._contextFactory = contextFactory;
        this._changeCompareFactory = changeCompareFactory;
    }

    @Override
    public IGenerationContextFactory getGenerationContextFactory() {
        return this._contextFactory;
    }

    @Override
    public void setMergeFactory(IMergeFactory mergeFactory) {
        this._mergeFactory = mergeFactory;
    }

    @Override
    public IMergeFactory getMergeFactory() {
        return this._mergeFactory;
    }

    @Override
    public GenerationStatus getStatus() {
        return this._status;
    }

    @Override
    public void clearStatus() {
        this._status = new GenerationStatus();
    }

    @Override
    public List<IResult> generateContent() {
        this.clearStatus();
        ArrayList<IResult> results = new ArrayList<IResult>();
        try {
            if (this.getGenerationContextFactory() == null) {
                String message = "Program Error: Generation context factory is null";
                IllegalStateException ise = new IllegalStateException(message);
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)ise);
                this.addFatalError(message);
                return results;
            }
            for (IGenerationContext context : this.getGenerationContextFactory().getGenerationContexts()) {
                IResult result = this.generateResult(context);
                if (result == null) continue;
                results.add(result);
            }
        }
        catch (GenerationException e) {
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                message = Messages.GenerateContent_fatal_error;
            }
            if (TraceOptions.TEMPLATE_PROCESSING) {
                TraceOptions.log(message, e);
            }
            this.addFatalError(message);
        }
        return results;
    }

    private IResult generateResult(IGenerationContext context) {
        try {
            String result = TemplateProcessor.process(context.getName(), context);
            return new DefaultResult(result, context);
        }
        catch (GenerationException e) {
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                message = String.format(Messages.TemplateProcessor_process_failed, context.getName());
            }
            if (TraceOptions.TEMPLATE_PROCESSING) {
                TraceOptions.log(message, e);
            }
            this.addFatalError(message);
            return null;
        }
    }

    @Override
    public List<IResult> mergeContent(List<IResult> generatedContentResults) {
        this.clearStatus();
        ArrayList<IResult> results = new ArrayList<IResult>();
        for (IResult result : generatedContentResults) {
            IFile file = result.getContext().getTargetFile();
            if (file.exists()) {
                String message;
                try {
                    IMerger merger = this.getMergeFactory().createMerger(result);
                    if (merger != null) {
                        String mergedResult = merger.merge(result);
                        results.add(new DefaultResult(mergedResult, result.getContext()));
                        if (!TraceOptions.MERGING) continue;
                        TraceOptions.log("Merged Result " + mergedResult);
                        continue;
                    }
                    message = String.format(Messages.Merging_fatal_error, file.getName());
                    this.addFatalError(message);
                }
                catch (GenerationException e) {
                    message = e.getMessage();
                    if (message == null || message.isEmpty()) {
                        message = String.format(Messages.Merging_process_failed, file.getName());
                    }
                    if (TraceOptions.MERGING) {
                        TraceOptions.log(message, e);
                    }
                    this.addFatalError(message);
                }
                continue;
            }
            results.add(result);
        }
        return results;
    }

    @Override
    public List<IGeneratedChange> compareContent(List<IResult> mergedContentResults) {
        ArrayList<IGeneratedChange> compareResults = new ArrayList<IGeneratedChange>();
        for (IResult result : mergedContentResults) {
            IFile file = result.getContext().getTargetFile();
            if (file.exists()) {
                try {
                    List<IDiffChange> diffs = this._changeCompareFactory.createCompareChanges(file, result.getContent());
                    compareResults.add(new DefaultGeneratedChange(file, result.getContent(), diffs));
                }
                catch (GenerationException e) {
                    String message = e.getMessage();
                    if (message == null || message.isEmpty()) {
                        message = String.format(Messages.CompareContent_failed, file.getName());
                    }
                    if (TraceOptions.COMPARE_RESULT_CONTENT) {
                        TraceOptions.log(message, e);
                    }
                    this.addFatalError(message);
                }
                continue;
            }
            compareResults.add(new DefaultGeneratedChange(file, result.getContent()));
        }
        return compareResults;
    }

    protected void addError(String message) {
        this._status.addError(message);
    }

    protected void addFatalError(String message) {
        this._status.addFatalError(message);
    }

    @Override
    public List<IGenerationParticipant> getGenerationParticipants() {
        return this.getGenerationContextFactory().getGenerationParticipants();
    }
}

