/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services;

import oracle.eclipse.tools.common.services.Preferences;
import oracle.eclipse.tools.common.services.SpecialPreferenceManager;
import oracle.eclipse.tools.common.services.project.internal.ProjectSharedEventManager;
import oracle.eclipse.tools.common.services.resources.internal.SequentialEventManager;
import oracle.eclipse.tools.common.services.util.OEPEStructuredContextResolverFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jst.jsf.context.IDelegatingFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.common.services";
    private static Activator plugin;
    private final Preferences _preferences;
    private BundleListener bundleListener = null;
    private SpecialPreferenceManager _specialPreferenceManager;
    private final SequentialEventManager sequentialEventManager = new SequentialEventManager();
    private final ProjectSharedEventManager projectSharedEventManager = new ProjectSharedEventManager();
    private OEPEStructuredContextResolverFactory _tagLibResolverFactory;

    public Activator() {
        this._specialPreferenceManager = new SpecialPreferenceManager();
        IPreferencesService pService = Platform.getPreferencesService();
        this._preferences = new Preferences(pService);
        this._preferences.initDefaults();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        JSPCorePlugin.getDefault();
        this._specialPreferenceManager.doStartActions();
        IStructuredDocumentContextResolverFactory2 factory = IStructuredDocumentContextResolverFactory2.INSTANCE;
        if (factory instanceof IDelegatingFactory) {
            this._tagLibResolverFactory = new OEPEStructuredContextResolverFactory();
            ((IDelegatingFactory)factory).addFactoryDelegate((IAdaptable)this._tagLibResolverFactory);
        } else {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error adding tag resolver delegate", new Throwable()));
        }
        if (!this.getPreferences().isDisabled()) {
            this.startSequentialEventManagerOnBundleActivated(context);
        }
    }

    public void preferencesChanged() {
        if (this.getPreferences().isDisabled()) {
            this.sequentialEventManager.shutDown();
        } else {
            this.sequentialEventManager.start();
        }
    }

    private final void startSequentialEventManagerOnBundleActivated(final BundleContext context) {
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == Activator.this.getBundle() && event.getType() == 2) {
                    if (Activator.this.getBundle().getState() == 32) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                            }

                            public void handleException(Throwable exception) {
                            }
                        });
                        Activator.this.sequentialEventManager.start();
                        Activator.this.projectSharedEventManager.start();
                    }
                    context.removeBundleListener((BundleListener)this);
                }
            }
        };
        context.addBundleListener(this.bundleListener);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.bundleListener != null) {
            context.removeBundleListener(this.bundleListener);
        }
        if (this.sequentialEventManager != null) {
            this.sequentialEventManager.shutDown();
        }
        if (this.projectSharedEventManager != null) {
            this.projectSharedEventManager.shutDown();
        }
        plugin = null;
        super.stop(context);
        this._specialPreferenceManager.unsetModelManagerDeadlockTimeout();
        IStructuredDocumentContextResolverFactory2 factory = IStructuredDocumentContextResolverFactory2.INSTANCE;
        if (factory instanceof IDelegatingFactory && this._tagLibResolverFactory != null) {
            ((IDelegatingFactory)factory).removeFactoryDelegate((IAdaptable)this._tagLibResolverFactory);
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Preferences getPreferences() {
        return this._preferences;
    }

    public SequentialEventManager getSequentialEventManager() {
        return this.sequentialEventManager;
    }

    public ProjectSharedEventManager getProjectSharedEventManager() {
        return this.projectSharedEventManager;
    }

    public static void log(String msg, Throwable t) {
        ILog log;
        Activator activator = Activator.getDefault();
        if (activator != null && (log = activator.getLog()) != null) {
            log.log((IStatus)new Status(4, PLUGIN_ID, msg, t));
            return;
        }
        t.printStackTrace();
    }

    public static void log(Exception e) {
        Activator.log("Caught Exception", e);
    }
}

