/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.TabGroupPagePart;
import org.eclipse.sapphire.ui.forms.TabGroupPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public final class TabGroupPresentation
extends FormComponentPresentation {
    private List<Presentation> pages;

    public TabGroupPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    public TabGroupPart part() {
        return (TabGroupPart)super.part();
    }

    @Override
    public void render() {
        final TabGroupPart part = this.part();
        ListFactory pagesListFactory = ListFactory.start();
        final TabFolder tabFolderControl = new TabFolder(this.composite(), 128);
        tabFolderControl.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(part.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2), 9));
        this.register((Control)tabFolderControl);
        for (final TabGroupPagePart page : part.pages()) {
            Composite tabControl = new Composite((Composite)tabFolderControl, 0);
            tabControl.setLayout((Layout)GridLayoutUtil.glayout(2, 1, 10, 10, 10));
            final TabItem tab = new TabItem(tabFolderControl, 0);
            tab.setText(page.getLabel());
            tab.setControl((Control)tabControl);
            final HashMap<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
            TabGroupPresentation.refreshTabImage(tab, page, images);
            final Listener tabPartListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphirePart.LabelChangedEvent) {
                        tab.setText(page.getLabel());
                    } else if (event instanceof SapphirePart.ImageChangedEvent) {
                        TabGroupPresentation.refreshTabImage(tab, page, images);
                    }
                }
            };
            page.attach(tabPartListener);
            tab.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    page.detach(tabPartListener);
                    for (Image image : images.values()) {
                        image.dispose();
                    }
                }
            });
            FormComponentPresentation presentation = page.createPresentation(this, tabControl);
            pagesListFactory.add((Object)presentation);
            presentation.render();
        }
        tabFolderControl.setSelection(part.pages().indexOf(part.selection()));
        tabFolderControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int tabGroupPageIndex = tabFolderControl.getSelectionIndex();
                part.select(part.pages().get(tabGroupPageIndex));
            }
        });
        this.pages = pagesListFactory.result();
    }

    private static void refreshTabImage(TabItem tab, TabGroupPagePart tabPart, Map<ImageDescriptor, Image> images) {
        Image image = null;
        ImageDescriptor imageDescriptor = tabPart.getImage();
        if (imageDescriptor != null && (image = images.get(imageDescriptor)) == null) {
            image = imageDescriptor.createImage();
            images.put(imageDescriptor, image);
        }
        tab.setImage(image);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.pages != null) {
            for (Presentation page : this.pages) {
                page.dispose();
            }
            this.pages = null;
        }
    }
}

