/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.forms.swt.ValuePropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.PopUpListFieldStyle;
import org.eclipse.sapphire.ui.forms.swt.internal.PossibleValue;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public final class PopUpListFieldPropertyEditorPresentation
extends ValuePropertyEditorPresentation {
    private static final String DATA_DEFAULT_VALUE = "Sapphire.Default.Value";
    private final PopUpListFieldStyle style;
    private Combo combo;

    public PopUpListFieldPropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite, PopUpListFieldStyle style) {
        super(part, parent, composite);
        if (style == null) {
            throw new IllegalArgumentException();
        }
        this.style = style;
    }

    @Override
    protected void createContents(Composite parent) {
        PropertyEditorPart part = this.part();
        final Value property = (Value)part.property();
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(this.getActionPresentationManager());
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Browse"));
        boolean isActionsToolBarNeeded = toolBarActionsPresentation.hasActions();
        Composite composite = this.createMainComposite(parent);
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(isActionsToolBarNeeded ? 3 : 2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(composite);
        decorator.addEditorControl((Control)composite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        final Combo combo = new Combo(composite, 0x804 | (this.style == PopUpListFieldStyle.STRICT ? 8 : 0));
        combo.setLayoutData((Object)GridLayoutUtil.gdhfill());
        combo.setVisibleItemCount(10);
        decorator.addEditorControl((Control)combo, true);
        this.addControl((Control)combo);
        this.combo = combo;
        if (isActionsToolBarNeeded) {
            ToolBar toolbar = new ToolBar(composite, 0x800100);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdvfill(), 3));
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.addControl((Control)toolbar);
            decorator.addEditorControl((Control)toolbar);
        }
        final PossibleValuesService possibleValuesService = (PossibleValuesService)property.service(PossibleValuesService.class);
        final ValueNormalizationService valueNormalizationService = (ValueNormalizationService)property.service(ValueNormalizationService.class);
        final MutableReference possibleValuesRef = new MutableReference();
        final Runnable updateComboSelectionOp = new Runnable(){

            @Override
            public void run() {
                if (PopUpListFieldPropertyEditorPresentation.this.updatingModel || combo.isDisposed()) {
                    return;
                }
                String text = valueNormalizationService.normalize(property.text());
                try {
                    PopUpListFieldPropertyEditorPresentation.this.updatingEditor = true;
                    combo.setData(PopUpListFieldPropertyEditorPresentation.DATA_DEFAULT_VALUE, (Object)property.empty());
                    if (text == null) {
                        combo.deselectAll();
                        combo.setText("");
                    } else {
                        List possibleValues = (List)possibleValuesRef.get();
                        int possibleValuesCount = possibleValues.size();
                        int possibleValueIndex = -1;
                        int i = 0;
                        while (i < possibleValuesCount && possibleValueIndex == -1) {
                            if (MiscUtil.equal((Object)((PossibleValue)possibleValues.get(i)).value(), (Object)text)) {
                                possibleValueIndex = i;
                            }
                            ++i;
                        }
                        if (PopUpListFieldPropertyEditorPresentation.this.style == PopUpListFieldStyle.STRICT) {
                            if (possibleValueIndex == -1) {
                                if (possibleValues.size() == combo.getItemCount()) {
                                    combo.add(text);
                                } else {
                                    String existingNonConformingValue = combo.getItem(possibleValuesCount);
                                    if (!existingNonConformingValue.equals(text)) {
                                        combo.setItem(possibleValuesCount, text);
                                    }
                                }
                                possibleValueIndex = possibleValuesCount;
                            } else if (possibleValuesCount < combo.getItemCount()) {
                                combo.remove(possibleValuesCount);
                            }
                        }
                        if (possibleValueIndex != -1) {
                            if (combo.getSelectionIndex() != possibleValueIndex) {
                                combo.setText("");
                                combo.select(possibleValueIndex);
                            }
                        } else if (!MiscUtil.equal((Object)valueNormalizationService.normalize(combo.getText()), (Object)text)) {
                            combo.deselectAll();
                            combo.setText(text);
                        }
                    }
                }
                finally {
                    PopUpListFieldPropertyEditorPresentation.this.updatingEditor = false;
                }
            }
        };
        final Runnable updateComboContentOp = new Runnable(property){
            private final PossibleValue.Factory factory;
            {
                this.factory = PossibleValue.factory((Property)value);
            }

            @Override
            public void run() {
                if (PopUpListFieldPropertyEditorPresentation.this.updatingModel || combo.isDisposed()) {
                    return;
                }
                try {
                    PopUpListFieldPropertyEditorPresentation.this.updatingEditor = true;
                    List<PossibleValue> possibleValues = this.factory.entries();
                    possibleValuesRef.set(possibleValues);
                    String[] contentForCombo = new String[possibleValues.size()];
                    int i = 0;
                    int n = possibleValues.size();
                    while (i < n) {
                        contentForCombo[i] = possibleValues.get(i).label();
                        ++i;
                    }
                    combo.setItems(contentForCombo);
                }
                finally {
                    PopUpListFieldPropertyEditorPresentation.this.updatingEditor = false;
                }
                updateComboSelectionOp.run();
            }
        };
        updateComboContentOp.run();
        final Listener possibleValuesServiceListener = new Listener(){

            public void handle(Event event) {
                SwtUtil.runOnDisplayThread(updateComboContentOp);
            }
        };
        possibleValuesService.attach(possibleValuesServiceListener);
        FilteredListener<PropertyContentEvent> propertyListener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SwtUtil.runOnDisplayThread(updateComboSelectionOp);
            }
        };
        property.attach((Listener)propertyListener);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PopUpListFieldPropertyEditorPresentation.this.updatingEditor) {
                    return;
                }
                try {
                    List possible;
                    PopUpListFieldPropertyEditorPresentation.this.updatingModel = true;
                    String value = null;
                    int index = combo.getSelectionIndex();
                    if (index != -1 && index < (possible = (List)possibleValuesRef.get()).size()) {
                        value = ((PossibleValue)possible.get(index)).value();
                    }
                    if (value == null) {
                        value = combo.getText().trim();
                    }
                    if (value != null && value.length() == 0) {
                        value = null;
                    }
                    PopUpListFieldPropertyEditorPresentation.this.setPropertyValue(value);
                }
                finally {
                    PopUpListFieldPropertyEditorPresentation.this.updatingModel = false;
                }
            }
        });
        if (this.style == PopUpListFieldStyle.EDITABLE) {
            combo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    updateComboSelectionOp.run();
                }
            });
        }
        this.addOnDisposeOperation(new Runnable((Listener)propertyListener){
            private final /* synthetic */ Listener val$propertyListener;
            {
                this.val$propertyListener = listener2;
            }

            @Override
            public void run() {
                possibleValuesService.detach(possibleValuesServiceListener);
                property.detach(this.val$propertyListener);
            }
        });
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.combo.setFocus();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.combo = null;
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            Property property;
            String style = (String)part.definition().getStyle().content();
            if (style != null && style.startsWith("Sapphire.PropertyEditor.PopUpListField") && (property = part.property()).definition() instanceof ValueProperty && property.service(PossibleValuesService.class) != null) {
                PopUpListFieldStyle popUpListFieldPresentationStyle = null;
                if (style.equals("Sapphire.PropertyEditor.PopUpListField")) {
                    PossibleValues possibleValuesAnnotation;
                    popUpListFieldPresentationStyle = Enum.class.isAssignableFrom(property.definition().getTypeClass()) ? PopUpListFieldStyle.STRICT : ((possibleValuesAnnotation = (PossibleValues)property.definition().getAnnotation(PossibleValues.class)) != null ? (possibleValuesAnnotation.invalidValueSeverity() == Status.Severity.ERROR ? PopUpListFieldStyle.STRICT : PopUpListFieldStyle.EDITABLE) : PopUpListFieldStyle.EDITABLE);
                } else if (style.equals("Sapphire.PropertyEditor.PopUpListField.Editable")) {
                    popUpListFieldPresentationStyle = PopUpListFieldStyle.EDITABLE;
                } else if (style.equals("Sapphire.PropertyEditor.PopUpListField.Strict")) {
                    popUpListFieldPresentationStyle = PopUpListFieldStyle.STRICT;
                }
                if (popUpListFieldPresentationStyle != null) {
                    return new PopUpListFieldPropertyEditorPresentation(part, parent, composite, popUpListFieldPresentationStyle);
                }
            }
            return null;
        }
    }
}

