/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IModelElementTypeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.internal.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.internal.StandardImplicitConnectionPart;

public class DiagramImplicitConnectionTemplate
extends DiagramConnectionTemplate {
    private IDiagramImplicitConnectionBindingDef bindingDef;
    private IDiagramConnectionDef connectionDef;
    private SapphireDiagramEditorPagePart diagramEditor;
    private String propertyName;
    private ListProperty modelProperty;
    private List<Class<?>> modelElementTypes;
    private List<StandardImplicitConnectionPart> implicitConnections;
    private Listener modelPropertyListener;
    private Set<DiagramImplicitConnectionTemplateListener> templateListeners;
    private Map<Element, FunctionResult> listEntryFunctionMap;

    public DiagramImplicitConnectionTemplate(IDiagramImplicitConnectionBindingDef bindingDef) {
        this.bindingDef = bindingDef;
    }

    @Override
    public void init() {
        this.diagramEditor = (SapphireDiagramEditorPagePart)this.parent();
        this.listEntryFunctionMap = new IdentityHashMap<Element, FunctionResult>();
        this.connectionDef = (IDiagramConnectionDef)super.definition();
        this.propertyName = (String)this.bindingDef.getProperty().content();
        this.modelProperty = (ListProperty)this.getModelElement().property(this.propertyName).definition();
        this.modelElementTypes = new ArrayList();
        ElementList<IModelElementTypeDef> types = this.bindingDef.getModelElementTypes();
        for (IModelElementTypeDef typeDef : types) {
            this.modelElementTypes.add((Class)((JavaType)typeDef.getType().resolve()).artifact());
        }
        this.initImplicitConnectionParts();
        this.templateListeners = new CopyOnWriteArraySet<DiagramImplicitConnectionTemplateListener>();
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramImplicitConnectionTemplate.this.refreshImplicitConnections();
            }
        };
        this.addModelListener();
        List<DiagramNodeTemplate> nodeTemplates = this.diagramEditor.getNodeTemplates((PropertyDef)this.modelProperty);
        if (!nodeTemplates.isEmpty()) {
            NodeTemplateListener nodeTemplateListener = new NodeTemplateListener();
            for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
                nodeTemplate.addTemplateListener(nodeTemplateListener);
            }
        }
    }

    public SapphireDiagramEditorPagePart getDiagramEditorPart() {
        return this.diagramEditor;
    }

    @Override
    public void addModelListener() {
        this.getModelElement().attach(this.modelPropertyListener, this.propertyName);
    }

    @Override
    public void removeModelListener() {
        this.getModelElement().detach(this.modelPropertyListener, this.propertyName);
    }

    public void refreshImplicitConnections() {
        List<Element> newFilteredList = this.getFilteredModelElementList();
        for (StandardImplicitConnectionPart connPart : this.implicitConnections) {
            this.notifyConnectionDelete(connPart);
            connPart.dispose();
        }
        this.implicitConnections.clear();
        int i = 0;
        while (i < newFilteredList.size() - 1) {
            DiagramNodePart srcNode = this.diagramEditor.getDiagramNodePart(newFilteredList.get(i));
            DiagramNodePart targetNode = this.diagramEditor.getDiagramNodePart(newFilteredList.get(i + 1));
            if (srcNode != null && srcNode.getDiagramNodeTemplate().visible() && targetNode != null && targetNode.getDiagramNodeTemplate().visible()) {
                StandardImplicitConnectionPart connPart = this.createNewImplicitConnectionPart(newFilteredList.get(i), newFilteredList.get(i + 1));
                this.implicitConnections.add(connPart);
                this.notifyConnectionAdd(connPart);
            }
            ++i;
        }
    }

    public List<StandardImplicitConnectionPart> getImplicitConnections() {
        return this.implicitConnections;
    }

    private void initImplicitConnectionParts() {
        List<Element> newFilteredList = this.getFilteredModelElementList();
        this.implicitConnections = new ArrayList<StandardImplicitConnectionPart>();
        int i = 0;
        while (i < newFilteredList.size() - 1) {
            StandardImplicitConnectionPart connPart = this.createNewImplicitConnectionPart(newFilteredList.get(i), newFilteredList.get(i + 1));
            this.implicitConnections.add(connPart);
            ++i;
        }
    }

    private List<Element> getFilteredModelElementList() {
        ElementList list = this.getModelElement().property(this.modelProperty);
        ArrayList<Element> filteredList = new ArrayList<Element>();
        for (Element listEntryModelElement : list) {
            if (!this.isRightEntry(listEntryModelElement)) continue;
            filteredList.add(listEntryModelElement);
        }
        return filteredList;
    }

    private StandardImplicitConnectionPart createNewImplicitConnectionPart(Element srcNodeModel, Element targetNodeModel) {
        StandardImplicitConnectionPart connPart = new StandardImplicitConnectionPart(srcNodeModel, targetNodeModel);
        connPart.init(this, srcNodeModel, this.connectionDef, Collections.<String, String>emptyMap());
        connPart.initialize();
        return connPart;
    }

    private boolean isRightEntry(Element entryModelElement) {
        boolean isRightType = true;
        if (this.modelElementTypes.size() > 0) {
            isRightType = false;
            for (Class<?> eleType : this.modelElementTypes) {
                if (!eleType.isAssignableFrom(entryModelElement.getClass())) continue;
                isRightType = true;
                break;
            }
        }
        if (isRightType && this.bindingDef.getCondition() != null) {
            isRightType = false;
            FunctionResult fr = this.listEntryFunctionMap.get(entryModelElement);
            if (fr == null) {
                fr = this.initExpression(entryModelElement, (Function)this.bindingDef.getCondition().content(), String.class, null, new Runnable(){

                    @Override
                    public void run() {
                        DiagramImplicitConnectionTemplate.this.refreshImplicitConnections();
                    }
                });
                this.listEntryFunctionMap.put(entryModelElement, fr);
            }
            if (fr != null && ((String)fr.value()).equals("true")) {
                isRightType = true;
            }
        }
        return isRightType;
    }

    public void addTemplateListener(DiagramImplicitConnectionTemplateListener listener) {
        this.templateListeners.add(listener);
    }

    public void removeTemplateListener(DiagramImplicitConnectionTemplateListener listener) {
        this.templateListeners.remove(listener);
    }

    public void notifyConnectionAdd(StandardImplicitConnectionPart connPart) {
        for (DiagramImplicitConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionAddEvent(new ConnectionAddEvent(connPart));
        }
    }

    public void notifyConnectionDelete(StandardImplicitConnectionPart connPart) {
        for (DiagramImplicitConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionDeleteEvent(new ConnectionDeleteEvent(connPart));
        }
    }

    @Override
    public void dispose() {
        for (FunctionResult fr : this.listEntryFunctionMap.values()) {
            if (fr == null) continue;
            fr.dispose();
        }
        List<StandardImplicitConnectionPart> connParts = this.getImplicitConnections();
        for (StandardImplicitConnectionPart connPart : connParts) {
            connPart.dispose();
        }
    }

    public static abstract class DiagramImplicitConnectionTemplateListener {
        public void handleConnectionAddEvent(ConnectionAddEvent event) {
        }

        public void handleConnectionDeleteEvent(ConnectionDeleteEvent event) {
        }
    }

    private class NodeTemplateListener
    extends DiagramNodeTemplate.DiagramNodeTemplateListener {
        private NodeTemplateListener() {
        }

        @Override
        public void handleNodeAdd(DiagramNodePart nodePart) {
            DiagramImplicitConnectionTemplate.this.refreshImplicitConnections();
        }
    }
}

