/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEndpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.ConnectionServiceType;
import org.eclipse.sapphire.ui.diagram.def.DiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.NodeTemplateVisibilityEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.internal.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.internal.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.internal.DiagramImplicitConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.internal.StandardDiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.internal.StandardImplicitConnectionPart;
import org.eclipse.sapphire.util.ListFactory;

public class StandardConnectionService
extends ConnectionService {
    private SapphireDiagramEditorPagePart diagramPagePart;
    private DiagramEditorPageDef diagramPageDef;
    private List<IDiagramConnectionDef> connectionDefs;
    private Map<DiagramNodeTemplate, DiagramEmbeddedConnectionTemplate> embeddedConnectionTemplateMap;
    private List<DiagramConnectionTemplate> connectionTemplates;
    private List<DiagramImplicitConnectionTemplate> implicitConnectionTemplates;
    private ConnectionTemplateListener connTemplateListener;
    private ImplicitConnectionTemplateListener implicitConnTemplateListener;
    private Listener diagramNodeListener;
    private Listener diagramNodeTemplateListener;

    protected void init() {
        this.diagramPagePart = (SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class);
        this.diagramPageDef = this.diagramPagePart.getPageDef();
        this.connectionDefs = this.diagramPageDef.getDiagramConnectionDefs();
        this.embeddedConnectionTemplateMap = new HashMap<DiagramNodeTemplate, DiagramEmbeddedConnectionTemplate>();
        this.connTemplateListener = new ConnectionTemplateListener();
        this.implicitConnTemplateListener = new ImplicitConnectionTemplateListener();
        for (DiagramNodeTemplate nodeTemplate : this.diagramPagePart.getNodeTemplates()) {
            nodeTemplate.initEmbeddedConnections();
            if (nodeTemplate.getEmbeddedConnectionTemplate() == null) continue;
            nodeTemplate.getEmbeddedConnectionTemplate().addTemplateListener(this.connTemplateListener);
            this.embeddedConnectionTemplateMap.put(nodeTemplate, nodeTemplate.getEmbeddedConnectionTemplate());
        }
        this.connectionTemplates = new ArrayList<DiagramConnectionTemplate>();
        ElementList<IDiagramExplicitConnectionBindingDef> connectionBindings = this.diagramPageDef.getDiagramConnectionBindingDefs();
        for (IDiagramExplicitConnectionBindingDef connBinding : connectionBindings) {
            IDiagramConnectionDef connDef = this.getDiagramConnectionDef((String)connBinding.getConnectionId().content());
            DiagramConnectionTemplate connectionTemplate = new DiagramConnectionTemplate(connBinding);
            connectionTemplate.init(this.diagramPagePart, this.diagramPagePart.getLocalModelElement(), connDef, Collections.<String, String>emptyMap());
            connectionTemplate.initialize();
            this.connectionTemplates.add(connectionTemplate);
            connectionTemplate.addTemplateListener(this.connTemplateListener);
        }
        this.implicitConnectionTemplates = new ArrayList<DiagramImplicitConnectionTemplate>();
        ElementList<IDiagramImplicitConnectionBindingDef> implicitConnBindings = this.diagramPageDef.getImplicitConnectionBindingDefs();
        for (IDiagramImplicitConnectionBindingDef implicitConnBinding : implicitConnBindings) {
            IDiagramConnectionDef connDef = this.getDiagramConnectionDef((String)implicitConnBinding.getConnectionId().content());
            DiagramImplicitConnectionTemplate connectionTemplate = new DiagramImplicitConnectionTemplate(implicitConnBinding);
            connectionTemplate.init(this.diagramPagePart, this.diagramPagePart.getLocalModelElement(), connDef, Collections.<String, String>emptyMap());
            connectionTemplate.initialize();
            this.implicitConnectionTemplates.add(connectionTemplate);
            connectionTemplate.addTemplateListener(this.implicitConnTemplateListener);
        }
        this.diagramNodeListener = new FilteredListener<DiagramNodeEvent>(){

            protected void handleTypedEvent(DiagramNodeEvent event) {
                if (event.getNodeEventType() == DiagramNodeEvent.NodeEventType.NodeAboutToBeDeleted) {
                    StandardConnectionService.this.handleNodeAboutToBeDeleted((DiagramNodePart)event.getPart());
                } else if (event.getNodeEventType() == DiagramNodeEvent.NodeEventType.NodeAdded) {
                    StandardConnectionService.this.refreshAttachedConnections((DiagramNodePart)event.getPart());
                }
            }
        };
        this.diagramNodeTemplateListener = new FilteredListener<NodeTemplateVisibilityEvent>(){

            protected void handleTypedEvent(NodeTemplateVisibilityEvent event) {
                if (event.getNodeTemplate().visible()) {
                    StandardConnectionService.this.showAllAttachedConnections(event.getNodeTemplate());
                } else {
                    StandardConnectionService.this.hideAllAttachedConnections(event.getNodeTemplate());
                }
            }
        };
        this.diagramPagePart.attach(this.diagramNodeListener);
        this.diagramPagePart.attach(this.diagramNodeTemplateListener);
    }

    @Override
    public boolean valid(DiagramNodePart srcNode, DiagramNodePart targetNode, String connectionType) {
        DiagramConnectionTemplate connectionTemplate = this.getConnectionTemplate(srcNode, connectionType);
        if (connectionTemplate != null) {
            return connectionTemplate.canCreateNewConnection(srcNode, targetNode);
        }
        return false;
    }

    @Override
    public DiagramConnectionPart connect(DiagramNodePart srcNode, DiagramNodePart targetNode, String connectionType) {
        DiagramConnectionTemplate connectionTemplate = this.getConnectionTemplate(srcNode, connectionType);
        if (connectionTemplate != null) {
            StandardDiagramConnectionPart connection = connectionTemplate.createNewDiagramConnection(srcNode, targetNode);
            return connection;
        }
        return null;
    }

    @Override
    public List<DiagramConnectionPart> list() {
        ListFactory connections = ListFactory.start();
        for (DiagramConnectionTemplate diagramConnectionTemplate : this.getAllConnectionTemplates()) {
            for (DiagramConnectionPart diagramConnectionPart : diagramConnectionTemplate.getDiagramConnections(null)) {
                connections.add((Object)diagramConnectionPart);
            }
        }
        for (DiagramConnectionTemplate diagramConnectionTemplate : this.embeddedConnectionTemplateMap.values()) {
            for (DiagramConnectionPart diagramConnectionPart : diagramConnectionTemplate.getDiagramConnections(null)) {
                connections.add((Object)diagramConnectionPart);
            }
        }
        for (DiagramImplicitConnectionTemplate diagramImplicitConnectionTemplate : this.implicitConnectionTemplates) {
            for (StandardImplicitConnectionPart standardImplicitConnectionPart : diagramImplicitConnectionTemplate.getImplicitConnections()) {
                connections.add((Object)standardImplicitConnectionPart);
            }
        }
        return connections.result();
    }

    private void showAllAttachedConnections(DiagramNodeTemplate nodeTemplate) {
        if (nodeTemplate != null) {
            List<DiagramConnectionTemplate> connTemplates = this.getAllConnectionTemplates();
            for (DiagramConnectionTemplate connTemplate : connTemplates) {
                connTemplate.showAllConnectionParts(nodeTemplate);
            }
            DiagramEmbeddedConnectionTemplate embeddedConnTemplate = this.embeddedConnectionTemplateMap.get(nodeTemplate);
            if (embeddedConnTemplate != null) {
                embeddedConnTemplate.showAllConnectionParts(nodeTemplate);
            }
            this.refreshImplicitConnections();
        }
    }

    private void hideAllAttachedConnections(DiagramNodeTemplate nodeTemplate) {
        if (nodeTemplate != null) {
            List<DiagramConnectionTemplate> connTemplates = this.getAllConnectionTemplates();
            for (DiagramConnectionTemplate connTemplate : connTemplates) {
                connTemplate.hideAllConnectionParts(nodeTemplate);
            }
            DiagramEmbeddedConnectionTemplate embeddedConnTemplate = this.embeddedConnectionTemplateMap.get(nodeTemplate);
            if (embeddedConnTemplate != null) {
                embeddedConnTemplate.hideAllConnectionParts(nodeTemplate);
            }
            this.refreshImplicitConnections();
        }
    }

    private List<DiagramConnectionTemplate> getAllConnectionTemplates() {
        return this.connectionTemplates;
    }

    private IDiagramConnectionDef getDiagramConnectionDef(String connId) {
        if (connId == null) {
            throw new IllegalArgumentException();
        }
        IDiagramConnectionDef connDef = null;
        for (IDiagramConnectionDef def : this.connectionDefs) {
            String id = (String)def.getId().content();
            if (id == null || !id.equalsIgnoreCase(connId)) continue;
            connDef = def;
            break;
        }
        return connDef;
    }

    private DiagramConnectionTemplate getConnectionTemplate(DiagramNodePart srcNode, String connectionType) {
        DiagramConnectionTemplate connectionTemplate = null;
        DiagramEmbeddedConnectionTemplate embeddedConnTemplate = this.embeddedConnectionTemplateMap.get(srcNode.getDiagramNodeTemplate());
        if (embeddedConnTemplate != null && embeddedConnTemplate.getConnectionTypeId().equalsIgnoreCase(connectionType)) {
            connectionTemplate = embeddedConnTemplate;
        } else {
            for (DiagramConnectionTemplate connectionTemplate2 : this.getAllConnectionTemplates()) {
                if (!connectionTemplate2.getConnectionTypeId().equalsIgnoreCase(connectionType)) continue;
                connectionTemplate = connectionTemplate2;
                break;
            }
        }
        return connectionTemplate;
    }

    private void refreshImplicitConnections() {
        for (DiagramImplicitConnectionTemplate template : this.implicitConnectionTemplates) {
            template.refreshImplicitConnections();
        }
    }

    private void handleNodeAboutToBeDeleted(DiagramNodePart nodePart) {
        Element nodeModel = nodePart.getLocalModelElement();
        for (DiagramConnectionTemplate connTemplate : this.getAllConnectionTemplates()) {
            Element connParentElement;
            if (connTemplate.getConnectionType() != DiagramConnectionTemplate.ConnectionType.OneToMany || (connParentElement = connTemplate.getConnectionParentElement(nodeModel)) == null) continue;
            ElementList connParentList = (ElementList)connParentElement.parent();
            connParentList.remove((Object)connParentElement);
        }
    }

    private void refreshAttachedConnections(DiagramNodePart nodePart) {
        Element nodeElement = nodePart.getLocalModelElement();
        for (DiagramConnectionPart connPart : this.list()) {
            if (!connPart.removable() || connPart.getEndpoint1() != nodeElement && connPart.getEndpoint2() != nodeElement) continue;
            ConnectionAddEvent addEvent = new ConnectionAddEvent(connPart);
            this.broadcast(addEvent);
        }
    }

    public static final class Condition
    extends ServiceCondition {
        public boolean applicable(ServiceContext context) {
            SapphireDiagramEditorPagePart diagramPagePart;
            DiagramEditorPageDef pageDef;
            ISapphirePart part = (ISapphirePart)context.find(ISapphirePart.class);
            return part instanceof SapphireDiagramEditorPagePart && (pageDef = (diagramPagePart = (SapphireDiagramEditorPagePart)part).getPageDef()).getConnectionServiceType().content() == ConnectionServiceType.STANDARD;
        }
    }

    private final class ConnectionTemplateListener
    extends DiagramConnectionTemplate.DiagramConnectionTemplateListener {
        private ConnectionTemplateListener() {
        }

        @Override
        public void handleConnectionEndpointUpdate(ConnectionEndpointsEvent event) {
            StandardConnectionService.this.broadcast(event);
        }

        @Override
        public void handleConnectionAddEvent(ConnectionAddEvent event) {
            StandardConnectionService.this.broadcast(event);
        }

        @Override
        public void handleConnectionDeleteEvent(ConnectionDeleteEvent event) {
            StandardConnectionService.this.broadcast(event);
        }
    }

    private final class ImplicitConnectionTemplateListener
    extends DiagramImplicitConnectionTemplate.DiagramImplicitConnectionTemplateListener {
        private ImplicitConnectionTemplateListener() {
        }

        @Override
        public void handleConnectionAddEvent(ConnectionAddEvent event) {
            StandardConnectionService.this.broadcast(event);
        }

        @Override
        public void handleConnectionDeleteEvent(ConnectionDeleteEvent event) {
            StandardConnectionService.this.broadcast(event);
        }
    }
}

