/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.WithPart;

public final class RestoreInitialValueActionsAssistContributor
extends PropertyEditorAssistContributor {
    @Text(value="Restore initial value")
    private static LocalizableText restore;

    static {
        LocalizableText.init(RestoreInitialValueActionsAssistContributor.class);
    }

    public RestoreInitialValueActionsAssistContributor() {
        this.setId("System.RestoreInitialValueActionsContributor");
        this.setPriority(315);
    }

    @Override
    public void contribute(PropertyEditorAssistContext context) {
        Value value;
        InitialValueService initialValueService;
        SapphirePart part = context.getPart();
        ElementHandle<?> property = null;
        if (part instanceof PropertyEditorPart) {
            property = ((PropertyEditorPart)part).property();
        } else if (part instanceof WithPart) {
            property = ((WithPart)part).property();
        }
        if (property == null || property.definition().isReadOnly()) {
            return;
        }
        if (property instanceof Value && (initialValueService = (InitialValueService)(value = (Value)property).service(InitialValueService.class)) != null) {
            final String initialText = initialValueService.value();
            String currentText = value.text(false);
            if (initialText != null && !initialText.equals(currentText)) {
                PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + RestoreInitialValueActionsAssistContributor.escapeForXml(restore.text()) + "</a></p>");
                contribution.link("action", new Runnable(){

                    @Override
                    public void run() {
                        value.write((Object)initialText);
                    }
                });
                PropertyEditorAssistSection section = context.getSection("actions");
                section.addContribution(contribution.create());
            }
        }
    }
}

