/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.ImageData;

public final class PropertyEditorAssistContribution {
    private final String text;
    private final Map<String, ImageData> images;
    private final Map<String, Runnable> links;

    public static Factory factory() {
        return new Factory();
    }

    private PropertyEditorAssistContribution(String text, Map<String, ImageData> images, Map<String, Runnable> links) {
        this.text = text;
        this.images = Collections.unmodifiableMap(images);
        this.links = Collections.unmodifiableMap(links);
    }

    public final String text() {
        return this.text;
    }

    public final Map<String, ImageData> images() {
        return this.images;
    }

    public final ImageData image(String id) {
        return this.images.get(id);
    }

    public final Map<String, Runnable> links() {
        return this.links;
    }

    public final Runnable link(String id) {
        return this.links.get(id);
    }

    /* synthetic */ PropertyEditorAssistContribution(String string, Map map, Map map2, PropertyEditorAssistContribution propertyEditorAssistContribution) {
        this(string, map, map2);
    }

    public static final class Factory {
        private String text;
        private final Map<String, ImageData> images = new HashMap<String, ImageData>();
        private final Map<String, Runnable> links = new HashMap<String, Runnable>();

        private Factory() {
        }

        public Factory text(String text) {
            if (text == null) {
                throw new IllegalArgumentException();
            }
            this.text = text;
            return this;
        }

        public Factory image(String id, ImageData image) {
            if (id == null) {
                throw new IllegalArgumentException();
            }
            if (image == null) {
                throw new IllegalArgumentException();
            }
            this.images.put(id, image);
            return this;
        }

        public Factory link(String id, Runnable operation) {
            if (id == null) {
                throw new IllegalArgumentException();
            }
            if (operation == null) {
                throw new IllegalArgumentException();
            }
            this.links.put(id, operation);
            return this;
        }

        public PropertyEditorAssistContribution create() {
            if (this.text == null) {
                throw new IllegalStateException();
            }
            return new PropertyEditorAssistContribution(this.text, this.images, this.links, null);
        }
    }
}

