/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.adf.ui.wizard.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.ui.util.otn.OTNLoginWizardPage;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.ui.AsyncInstallCallback;
import oracle.eclipse.tools.webtier.adf.ui.wizard.internal.JRFInstallListener;
import oracle.eclipse.tools.webtier.adf.ui.wizard.internal.JRFInstaller;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class JRFInstallerDownloadWizard
extends Wizard {
    private JRFInstaller installer;
    private OTNLoginWizardPage otnLoginPage;
    private WebLogicServerInstall weblogicInstall = null;
    AsyncInstallCallback callback = null;
    private static Job installJrfJob = null;

    private JRFInstallerDownloadWizard(JRFInstaller installer, WebLogicServerInstall install, AsyncInstallCallback callback) {
        this.installer = installer;
        this.weblogicInstall = install;
        this.callback = callback;
        this.setWindowTitle(Resources.dialogTitle);
        this.setNeedsProgressMonitor(true);
    }

    public static String open(WebLogicServerInstall install, String jrfVersion, AsyncInstallCallback callback) {
        if (installJrfJob != null && (installJrfJob.getState() == 4 || installJrfJob.getState() == 4)) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Resources.warning, (String)Resources.adfInstallerAlreadyRunning);
            return "";
        }
        JRFInstaller installer = new JRFInstaller();
        installer.setName(String.valueOf(Resources.installerName) + jrfVersion);
        String url = JRFRuntimeUtil.getDownloadURL((String)jrfVersion);
        installer.setUrl(url);
        JRFInstallerDownloadWizard wizard = new JRFInstallerDownloadWizard(installer, install, callback);
        WizardDialog dlg = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        if (dlg.open() == 0) {
            return "";
        }
        return null;
    }

    public String getDownloadDestination() {
        String root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
        String downloadFolder = String.valueOf(root) + "/download";
        return downloadFolder;
    }

    public void addPages() {
        this.otnLoginPage = new OTNLoginWizardPage();
        this.addPage((IWizardPage)this.otnLoginPage);
    }

    public boolean canFinish() {
        boolean ret = this.otnLoginPage.validate();
        return ret;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        final String userName = this.otnLoginPage.getUserName();
        final String passwd = this.otnLoginPage.getPassword();
        this.otnLoginPage.persistLoginInfo();
        String dest = this.getDownloadDestination();
        final File destFolder = new File(dest);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Resources.dialogTitle, 100);
                        if (JRFInstallerDownloadWizard.this.installer.download(destFolder, userName, passwd, monitor)) {
                            monitor.worked(20);
                            monitor.setTaskName(Resources.progressInstalling);
                            JRFInstallerDownloadWizard.this.installer.install(JRFInstallerDownloadWizard.this.weblogicInstall, monitor, new JRFInstallListener(){

                                @Override
                                public void update(String msg) {
                                    monitor.setTaskName(msg);
                                }
                            });
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    JRFInstallerDownloadWizard.this.callback.done();
                    installJrfJob = null;
                }
            });
        }
        catch (InvocationTargetException e1) {
            Status sts = new Status(4, "oracle.eclipse.tools.adf.common.ui", Resources.transferErrorDialogTitle, JRFInstallerDownloadWizard.getRootCause(e1));
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Error", (String)Resources.transferErrorDialogTitle, (IStatus)sts);
            return false;
        }
        catch (InterruptedException e1) {
            Status sts = new Status(4, "oracle.eclipse.tools.adf.common.ui", Resources.transferErrorDialogTitle, JRFInstallerDownloadWizard.getRootCause(e1));
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Error", (String)Resources.transferErrorDialogTitle, (IStatus)sts);
            return false;
        }
        return true;
    }

    private static Throwable getRootCause(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null && e instanceof CoreException) {
            cause = ((CoreException)e).getStatus().getException();
        }
        if (cause != null) {
            return JRFInstallerDownloadWizard.getRootCause(cause);
        }
        return e;
    }

    private static final class Resources
    extends NLS {
        public static String dialogTitle;
        public static String transferErrorDialogTitle;
        public static String installerName;
        public static String progressInstalling;
        public static String warning;
        public static String adfInstallerAlreadyRunning;

        static {
            Resources.initializeMessages((String)JRFInstallerDownloadWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

