/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.adf.ui.wizard.internal;

import java.io.File;
import java.io.IOException;
import oracle.eclipse.tools.adf.common.ui.Activator;
import oracle.eclipse.tools.common.ui.util.otn.OTNDownloadUIUtil;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.util.FileUtil;
import oracle.eclipse.tools.webtier.adf.ui.wizard.internal.JRFInstallListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.util.internal.ZipUtil;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;

public final class JRFInstaller {
    private String name;
    private String url;
    private File targetFolder;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean download(File destFolder, String userName, String passwd, IProgressMonitor monitor) throws CoreException, InterruptedException {
        String fileName;
        File destFile;
        block5: {
            destFile = null;
            fileName = this.url.substring(this.url.lastIndexOf(47) + 1);
            destFolder.mkdirs();
            destFile = new File(destFolder, fileName);
            monitor.worked(10);
            if (destFile.exists() || this.download(this.url, destFile, userName, passwd, monitor)) break block5;
            return false;
        }
        try {
            monitor.worked(10);
            this.targetFolder = new File(destFolder, fileName.substring(0, fileName.lastIndexOf(46)));
            if (!this.targetFolder.exists()) {
                monitor.worked(10);
                ZipUtil.unzip((File)destFile, (File)this.targetFolder, (IProgressMonitor)monitor);
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
            destFile.delete();
            Status sts = new Status(2, "oracle.eclipse.tools.adf.common.ui", Resources.interruptedWhileDownloading);
            Activator.log((IStatus)sts);
            throw new CoreException((IStatus)sts);
        }
        catch (Exception e) {
            destFile.delete();
            String msg = String.valueOf(e.getMessage()) + ". ";
            msg = String.valueOf(msg) + Resources.manualDownload;
            Status sts = new Status(4, "oracle.eclipse.tools.adf.common.ui", msg);
            Activator.log((IStatus)sts);
            throw new CoreException((IStatus)sts);
        }
    }

    public void install(WebLogicServerInstall weblogicInstall, IProgressMonitor monitor, JRFInstallListener listener) {
        File defaultJvm;
        File installFolder = new File(this.targetFolder, "Disk1");
        if (!installFolder.exists() && !(installFolder = new File(this.targetFolder, String.valueOf(this.targetFolder.getName()) + "/Disk1")).exists()) {
            String msg = "Installer missing at " + this.targetFolder + "/Disk1";
            IStatus status = CorePlugin.createErrorStatus((String)msg, (Throwable)new Exception(msg));
            Activator.log(status);
            return;
        }
        String cmd = String.valueOf(installFolder.getAbsolutePath()) + "/setup.exe -waitforcompletion ";
        String jreLocation = null;
        File jvmLocationFile = JRFRuntimeUtil.getJDKHome((File)weblogicInstall.getLocation());
        jreLocation = jvmLocationFile == null ? (new File(defaultJvm = JavaRuntime.getDefaultVMInstall().getInstallLocation(), "jre").exists() ? String.valueOf(defaultJvm.getAbsolutePath()) + "/jre" : defaultJvm.getAbsolutePath()) : String.valueOf(jvmLocationFile.getAbsolutePath()) + "/jre";
        cmd = String.valueOf(cmd) + " -jreLoc " + jreLocation;
        File wlHome = weblogicInstall.getLocation();
        File mwHome = WlsRuntimeUtil.getMwHome((File)wlHome);
        cmd = String.valueOf(cmd) + " -silent MIDDLEWARE_HOME=" + mwHome.getAbsolutePath();
        cmd = String.valueOf(cmd) + " ORACLE_HOME=" + mwHome.getAbsolutePath() + "/oracle_common";
        cmd = String.valueOf(cmd) + " SPECIFY_DOWNLOAD_LOCATION=false";
        cmd = String.valueOf(cmd) + " SKIP_SOFTWARE_UPDATES=true";
        cmd = String.valueOf(cmd) + " SKIP_SOFTWARE_UPDATES=true";
        cmd = String.valueOf(cmd) + " APPSERVER_TYPE=WLS";
        listener.update("Launching Fusion Middleware Application Developer installer\n" + cmd);
        try {
            String[] command = new String[]{"cmd.exe", "/c", cmd};
            Process proc = Runtime.getRuntime().exec(command, null, installFolder);
            while (true) {
                try {
                    if (monitor.isCanceled()) {
                        proc.destroy();
                        FileUtil.deleteDirectory((File)new File(mwHome, "oracle_common"), (IProgressMonitor)monitor);
                        return;
                    }
                    Thread.sleep(1000L);
                    proc.exitValue();
                    this.updateWlsRuntime(weblogicInstall, monitor);
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            String msg = "Error executing installer";
            IStatus status = CorePlugin.createErrorStatus((String)msg, (Throwable)ioe);
            Activator.log(status);
        }
    }

    void updateWlsRuntime(WebLogicServerInstall weblogicInstall, IProgressMonitor monitor) {
        for (IRuntime rt : WebLogicServerUtil.getWebLogicRuntimes()) {
            File f = rt.getLocation().toFile();
            if (!f.equals(weblogicInstall.getLocation())) continue;
            monitor.setTaskName("Updating WebLogic runtime");
            IRuntimeWorkingCopy wc = rt.createWorkingCopy();
            try {
                ((RuntimeWorkingCopy)wc).setAttribute("JRFInstalled", true);
                wc.save(true, monitor);
            }
            catch (CoreException coreException) {}
        }
    }

    private boolean download(String downloadUrl, File destFile, String userName, String passwd, IProgressMonitor monitor) throws IOException, InterruptedException {
        monitor.setTaskName(Resources.progressConnecting);
        return OTNDownloadUIUtil.download((String)downloadUrl, (File)destFile, (String)userName, (String)passwd, (IProgressMonitor)monitor);
    }

    private static final class Resources
    extends NLS {
        public static String interruptedWhileDownloading;
        public static String failedWhileDownloading;
        public static String progressConnecting;
        public static String manualDownload;

        static {
            Resources.initializeMessages((String)JRFInstaller.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

