/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.adf.ui.internal;

import java.io.File;
import java.util.HashMap;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.ui.AsyncInstallCallback;
import oracle.eclipse.tools.weblogic.ui.WebLogicServerComponentHandler;
import oracle.eclipse.tools.webtier.adf.ui.wizard.internal.JRFInstallerDownloadWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class WebLogicServerAdfComponentHandler
extends WebLogicServerComponentHandler {
    private HashMap<File, String> versions = new HashMap();

    public String getName(WebLogicServerInstall install) {
        String installableVersion = JRFRuntimeUtil.getInstallableJRFVersion((WebLogicServerInstall)install);
        if (installableVersion == null) {
            String version = JRFRuntimeUtil.getJRFRuntimeImplVersion((File)install.getLocation());
            return String.valueOf(Resources.name) + " " + (version != null ? version : "");
        }
        return String.valueOf(Resources.name) + " " + installableVersion;
    }

    public boolean installable(WebLogicServerInstall install) {
        WebLogicServerVersion version = install.getVersion();
        return version.compareTo((Enum)WebLogicServerVersion.VERSION_10_3_4) >= 0 && version.compareTo((Enum)WebLogicServerVersion.VERSION_12_1_1) < 0;
    }

    public boolean applicable(WebLogicServerInstall install) {
        WebLogicServerVersion version = install.getVersion();
        return version.compareTo((Enum)WebLogicServerVersion.VERSION_10_3_4) >= 0 && !version.equals((Object)WebLogicServerVersion.VERSION_12_1_1);
    }

    public boolean installed(WebLogicServerInstall install) {
        String version = this.getVersion(install);
        if (version != null) {
            return true;
        }
        String installableVersion = JRFRuntimeUtil.getInstallableJRFVersion((WebLogicServerInstall)install);
        return installableVersion == null;
    }

    private String getVersion(WebLogicServerInstall install) {
        String cachedVersion = this.versions.get(install.getLocation());
        if (cachedVersion == null) {
            cachedVersion = JRFRuntimeUtil.getJRFRuntimeVersion((File)install.getLocation());
            this.versions.put(install.getLocation(), cachedVersion);
        }
        return cachedVersion;
    }

    public void install(WebLogicServerInstall install, Shell shell, AsyncInstallCallback callback) {
        String installableVersion = JRFRuntimeUtil.getInstallableJRFVersion((WebLogicServerInstall)install);
        JRFInstallerDownloadWizard.open(install, installableVersion, callback);
    }

    private static final class Resources
    extends NLS {
        public static String name;

        static {
            Resources.initializeMessages((String)WebLogicServerAdfComponentHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

