/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.wizard;

import oracle.eclipse.tools.adf.common.ui.quickstart.Messages;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewADFFileWizard;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewJSPTemplatesComposite;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.QuickLayaoutTemplateComposite;
import oracle.eclipse.tools.adf.dtrt.context.typed.IQuickPageLayoutContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NewADFTemplatePage
extends WizardPage {
    private static final String BTN_QUICK_LAYOUT_TEMPLATE = "btnQuickLayoutTemplate";
    private static final String BTN_TEMPLATE = "btnTemplate";
    private static final String BTN_EMPTY_PAGE = "btnEmptyPage";
    private Composite emptyComposite;
    private QuickLayaoutTemplateComposite quickLayoutComposite;
    private NewJSPTemplatesComposite newJSPTemplateComposite;
    private StackLayout stackLayout;
    private boolean useFragments;
    private boolean isFacelet;
    private Composite detailComposite;

    public NewADFTemplatePage(boolean useFragments, boolean isFacelet) {
        super("wizardPage");
        this.setTitle(Messages.NewADFContentWizardPage_title);
        this.setDescription(Messages.NewADFContentWizardPage_description);
        this.useFragments = useFragments;
        this.isFacelet = isFacelet;
    }

    private IFile getFile() {
        NewADFFileWizard wizard = (NewADFFileWizard)this.getWizard();
        return wizard.getFilePage().getFile();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(1, false));
        Composite masterComposite = new Composite(root, 0);
        masterComposite.setLayout((Layout)new GridLayout(3, false));
        masterComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.stackLayout = new StackLayout();
        this.detailComposite = new Composite(root, 0);
        this.detailComposite.setLayout((Layout)this.stackLayout);
        GridData data = new GridData(4, 4, true, true, 1, 1);
        data.widthHint = 850;
        data.heightHint = 650;
        this.detailComposite.setLayoutData((Object)data);
        Button btnEmptyPage = new Button(masterComposite, 16);
        btnEmptyPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewADFTemplatePage.this.update(NewADFTemplatePage.BTN_EMPTY_PAGE);
            }
        });
        btnEmptyPage.setText(Messages.NewADFTemplatePage_createBlank);
        Button btnQuickLayoutTemplate = new Button(masterComposite, 16);
        btnQuickLayoutTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewADFTemplatePage.this.update(NewADFTemplatePage.BTN_QUICK_LAYOUT_TEMPLATE);
            }
        });
        btnQuickLayoutTemplate.setText(Messages.NewADFTemplatePage_createQuickStart);
        Button btnTemplate = new Button(masterComposite, 16);
        btnTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewADFTemplatePage.this.update(NewADFTemplatePage.BTN_TEMPLATE);
            }
        });
        btnTemplate.setText(Messages.NewADFTemplatePage_createPageTemplate);
        this.emptyComposite = new Composite(this.detailComposite, 0);
        this.emptyComposite.setLayout((Layout)new FillLayout(256));
        this.quickLayoutComposite = new QuickLayaoutTemplateComposite(this.detailComposite, 0);
        this.quickLayoutComposite.setLayout((Layout)new FillLayout());
        this.newJSPTemplateComposite = new NewJSPTemplatesComposite(this.detailComposite, 0, this.useFragments, this.isFacelet);
        this.newJSPTemplateComposite.setLayout((Layout)new FillLayout());
        this.stackLayout.topControl = this.emptyComposite;
        this.detailComposite.layout();
        boolean btnEmptyPageSelection = this.getDialogSettings().getBoolean(BTN_EMPTY_PAGE);
        boolean btnQuickLayoutTemplateSelection = this.getDialogSettings().getBoolean(BTN_QUICK_LAYOUT_TEMPLATE);
        boolean btnTemplateSelection = this.getDialogSettings().getBoolean(BTN_TEMPLATE);
        if (btnEmptyPageSelection) {
            this.update(BTN_EMPTY_PAGE);
            btnEmptyPage.setSelection(true);
        } else if (btnQuickLayoutTemplateSelection) {
            this.update(BTN_QUICK_LAYOUT_TEMPLATE);
            btnQuickLayoutTemplate.setSelection(true);
        } else if (btnTemplateSelection) {
            this.update(BTN_TEMPLATE);
            btnTemplate.setSelection(true);
        } else {
            this.update(BTN_EMPTY_PAGE);
            btnEmptyPage.setSelection(true);
        }
        this.setControl((Control)root);
    }

    public void updateTemplates(boolean useFragment, boolean isFacelet) {
        this.newJSPTemplateComposite.updateTemplates(useFragment, isFacelet);
    }

    private void update(String btn) {
        boolean btnEmptyPageSelection = false;
        boolean btnQuickLayoutTemplateSelection = false;
        boolean btnTemplateSelection = false;
        if (BTN_EMPTY_PAGE.equals(btn)) {
            this.stackLayout.topControl = this.emptyComposite;
            this.detailComposite.layout();
            btnEmptyPageSelection = true;
            btnQuickLayoutTemplateSelection = false;
            btnTemplateSelection = false;
        } else if (BTN_QUICK_LAYOUT_TEMPLATE.equals(btn)) {
            this.stackLayout.topControl = this.quickLayoutComposite;
            this.detailComposite.layout();
            btnQuickLayoutTemplateSelection = true;
            btnEmptyPageSelection = false;
            btnTemplateSelection = false;
        } else if (BTN_TEMPLATE.equals(btn)) {
            this.stackLayout.topControl = this.newJSPTemplateComposite;
            this.detailComposite.layout();
            btnTemplateSelection = true;
            btnEmptyPageSelection = false;
            btnQuickLayoutTemplateSelection = false;
        } else {
            this.stackLayout.topControl = this.emptyComposite;
            this.detailComposite.layout();
            btnEmptyPageSelection = true;
            btnQuickLayoutTemplateSelection = false;
            btnTemplateSelection = false;
        }
        this.getDialogSettings().put(BTN_EMPTY_PAGE, btnEmptyPageSelection);
        this.getDialogSettings().put(BTN_QUICK_LAYOUT_TEMPLATE, btnQuickLayoutTemplateSelection);
        this.getDialogSettings().put(BTN_TEMPLATE, btnTemplateSelection);
        this.detailComposite.layout();
    }

    public IQuickPageLayoutContext.ILayout getLayout() {
        if (this.quickLayoutComposite != null) {
            return this.quickLayoutComposite.getQuickLayout();
        }
        return null;
    }

    public void saveLastSavedPreferences() {
        this.newJSPTemplateComposite.saveLastSavedPreferences();
    }

    public String getTemplateString() {
        return this.newJSPTemplateComposite.getTemplateString();
    }

    public boolean isTemplateSelected() {
        return this.stackLayout.topControl == this.newJSPTemplateComposite;
    }

    public boolean isQuickStartSelected() {
        return this.stackLayout.topControl == this.quickLayoutComposite;
    }

    public boolean isApplyTheme() {
        return this.quickLayoutComposite.isApplyTheme();
    }

    public void setContext(IQuickPageLayoutContext context) {
        this.quickLayoutComposite.setContext(context);
    }
}

