/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.wizard;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.common.ui.quickstart.Messages;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewADFFileWizard;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewADFTemplatePage;
import oracle.eclipse.tools.adf.dtrt.context.typed.IQuickPageLayoutContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class NewADFFileWizardPage
extends NewFileWizardPage {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    public static final String ADF_JSF_PAGE_EXTENSION = "jspx";
    public static final String ADF_JSF_FRAGMENT_EXTENSION = "jsff";
    public static final String ADF_JSF_FACELET_EXTENSION = "xhtml";
    public static final String ADF_JSF_FACELET_EXTENSION2 = "jsf";
    public static final String CONTAINER_SETTING = "containerSetting";
    public static final String PAGE_FRAG_SETTING = "pageOrFragmentSetting";
    public static final String IS_FACELET_SETTING = "isFaceletSetting";
    private Boolean isBoundTaskFlow = null;
    private boolean useFragments;
    private IProject _taskflowProject;
    private FileTypeComposite fileType;
    private Map<String, IQuickPageLayoutContext> contextCache = new HashMap<String, IQuickPageLayoutContext>();

    protected NewADFFileWizardPage(String pageName, IStructuredSelection selection, boolean useFragments, Boolean isBoundTaskFlow) {
        super(pageName, selection);
        this.useFragments = useFragments;
        this.isBoundTaskFlow = isBoundTaskFlow;
        this.setTitle(Messages.NewADFContentWizardPage_title);
        this.setDescription(Messages.NewADFContentWizardPage_description);
    }

    void setTaskflowProject(IProject project) {
        this._taskflowProject = project;
    }

    protected String getDefaultFileName() {
        return "NewFile";
    }

    protected String getDefaultFileExtension() {
        if (this.useFragments) {
            return ADF_JSF_FRAGMENT_EXTENSION;
        }
        if (this.isFacelet()) {
            return ADF_JSF_FACELET_EXTENSION;
        }
        return ADF_JSF_PAGE_EXTENSION;
    }

    protected boolean validatePage() {
        Project oepeProj;
        IProject project;
        IFile file = this.getFile();
        if (file != null && (project = file.getProject()) != null && project.exists() && (oepeProj = (Project)project.getAdapter(Project.class)) != null) {
            ITechnologyExtension jspVersion = oepeProj.getTechnologyExtensionById(ADF_JSF_FACELET_EXTENSION2);
            if (jspVersion != null && jspVersion.getVersion().startsWith("1.")) {
                this.fileType.updateToNoFaceletTechnology(true);
            } else if (jspVersion != null && jspVersion.getVersion().startsWith("2.")) {
                this.fileType.updateToNoFaceletTechnology(false);
            }
        }
        return super.validatePage();
    }

    protected boolean validateFile(IFile file) {
        if (file == null) {
            return false;
        }
        if (!this.extensionValid(file)) {
            String ext = this.getDefaultFileExtension();
            if (ext.equals(ADF_JSF_FACELET_EXTENSION)) {
                ext = "xhtml or jsf";
            }
            this.setErrorMessage(Messages.bind((String)Messages.NewADFContentWizardPage_error_bad_extension, (Object)ext));
            return false;
        }
        IPath fullPath = file.getFullPath();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(fullPath.toString(), 2);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        IProject project = file.getProject();
        if (project != null) {
            Project oepeProj = (Project)project.getAdapter(Project.class);
            if (oepeProj == null || oepeProj.getTechnologyExtensionById("adf.web") == null) {
                this.setErrorMessage(Messages.bind((String)Messages.NewADFContentWizardPage_error_bad_project, (Object)project.getName()));
                return false;
            }
            if (this._taskflowProject != null && !this._taskflowProject.equals((Object)project)) {
                this.setMessage(Messages.bind((String)Messages.NewADFContentWizardPage_error_taskflow_project, (Object)this._taskflowProject.getName()));
                return false;
            }
            if (WtpProjectUtil.isDynamicWebProject((IProject)project)) {
                IPath webContentPath = this.getWebContentPath(project);
                if (webContentPath != null && !webContentPath.isPrefixOf(fullPath)) {
                    this.setMessage(Messages.NewADFContentWizardPage_error_web_content, 2);
                    return false;
                }
            } else {
                this.setMessage(Messages.NewADFContentWizardPage_error_web_project, 2);
                return false;
            }
        }
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        if (this.getHelpContextID() != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)parent, this.getHelpContextID());
        }
        this._provider = this.createContainerContentProvider();
        this.createStructureControls(topLevel);
        this._resourceGroup = this.createContainerGroup(topLevel, (Listener)this, this.getNewFileLabel(), Messages.WizardNewFileCreationPage_file, this._provider, 250);
        this._resourceGroup.setAllowExistingResources(this.shouldAllowExistingResoures());
        this.initialPopulateContainerNameField();
        String path = this.getWizard().getDialogSettings().get(CONTAINER_SETTING);
        if (path != null && this._taskflowProject != null) {
            IContainer webRoot = ((NewADFFileWizard)this.getWizard()).getWebContentFolderIResource(this._taskflowProject);
            this._resourceGroup.setContainerFullPath(webRoot.getFullPath().append((IPath)new Path(path)));
        }
        this.createAdvancedControls(topLevel);
        if (this.getInitialFileName() != null) {
            this._resourceGroup.setResource(this.getInitialFileName());
        }
        this.updateExtension(this.getDefaultFileExtension());
        this.validatePage();
        if (!this.getPreValidate()) {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
        this.setControl((Control)topLevel);
    }

    private void createStructureControls(Composite topLevel) {
        String fragString = this.getWizard().getDialogSettings().get(PAGE_FRAG_SETTING);
        String faceString = this.getWizard().getDialogSettings().get(IS_FACELET_SETTING);
        boolean fragments = this.getWizard().getDialogSettings().getBoolean(PAGE_FRAG_SETTING);
        boolean facelet = this.getWizard().getDialogSettings().getBoolean(IS_FACELET_SETTING);
        if (this.isBoundTaskFlow == null) {
            if (fragString != null) {
                this.useFragments = fragments;
            }
            this.fileType = new FileTypeComposite(topLevel, 0, this.useFragments, faceString == null ? true : facelet);
        } else {
            this.fileType = new FileTypeComposite(topLevel, 0, this.useFragments, faceString == null ? this.isBoundTaskFlow : facelet);
        }
    }

    private boolean extensionValid(IFile file) {
        if (file != null) {
            if (this.getDefaultFileExtension().equals(file.getFileExtension())) {
                return true;
            }
            if (this.isFacelet() && file.getFileExtension().equals(ADF_JSF_FACELET_EXTENSION2)) {
                return true;
            }
        }
        return false;
    }

    private IPath getWebContentPath(IProject project) {
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            path = component.getRootFolder().getWorkspaceRelativePath();
        }
        return path;
    }

    public boolean isFacelet() {
        if (this.fileType != null) {
            return this.fileType.isFacelet();
        }
        return false;
    }

    public boolean isFragment() {
        if (this.fileType != null) {
            return this.fileType.isFragment();
        }
        return false;
    }

    protected void updateExtension(String ext) {
        String name;
        String extension = this.getFile() == null ? null : this.getFile().getFileExtension();
        String string = name = this.getFile() == null ? null : this.getFile().getName();
        if (extension == null || name == null || "".equals(extension)) {
            if (name == null) {
                name = this.getFileName();
                name = name.substring(0, name.lastIndexOf("."));
            }
            name = String.valueOf(name) + "." + ext;
        } else if (!ext.equals(extension)) {
            name = name.substring(0, name.length() - extension.length() - 1);
            name = String.valueOf(name) + "." + ext;
        }
        name = this.fixTheNameIfExist(name);
        this.setFileName(name);
    }

    private String fixTheNameIfExist(String oldName) {
        IPath path = this.getContainerFullPath();
        String ext = this.getDefaultFileExtension();
        String name = oldName;
        if (name.indexOf(46) > 0) {
            ext = name.substring(name.lastIndexOf(46) + 1, name.length());
            name = name.substring(0, name.indexOf(46));
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (path != null) {
            IFile file = root.getFile(path.append(String.valueOf(name) + "." + ext));
            String fixedName = null;
            int i = 1;
            while (file.exists()) {
                path.removeLastSegments(1);
                fixedName = String.valueOf(name) + i++;
                file = root.getFile(path.append(String.valueOf(fixedName) + "." + ext));
            }
            if (fixedName != null) {
                name = fixedName;
            }
        }
        return String.valueOf(name) + '.' + ext;
    }

    public boolean canFlipToNextPage() {
        IWizardPage nextPage;
        IFile file = this.getFile();
        if (file != null && (nextPage = this.getNextPage()) != null && nextPage instanceof NewADFTemplatePage) {
            IQuickPageLayoutContext context = this.getContext(file);
            ((NewADFTemplatePage)nextPage).setContext(context);
            ((NewADFTemplatePage)nextPage).updateTemplates(this.useFragments, this.isFacelet());
        }
        return super.canFlipToNextPage();
    }

    private IQuickPageLayoutContext getContext(IFile file) {
        String pn = file.getProject().getName();
        if (!this.contextCache.containsKey(pn)) {
            this.contextCache.put(pn, (IQuickPageLayoutContext)DTRTUtil.createContext((IResource)file, IQuickPageLayoutContext.class));
        }
        return this.contextCache.get(pn);
    }

    public void dispose() {
        if (this.contextCache != null) {
            for (IQuickPageLayoutContext context : this.contextCache.values()) {
                context.dispose();
            }
        }
        super.dispose();
    }

    public class FileTypeComposite
    extends Composite {
        private Button faceletsButton;
        private boolean isPage;
        private boolean isFacelet;
        private Button xmlJsp;

        public FileTypeComposite(Composite parent, int style, boolean fragment, boolean facelet) {
            super(parent, style);
            this.isFacelet = facelet;
            this.isPage = !fragment;
            this.setLayout((Layout)new FillLayout(256));
            Composite c = new Composite((Composite)this, 0);
            RowLayout layout = new RowLayout(256);
            layout.marginLeft = 0;
            layout.spacing = 10;
            layout.marginWidth = 0;
            c.setLayout((Layout)layout);
            Composite grpStructure = new Composite(c, 0);
            RowLayout rl_grpStructure = new RowLayout(256);
            rl_grpStructure.marginRight = 20;
            rl_grpStructure.marginLeft = 0;
            rl_grpStructure.spacing = 10;
            grpStructure.setLayout((Layout)rl_grpStructure);
            Label label = new Label(grpStructure, 0);
            label.setText(Messages.NewADFFileWizardPage_structure);
            Button pageButton = new Button(grpStructure, 16);
            pageButton.setText(Messages.NewADFFileWizardPage_page);
            pageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        NewADFFileWizardPage.this.useFragments = false;
                        FileTypeComposite.this.isPage = true;
                        NewADFFileWizardPage.this.updateExtension(FileTypeComposite.this.isFacelet() ? NewADFFileWizardPage.ADF_JSF_FACELET_EXTENSION : NewADFFileWizardPage.ADF_JSF_PAGE_EXTENSION);
                        ((NewADFTemplatePage)NewADFFileWizardPage.this.getNextPage()).updateTemplates(NewADFFileWizardPage.this.useFragments, FileTypeComposite.this.isFacelet());
                    }
                }
            });
            if (NewADFFileWizardPage.this.isBoundTaskFlow != null) {
                pageButton.setEnabled(!fragment);
            }
            pageButton.setSelection(!fragment);
            Button fragmentButton = new Button(grpStructure, 16);
            fragmentButton.setText(Messages.NewADFFileWizardPage_pageFragment);
            fragmentButton.setSelection(fragment);
            fragmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        NewADFFileWizardPage.this.useFragments = true;
                        FileTypeComposite.this.isPage = false;
                        NewADFFileWizardPage.this.updateExtension(NewADFFileWizardPage.ADF_JSF_FRAGMENT_EXTENSION);
                        ((NewADFTemplatePage)NewADFFileWizardPage.this.getNextPage()).updateTemplates(NewADFFileWizardPage.this.useFragments, FileTypeComposite.this.isFacelet());
                    }
                }
            });
            if (NewADFFileWizardPage.this.isBoundTaskFlow != null) {
                fragmentButton.setEnabled(fragment);
            }
            fragmentButton.setSelection(fragment);
            Composite grpTechnology = new Composite(c, 0);
            RowLayout rl_grpTechnology = new RowLayout(256);
            rl_grpTechnology.spacing = 10;
            grpTechnology.setLayout((Layout)rl_grpTechnology);
            Label techLabel = new Label(grpTechnology, 0);
            techLabel.setText(Messages.NewADFFileWizardPage_technology);
            this.faceletsButton = new Button(grpTechnology, 16);
            this.faceletsButton.setText(Messages.NewADFFileWizardPage_facelets);
            this.faceletsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileTypeComposite.this.isFacelet = FileTypeComposite.this.faceletsButton.getSelection();
                    NewADFFileWizardPage.this.updateExtension(FileTypeComposite.this.isFragment() ? NewADFFileWizardPage.ADF_JSF_FRAGMENT_EXTENSION : NewADFFileWizardPage.ADF_JSF_FACELET_EXTENSION);
                    ((NewADFTemplatePage)NewADFFileWizardPage.this.getNextPage()).updateTemplates(NewADFFileWizardPage.this.useFragments, FileTypeComposite.this.isFacelet());
                }
            });
            this.faceletsButton.setSelection(this.isFacelet);
            this.xmlJsp = new Button(grpTechnology, 16);
            this.xmlJsp.setText(Messages.NewADFFileWizardPage_jspXml);
            this.xmlJsp.setSelection(!facelet);
            this.xmlJsp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileTypeComposite.this.isFacelet = !FileTypeComposite.this.xmlJsp.getSelection();
                    NewADFFileWizardPage.this.updateExtension(FileTypeComposite.this.isFragment() ? NewADFFileWizardPage.ADF_JSF_FRAGMENT_EXTENSION : NewADFFileWizardPage.ADF_JSF_PAGE_EXTENSION);
                    ((NewADFTemplatePage)NewADFFileWizardPage.this.getNextPage()).updateTemplates(NewADFFileWizardPage.this.useFragments, FileTypeComposite.this.isFacelet());
                }
            });
        }

        protected void checkSubclass() {
        }

        public boolean isFacelet() {
            return this.isFacelet;
        }

        public boolean isFragment() {
            return !this.isPage;
        }

        void updateToNoFaceletTechnology(boolean noFaceletSupport) {
            if (noFaceletSupport) {
                this.faceletsButton.setSelection(false);
                this.faceletsButton.setEnabled(false);
                this.xmlJsp.setSelection(true);
                this.isFacelet = false;
            } else {
                this.faceletsButton.setEnabled(true);
            }
        }
    }
}

