/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.eclipse.tools.adf.common.ui.Activator;
import oracle.eclipse.tools.adf.common.ui.quickstart.Messages;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.BaseLayoutProvider;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.FlowItem;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.IPresentationVariation;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.PresentationVariation;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.PresentationVariationComposite;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.QuickStartCategory;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.QuickStartFlowItem;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.QuickStartLayout;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewADFFileWizard;
import oracle.eclipse.tools.adf.dtrt.context.typed.IQuickPageLayoutContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QuickStartLayoutProvider
extends BaseLayoutProvider {
    static final String QUICKSTART_CONFIGURATION_NS = "http://xmlns.oracle.com/jdeveloper/webapp/quickstart/layouts";
    private static final String _NO_STATE = "__nostate";
    private static final Map<String, String> _COMMON_NAMESPACES = new HashMap<String, String>();
    private static final String MASTER = "masterLayoutDialogSetting";
    private static final String CHILD = "childLayoutDialogSetting";
    private Composite mainComposite;
    private boolean _isCreated = false;
    private List<QuickStartCategory> _categories = new ArrayList<QuickStartCategory>();
    private Map<String, String> _prefixMappings;
    private Composite _contentPanel;
    private final Color _colorListBackground;
    private final Color _colorListSelection;
    private float _rank;
    private String _name;
    private String _graphic;
    private ImageIcon _imageIcon;
    private ResourceBundle _bundle;
    private String _selectedLayout;
    private ClassLoader classloader;
    private String path;
    private final List<PresentationVariationComposite> _masterVariations = new ArrayList<PresentationVariationComposite>();
    private PresentationVariationComposite _selectedMaster;
    private final SelectionListener _masterVariationsSelectionListener = new MySelectionListener();
    private final PropertyChangeListener _detailsPropertyChangeListener = new MyPropertyChangeListener();
    private Composite _detailsContentPanel;
    private StackLayout _detailsContentLayout = new StackLayout();
    private Label _descriptionLabel;

    static {
        _COMMON_NAMESPACES.put("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    public QuickStartLayoutProvider(ClassLoader classloader, String path) {
        this.classloader = classloader;
        this.path = path;
        Display display = Display.getCurrent();
        this._colorListBackground = display.getSystemColor(25);
        this._colorListSelection = display.getSystemColor(26);
    }

    public String getName() {
        this._ensureInit();
        return this._name;
    }

    public ImageIcon getImage() {
        this._ensureInit();
        if (this._imageIcon == null) {
            this._imageIcon = new ImageIcon(this.classloader.getResource(this._graphic));
        }
        return this._imageIcon;
    }

    public Object getSelectionPanel(Object p) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        Composite parent = (Composite)p;
        this._ensureInit();
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setFont(parent.getFont());
        GridData gd = new GridData(4, 4, true, true);
        this.mainComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)layout);
        Composite masterPanel = new Composite(this.mainComposite, 0);
        masterPanel.setFont(this.mainComposite.getFont());
        masterPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout();
        layout.numColumns = 2;
        masterPanel.setLayout((Layout)layout);
        this.createMasterVariationsComposite(masterPanel);
        this.createDescriptionComposite(masterPanel);
        Composite detailsContainer = new Composite(this.mainComposite, 0);
        detailsContainer.setFont(this.mainComposite.getFont());
        detailsContainer.setLayoutData((Object)new GridData(4, 1024, true, false));
        layout = new GridLayout();
        layout.numColumns = 1;
        detailsContainer.setLayout((Layout)layout);
        Label detailsLabel = new Label(detailsContainer, 16384);
        detailsLabel.setText(Messages.QS_LAYOUTS);
        GridData data = new GridData(16384, 0x1000000, true, false);
        detailsLabel.setLayoutData((Object)data);
        this.createDetailsPanel(detailsContainer);
        this.updateModel();
        ArrayList<QuickStartFlowItem> flows = new ArrayList<QuickStartFlowItem>(this._categories.size());
        for (QuickStartCategory category : this._categories) {
            flows.add(new QuickStartFlowItem(category));
        }
        this.updateDescriptionLabel();
        if (this._selectedLayout != null) {
            QuickStartFlowItem selLay = null;
            for (QuickStartFlowItem cat : flows) {
                for (QuickStartFlowItem quickStartFlowItem : cat.getChildren()) {
                    QuickStartLayout qsLayout = quickStartFlowItem.getLayout();
                    if (!qsLayout.getName().equals(this._selectedLayout)) continue;
                    selLay = quickStartFlowItem;
                    break;
                }
                if (selLay != null) break;
            }
        }
        return this.mainComposite;
    }

    public IDialogSettings getDialogSettings() {
        String name = NewADFFileWizard.class.getName();
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings wizardDialogSettings = dialogSettings.getSection(name);
        if (wizardDialogSettings == null) {
            wizardDialogSettings = dialogSettings.addNewSection(name);
        }
        return wizardDialogSettings;
    }

    public PresentationVariationComposite getInitialSelectionFor(String type, List<PresentationVariationComposite> childs) {
        String name = this.getDialogSettings().get(type);
        if (name != null) {
            for (PresentationVariationComposite child : childs) {
                if (!child.getPresentationVariation().getName().equals(name)) continue;
                return child;
            }
        }
        return childs.get(0);
    }

    private void updateModel() {
        if (this._selectedMaster == null) {
            return;
        }
        IPresentationVariation variation = this._selectedMaster.getPresentationVariation();
        if (variation != null) {
            DetailsComposite dc = (DetailsComposite)this._selectedMaster.getDetailsComposite();
            IPresentationVariation childVariation = dc.getSelectedDetail().getPresentationVariation();
            this._selectedLayout = childVariation != null ? childVariation.getName() : variation.getName();
        }
    }

    private void saveDialogSettings(String type, String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(type, name);
    }

    private void createMasterVariationsComposite(Composite parent) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 2560);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 280;
        gd.widthHint = 485;
        scrollComposite.setLayoutData((Object)gd);
        FillLayout scrollLayout = new FillLayout();
        scrollComposite.setLayout((Layout)scrollLayout);
        final Composite composite = new Composite((Composite)scrollComposite, 0);
        composite.setFont(parent.getFont());
        RowLayout layout = new RowLayout();
        layout.wrap = true;
        composite.setLayout((Layout)layout);
        composite.setBackground(this._colorListBackground);
        scrollComposite.setContent((Control)composite);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setMinHeight(150);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollComposite.getClientArea();
                scrollComposite.setMinSize(composite.computeSize(r.width, -1));
            }
        });
        List<IPresentationVariation> variations = this.getPresentationVariations();
        if (variations != null && !variations.isEmpty()) {
            for (IPresentationVariation pv : variations) {
                PresentationVariationComposite pvComposite = new PresentationVariationComposite(composite, 0, pv, false);
                pvComposite.addSelectionListener(this._masterVariationsSelectionListener);
                this._masterVariations.add(pvComposite);
            }
            if (!this._masterVariations.isEmpty()) {
                this._selectedMaster = this.getInitialSelectionFor(MASTER, this._masterVariations);
                this._selectedMaster.setBackground(this._colorListSelection);
            }
        }
    }

    private void createDetailsPanel(Composite parent) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 2560);
        GridData gd = new GridData();
        gd.minimumHeight = 115;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        scrollComposite.setLayoutData((Object)gd);
        RowLayout scrollLayout = new RowLayout();
        scrollLayout.wrap = true;
        scrollComposite.setLayout((Layout)scrollLayout);
        this._detailsContentPanel = new Composite((Composite)scrollComposite, 0);
        this._detailsContentPanel.setLayout((Layout)this._detailsContentLayout);
        scrollComposite.setContent((Control)this._detailsContentPanel);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setMinHeight(150);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollComposite.getClientArea();
                scrollComposite.setMinSize(QuickStartLayoutProvider.this._detailsContentPanel.computeSize(r.width, -1));
            }
        });
        for (PresentationVariationComposite masterComposite : this._masterVariations) {
            DetailsComposite detailsComposite = new DetailsComposite(this._detailsContentPanel, 0, masterComposite.getPresentationVariation());
            detailsComposite.addPropertyChangeListener(this._detailsPropertyChangeListener);
            masterComposite.setDetailsComposite(detailsComposite);
        }
        if (!this._masterVariations.isEmpty()) {
            this._detailsContentLayout.topControl = this._selectedMaster.getDetailsComposite();
            this._detailsContentPanel.layout();
        }
    }

    private void createDescriptionComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._descriptionLabel = new Label(composite, 64);
        GridData data = new GridData(4, 128, true, false);
        data.widthHint = 280;
        this._descriptionLabel.setLayoutData((Object)data);
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        QuickStartLegendPanel legend = new QuickStartLegendPanel(composite);
        GridData data1 = new GridData(4, 4, true, true);
        data1.widthHint = 280;
        legend.setLayoutData(data1);
        this.updateDescriptionLabel();
    }

    private void updateDescriptionLabel() {
        String description = "";
        if (this._selectedLayout != null) {
            if (this._selectedMaster != null) {
                DetailsComposite dc = (DetailsComposite)this._selectedMaster.getDetailsComposite();
                IPresentationVariation childVariation = dc.getSelectedDetail().getPresentationVariation();
                description = childVariation.getDescription();
            }
        } else if (this._selectedMaster != null) {
            IPresentationVariation masterVariation = this._selectedMaster.getPresentationVariation();
            description = masterVariation.getHelpText();
        }
        if (this._descriptionLabel != null) {
            this._descriptionLabel.setText(description);
            this._descriptionLabel.getParent().layout();
        }
    }

    private List<IPresentationVariation> getPresentationVariations() {
        ArrayList<IPresentationVariation> result = new ArrayList<IPresentationVariation>(this._categories.size());
        for (QuickStartCategory category : this._categories) {
            result.add(this.createPresentationFromFlow(new QuickStartFlowItem(category)));
        }
        return result;
    }

    private IPresentationVariation createPresentationFromFlow(QuickStartFlowItem flow) {
        ArrayList<IPresentationVariation> children = new ArrayList<IPresentationVariation>(flow.getChildren().size());
        for (FlowItem flowItem : flow.getChildren()) {
            PresentationVariation variation = new PresentationVariation(flowItem.getDescription(), flowItem.getDescription(), flowItem.getLabel(), flowItem.getImagePath(), null, null);
            children.add(variation);
        }
        return new PresentationVariation(flow.getLabel(), flow.getLabel(), flow.getDescription(), flow.getImagePath(), null, children);
    }

    public boolean isApplicable(IQuickPageLayoutContext.ILayoutProvider.LayoutUse use) {
        return true;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this._isCreated = false;
        this._contentPanel = null;
        this._categories = null;
        this._prefixMappings = null;
        this._selectedLayout = null;
    }

    @Override
    public String saveState(IQuickPageLayoutContext.ILayoutProvider.LayoutUse layoutUse) {
        IQuickPageLayoutContext.ILayout layout = this.getCurrentLayout();
        return layout != null ? layout.getName() : _NO_STATE;
    }

    @Override
    public void restoreState(String state, IQuickPageLayoutContext.ILayoutProvider.LayoutUse layoutUse) {
        if (state != null) {
            this._selectedLayout = state;
        }
    }

    public IQuickPageLayoutContext.ILayout getCurrentLayout() {
        this._ensureInit();
        if (this._contentPanel == null) {
            if (this._selectedLayout != null) {
                for (QuickStartCategory cat : this._categories) {
                    for (QuickStartLayout layout : cat.getLayouts()) {
                        if (!layout.getName().equals(this._selectedLayout)) continue;
                        return layout;
                    }
                }
            }
            return this._categories.get(0).getLayouts().get(0);
        }
        return ((QuickStartFlowItem)this._contentPanel.getData()).getLayout();
    }

    public float getRank() {
        this._ensureInit();
        return this._rank;
    }

    private void _ensureInit() {
        if (this._isCreated) {
            return;
        }
        try {
            Element metadata;
            InputStream is = this.classloader.getResourceAsStream(this.path);
            if (is == null) {
                return;
            }
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document creatorDoc = docBuilder.parse(is);
            Element rootElement = creatorDoc.getDocumentElement();
            QuickStartLayoutProvider.__checkQuickstartElement("quickStartLayouts", rootElement);
            Element prefixMappingsElem = this._getFirstChildElementByName(rootElement, "prefixMappings");
            if (prefixMappingsElem != null) {
                if (this._prefixMappings == null) {
                    this._prefixMappings = new HashMap<String, String>(7, 0.75f);
                }
                Node prefixMapping = prefixMappingsElem.getFirstChild();
                while (prefixMapping != null) {
                    if (1 == prefixMapping.getNodeType()) {
                        Element prefixMappingElem = (Element)prefixMapping;
                        QuickStartLayoutProvider.__checkQuickstartElement("prefixMapping", prefixMappingElem);
                        String prefix = prefixMappingElem.getAttributeNS(null, "prefix");
                        if (prefix == null || "".equals(prefix)) {
                            throw new IllegalStateException("mapping with null prefix found");
                        }
                        String namespace = prefixMappingElem.getAttributeNS(null, "namespace");
                        if (namespace == null || "".equals(namespace)) {
                            throw new IllegalStateException("mapping with null namespace found");
                        }
                        this._prefixMappings.put(prefix, namespace);
                    }
                    prefixMapping = prefixMapping.getNextSibling();
                }
            }
            if ((metadata = this._getFirstChildElementByName(rootElement, "metadata")) == null) {
                throw new IllegalStateException("No metadata found for layout provider configuration");
            }
            String rank = metadata.getAttributeNS(null, "rank");
            String graphic = metadata.getAttributeNS(null, "graphic");
            String resourceBundle = metadata.getAttributeNS(null, "resourceBundle");
            if (rank == null || "".equals(rank)) {
                throw new IllegalStateException("Layout providers must supply a rank attribute in the metadata section");
            }
            try {
                this._rank = Float.parseFloat(rank);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Could not parse the rank, please make sure it is a valid float");
            }
            if (graphic == null || "".equals(graphic)) {
                throw new IllegalStateException("Layout providers must supply a graphic attribute in the metadata section");
            }
            this._graphic = graphic;
            ResourceBundle bundle = null;
            if (resourceBundle != null && !"".equals(resourceBundle)) {
                bundle = ResourceBundle.getBundle(resourceBundle);
            }
            this._bundle = bundle;
            if (this._prefixMappings == null) {
                this._prefixMappings = _COMMON_NAMESPACES;
            } else {
                this._prefixMappings.putAll(_COMMON_NAMESPACES);
            }
            String id = metadata.getAttributeNS(null, "id");
            String name = metadata.getAttributeNS(null, "name");
            if (id != null && !"".equals(id)) {
                this._name = this._bundle.getString(id);
            } else if (name != null && "".equals(name)) {
                this._name = name;
            }
            if (this._name == null) {
                throw new IllegalStateException("Layout providers must supply an id or name attribute in the metadata section");
            }
            Element layouts = this._getFirstChildElementByName(rootElement, "layouts");
            ArrayList<QuickStartCategory> categories = new ArrayList<QuickStartCategory>();
            Node child = layouts.getFirstChild();
            while (child != null) {
                if (1 == child.getNodeType()) {
                    Element qscElem = (Element)child;
                    QuickStartLayoutProvider.__checkQuickstartElement("category", qscElem);
                    QuickStartCategory qsc = new QuickStartCategory(this.classloader, qscElem, this);
                    categories.add(qsc);
                }
                child = child.getNextSibling();
            }
            if (this._categories == null) {
                this._categories = new ArrayList<QuickStartCategory>();
            }
            this._categories.addAll(categories);
            this._isCreated = true;
        }
        catch (Exception e) {
            Activator.log(e);
            System.out.println(e);
            this._categories = Collections.emptyList();
        }
    }

    static void __checkQuickstartElement(String localName, Element e) {
        if (e == null) {
            throw new IllegalStateException("element: " + localName + " expected.");
        }
        if (!localName.equals(e.getLocalName())) {
            throw new IllegalStateException("localName: " + localName + " expected.");
        }
        if (!QUICKSTART_CONFIGURATION_NS.equals(e.getNamespaceURI())) {
            throw new IllegalStateException("element not in the quickstart ns");
        }
    }

    Map<String, String> __getPrefixMappings() {
        return this._prefixMappings;
    }

    String __getResource(String key) {
        if (this._bundle == null) {
            return null;
        }
        return this._bundle.getString(key);
    }

    private Element _getFirstChildElementByName(Element parent, String name) {
        Node child;
        NodeList children = parent.getElementsByTagNameNS(QUICKSTART_CONFIGURATION_NS, name);
        if (children.getLength() > 0 && (child = children.item(0)) != null && child.getNodeType() == 1) {
            return (Element)child;
        }
        return null;
    }

    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        if (this._colorListBackground != null) {
            this._colorListBackground.dispose();
        }
        if (this._colorListSelection != null) {
            this._colorListSelection.dispose();
        }
    }

    private class DetailsComposite
    extends Composite
    implements SelectionListener {
        public static final String PROP_DETAIL_SELECTED = "Detail Selected";
        private final List<PresentationVariationComposite> _childDetails;
        private PresentationVariationComposite _selectedDetail;
        private PropertyChangeSupport _propChangeSupport;

        public DetailsComposite(Composite parent, int style, IPresentationVariation masterVariation) {
            super(parent, style);
            this._childDetails = new ArrayList<PresentationVariationComposite>();
            this._propChangeSupport = new PropertyChangeSupport((Object)this);
            List<IPresentationVariation> childVariations = masterVariation.getChildren();
            if (childVariations != null && !childVariations.isEmpty()) {
                RowLayout layout = new RowLayout();
                layout.wrap = true;
                this.setLayout((Layout)layout);
                this.setBackground(QuickStartLayoutProvider.this._colorListBackground);
                for (IPresentationVariation childVariation : childVariations) {
                    PresentationVariationComposite childDetail = new PresentationVariationComposite(this, 0, childVariation, true);
                    childDetail.addSelectionListener(this);
                    this._childDetails.add(childDetail);
                }
                if (!this._childDetails.isEmpty()) {
                    this._selectedDetail = QuickStartLayoutProvider.this.getInitialSelectionFor(QuickStartLayoutProvider.CHILD, this._childDetails);
                    this._selectedDetail.setBackground(QuickStartLayoutProvider.this._colorListSelection);
                }
            }
        }

        public void dispose() {
            for (PresentationVariationComposite childDetail : this._childDetails) {
                childDetail.removeSelectionListener(this);
            }
            this._childDetails.clear();
        }

        public PresentationVariationComposite getSelectedDetail() {
            return this._selectedDetail;
        }

        public void widgetSelected(SelectionEvent e) {
            this._selectedDetail.setBackground(QuickStartLayoutProvider.this._colorListBackground);
            PresentationVariationComposite oldSelection = this._selectedDetail;
            this._selectedDetail = (PresentationVariationComposite)e.widget;
            this._selectedDetail.setBackground(QuickStartLayoutProvider.this._colorListSelection);
            QuickStartLayoutProvider.this.saveDialogSettings(QuickStartLayoutProvider.CHILD, this._selectedDetail.getPresentationVariation().getName());
            this._propChangeSupport.firePropertyChange(PROP_DETAIL_SELECTED, (Object)oldSelection, (Object)this._selectedDetail);
            QuickStartLayoutProvider.this.updateDescriptionLabel();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._propChangeSupport.addPropertyChangeListener(listener);
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("Detail Selected".equals(event.getPropertyName())) {
                QuickStartLayoutProvider.this.updateModel();
            }
        }
    }

    private class MySelectionListener
    extends SelectionAdapter {
        private MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (QuickStartLayoutProvider.this._selectedMaster != null) {
                QuickStartLayoutProvider.this._selectedMaster.setBackground(QuickStartLayoutProvider.this._colorListBackground);
            }
            QuickStartLayoutProvider.this._selectedMaster = (PresentationVariationComposite)event.widget;
            QuickStartLayoutProvider.this._selectedMaster.setBackground(QuickStartLayoutProvider.this._colorListSelection);
            QuickStartLayoutProvider.this.saveDialogSettings(QuickStartLayoutProvider.MASTER, QuickStartLayoutProvider.this._selectedMaster.getPresentationVariation().getName());
            QuickStartLayoutProvider.this.updateDescriptionLabel();
            ((QuickStartLayoutProvider)QuickStartLayoutProvider.this)._detailsContentLayout.topControl = QuickStartLayoutProvider.this._selectedMaster.getDetailsComposite();
            QuickStartLayoutProvider.this._detailsContentPanel.layout();
            QuickStartLayoutProvider.this.updateModel();
        }
    }

    protected static final class QuickStartLegendPanel
    extends Composite {
        public QuickStartLegendPanel(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(1, false));
            Composite le = new Composite((Composite)this, 0);
            le.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this._createLegendEntry(le, "stretch.png", Messages.QS_HELP_MOVE);
            this._createLegendEntry(le, "fixed.png", Messages.QS_HELP_FIXED);
            this._createLegendEntry(le, "splitter.png", Messages.QS_HELP_SPLITTER);
            this._createLegendEntry(le, "scroll.png", Messages.QS_HELP_SCROLL);
            Label label = new Label((Composite)this, 258);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            Composite te = new Composite((Composite)this, 0);
            te.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            te.setLayout((Layout)new GridLayout(1, false));
            Label descLabel = new Label(te, 0x1000040);
            descLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            descLabel.setText(Messages.QS_FURTHER_INSTR);
        }

        private void _createLegendEntry(Composite parent, String name, String desc) {
            Image imgWidget = Activator.getDefault().getImage("images/legend/" + name);
            GridLayout gl_le = new GridLayout(2, false);
            gl_le.marginHeight = 0;
            parent.setLayout((Layout)gl_le);
            Label imgLabel = new Label(parent, 16384);
            imgLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            imgLabel.setImage(imgWidget);
            Label descLabel = new Label(parent, 0x1000040);
            descLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            descLabel.setText(desc);
        }
    }
}

