/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.html.model.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Shape implements Enumerator
{
    RECT(0, "rect", "rect"),
    CIRCLE(1, "circle", "circle"),
    POLY(2, "poly", "poly"),
    DEFAULT(3, "default", "default");

    public static final int RECT_VALUE = 0;
    public static final int CIRCLE_VALUE = 1;
    public static final int POLY_VALUE = 2;
    public static final int DEFAULT_VALUE = 3;
    private static final Shape[] VALUES_ARRAY;
    public static final List<Shape> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Shape[]{RECT, CIRCLE, POLY, DEFAULT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Shape get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Shape result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Shape getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Shape result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Shape get(int value) {
        switch (value) {
            case 0: {
                return RECT;
            }
            case 1: {
                return CIRCLE;
            }
            case 2: {
                return POLY;
            }
            case 3: {
                return DEFAULT;
            }
        }
        return null;
    }

    private Shape(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

