/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.html.model.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InputType implements Enumerator
{
    TEXT(0, "text", "text"),
    PASSWORD(1, "password", "password"),
    CHECKBOX(2, "checkbox", "checkbox"),
    RADIO(3, "radio", "radio"),
    SUBMIT(4, "submit", "submit"),
    RESET(5, "reset", "reset"),
    FILE(6, "file", "file"),
    HIDDEN(7, "hidden", "hidden"),
    IMAGE(8, "image", "image"),
    BUTTON(9, "button", "button");

    public static final int TEXT_VALUE = 0;
    public static final int PASSWORD_VALUE = 1;
    public static final int CHECKBOX_VALUE = 2;
    public static final int RADIO_VALUE = 3;
    public static final int SUBMIT_VALUE = 4;
    public static final int RESET_VALUE = 5;
    public static final int FILE_VALUE = 6;
    public static final int HIDDEN_VALUE = 7;
    public static final int IMAGE_VALUE = 8;
    public static final int BUTTON_VALUE = 9;
    private static final InputType[] VALUES_ARRAY;
    public static final List<InputType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InputType[]{TEXT, PASSWORD, CHECKBOX, RADIO, SUBMIT, RESET, FILE, HIDDEN, IMAGE, BUTTON};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InputType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InputType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InputType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InputType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InputType get(int value) {
        switch (value) {
            case 0: {
                return TEXT;
            }
            case 1: {
                return PASSWORD;
            }
            case 2: {
                return CHECKBOX;
            }
            case 3: {
                return RADIO;
            }
            case 4: {
                return SUBMIT;
            }
            case 5: {
                return RESET;
            }
            case 6: {
                return FILE;
            }
            case 7: {
                return HIDDEN;
            }
            case 8: {
                return IMAGE;
            }
            case 9: {
                return BUTTON;
            }
        }
        return null;
    }

    private InputType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

