/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.html.model.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ClearType implements Enumerator
{
    LEFT(0, "left", "left"),
    ALL(1, "all", "all"),
    RIGHT(2, "right", "right"),
    NONE(3, "none", "none");

    public static final int LEFT_VALUE = 0;
    public static final int ALL_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    public static final int NONE_VALUE = 3;
    private static final ClearType[] VALUES_ARRAY;
    public static final List<ClearType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClearType[]{LEFT, ALL, RIGHT, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClearType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClearType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClearType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClearType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClearType get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return ALL;
            }
            case 2: {
                return RIGHT;
            }
            case 3: {
                return NONE;
            }
        }
        return null;
    }

    private ClearType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

