/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.html.internal.metadata;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.query.AbstractVersionContextAdapterFactory;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IVisitableDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class HTMLVersionContextAdapterFactory
extends AbstractVersionContextAdapterFactory {
    private Set<String> _supportedURIs = this.initializeUris();

    private Set<String> initializeUris() {
        HashSet<String> uris = new HashSet<String>();
        uris.add("html");
        uris.add("HTML");
        return uris;
    }

    public boolean isFactoryFor(IMetaDataModelContext context) {
        return context.getDomainId().equals("TagLibraryDomain") && this._supportedURIs.contains(context.getModelIdentifier());
    }

    public IVersion getVersionContext(IMetaDataModelContext context) {
        IVisitableDocument domDoc;
        IDocument doc;
        IFile file = (IFile)context.getAdapter(IFile.class);
        if (file != null && (doc = (IDocument)file.getAdapter(IDocument.class)) != null && (domDoc = (IVisitableDocument)doc.getAdapter(IVisitableDocument.class)) != null) {
            HTMLDocElementVisitor visitor = new HTMLDocElementVisitor();
            domDoc.accept((IStructuredXMLModelVisitor)visitor);
            return this.getVersionFactory().getVersion(visitor.isHTML5() ? "5" : "4");
        }
        return null;
    }

    private static class HTMLDocElementVisitor
    implements IStructuredXMLModelVisitor {
        private boolean _isHTML5;

        private HTMLDocElementVisitor() {
        }

        public boolean visit(IDOMNode node) {
            return true;
        }

        public boolean visit(IDOMElement element) {
            if (element.getTagName().equalsIgnoreCase("html")) {
                String ns = element.getNamespaceURI();
                if (ns != null) {
                    this._isHTML5 = ns.equals("http://www.w3.org/1999/xhtml");
                }
                return false;
            }
            return true;
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }

        public boolean visit(IDOMAttr attribute) {
            return false;
        }

        public boolean isHTML5() {
            return this._isHTML5;
        }
    }
}

