/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.serverview.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.ui.serverview.ResourcesNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandDeleteResource;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.ServerAdmin;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;

public class UnregisterResourceAction
extends Action {
    ISelection selection;
    ICommonActionExtensionSite actionSite;

    public UnregisterResourceAction(ISelection selection, ICommonActionExtensionSite actionSite) {
        this.setText("Unregister");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.selection = selection;
        this.actionSite = actionSite;
    }

    public void runWithEvent(Event event) {
        TreeSelection ts;
        Object obj;
        if (this.selection instanceof TreeSelection && (obj = (ts = (TreeSelection)this.selection).getFirstElement()) instanceof ResourcesNode) {
            final ResourcesNode currentResource = (ResourcesNode)obj;
            if (currentResource.getResource() == null) {
                return;
            }
            try {
                final GlassfishGenericServerBehaviour be = currentResource.getServer().getServerBehaviourAdapter();
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        GlassfishGenericServer server = be.getSunAppServer();
                        String propName = "";
                        boolean cascadeDelete = false;
                        String type = currentResource.getType();
                        if (type.equals("jdbc-resource")) {
                            propName = "jdbc_resource_name";
                        } else if (type.equals("jdbc-connection-pool")) {
                            propName = "jdbc_connection_pool_id";
                            cascadeDelete = true;
                        } else if (type.equals("connector-resource")) {
                            propName = "connector_resource_pool_id";
                        } else if (type.equals("connector-connection-pool")) {
                            propName = "poolname";
                        } else if (type.equals("admin-object")) {
                            propName = "jndi_name";
                        } else if (type.equals("javamail-resource")) {
                            propName = "jndi_name";
                        }
                        String resourceName = currentResource.getResource().getName();
                        CommandDeleteResource command = new CommandDeleteResource(resourceName, currentResource.getResource().getCommandSuffix(), propName, cascadeDelete);
                        Future future = ServerAdmin.exec((GlassFishServer)server, (Command)command, (IdeContext)new IdeContext());
                        try {
                            ResultString result = (ResultString)future.get(30L, TimeUnit.SECONDS);
                            if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                                GlassfishToolsPlugin.logMessage((String)("Unable to delete resource " + resourceName + ". Message: " + result.getValue()));
                            }
                        }
                        catch (InterruptedException e) {
                            GlassfishToolsPlugin.logMessage((String)("Unable to delete resource " + resourceName), (Exception)e);
                        }
                        catch (ExecutionException e) {
                            GlassfishToolsPlugin.logMessage((String)("Unable to delete resource " + resourceName), (Exception)e);
                        }
                        catch (TimeoutException e) {
                            GlassfishToolsPlugin.logMessage((String)("Unable to delete resource " + resourceName), (Exception)e);
                        }
                    }
                };
                Shell shell = Display.getDefault().getActiveShell();
                if (shell != null) {
                    new ProgressMonitorDialog(shell).run(true, false, op);
                }
                StructuredViewer view = this.actionSite.getStructuredViewer();
                view.refresh((Object)currentResource.getParent());
            }
            catch (Exception exception) {}
        }
        super.run();
    }

    public void run() {
        this.runWithEvent(null);
    }
}

