/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.serverview.actions;

import java.net.URI;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.ui.serverview.DeployedApplicationsNode;
import oracle.eclipse.tools.glassfish.ui.serverview.TreeNode;
import oracle.eclipse.tools.glassfish.utils.Utils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenInBrowserAction
extends Action {
    ISelection selection;

    public OpenInBrowserAction(ISelection selection) {
        this.setText("Open in Browser");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.file.print");
        this.selection = selection;
    }

    public void runWithEvent(Event event) {
        if (this.selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)this.selection;
            Object obj = ts.getFirstElement();
            if (obj instanceof TreeNode) {
                TreeNode module = (TreeNode)obj;
                DeployedApplicationsNode target = (DeployedApplicationsNode)module.getParent();
                try {
                    GlassfishGenericServerBehaviour be = target.getServer().getServerBehaviourAdapter();
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                    GlassfishGenericServer server = be.getSunAppServer();
                    String host = server.getServer().getHost();
                    int port = Integer.parseInt(server.getServerPort());
                    URI uri = new URI(Utils.getHttpListenerProtocol((String)host, (int)port), null, host, port, "/" + module.getName(), null, null);
                    browser.openURL(uri.toURL());
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logMessage((String)("Error opening browser: " + e.getMessage()));
                }
            }
            super.run();
        }
    }

    public void run() {
        this.runWithEvent(null);
    }
}

