/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.serverview;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public abstract class GenericActionProvider
extends CommonActionProvider {
    Action refreshAction;
    protected ICommonActionExtensionSite actionSite;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.makeActions(cv, wsSite.getSelectionProvider());
        }
    }

    private void makeActions(CommonViewer cv, ISelectionProvider selectionProvider) {
        ISelection sel = selectionProvider.getSelection();
        this.refreshAction = new RefreshAction(sel);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
            this.refreshAction = new RefreshAction((ISelection)selection);
            menu.add((IAction)this.refreshAction);
            menu.add((IContributionItem)new Separator());
        }
    }

    protected abstract String getExtensionId();

    protected void refresh(Object selection) {
    }

    class RefreshAction
    extends Action {
        ISelection selection;

        public RefreshAction(ISelection selection) {
            this.setText("Refresh");
            this.selection = selection;
        }

        public void runWithEvent(Event event) {
            if (this.selection instanceof TreeSelection) {
                TreeSelection ts = (TreeSelection)this.selection;
                Object obj = ts.getFirstElement();
                GenericActionProvider.this.refresh(obj);
                StructuredViewer view = GenericActionProvider.this.actionSite.getStructuredViewer();
                view.refresh(obj);
            }
            super.run();
        }

        public void run() {
            this.runWithEvent(null);
        }
    }
}

