/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.rest.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.jst.j2ee.internal.web.operations.CreateWebClassTemplateModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddGenericResourceTemplateModel
extends CreateWebClassTemplateModel {
    public static final String QUALIFIED_CONTEXT = "javax.ws.rs.core.Context";
    public static final String QUALIFIED_URI_INFO = "javax.ws.rs.core.UriInfo";
    public static final String QUALIFIED_CONSUMES = "javax.ws.rs.Consumes";
    public static final String QUALIFIED_PUT = "javax.ws.rs.PUT";
    public static final String QUALIFIED_PATH = "javax.ws.rs.Path";
    public static final String QUALIFIED_GET = "javax.ws.rs.GET";
    public static final String QUALIFIED_DELETE = "javax.ws.rs.DELETE";
    public static final String QUALIFIED_PRODUCES = "javax.ws.rs.Produces";
    public static final String QUALIFIED_PATH_PARAM = "javax.ws.rs.PathParam";
    public static final String QUALIFIED_POST = "javax.ws.rs.POST";
    public static final String QUALIFIED_RESPONSE = "javax.ws.rs.core.Response";
    protected static final String TYPE_APP_JSON = "application/json";
    protected static final String TYPE_APP_XML = "application/xml";
    protected static final String TYPE_TEXT_HTML = "text/html";
    protected static final String TYPE_TEXT_PLAIN = "text/plain";
    protected static final String SUFFIX_JSON = "Json";
    protected static final String SUFFIX_XML = "Xml";
    protected static final String SUFFIX_HTML = "Html";
    protected static final String SUFFIX_TEXT = "Text";
    protected static final String SIMPLE_PATTERN = "Simple";
    protected static final String CONTAINER_PATTERN = "Container";
    protected static final String CLIENT_CONTAINER_PATTERN = "Client";
    private static final Map<String, String> typeToSuffix = new HashMap<String, String>();

    static {
        typeToSuffix.put(TYPE_APP_JSON, SUFFIX_JSON);
        typeToSuffix.put(TYPE_APP_XML, SUFFIX_XML);
        typeToSuffix.put(TYPE_TEXT_HTML, SUFFIX_HTML);
        typeToSuffix.put(TYPE_TEXT_PLAIN, SUFFIX_TEXT);
    }

    public AddGenericResourceTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    public Collection<String> getImports() {
        String repPropName;
        String repClass;
        Collection collection = super.getImports();
        boolean isContainerClass = this.isContainerClass();
        boolean isClientPattern = this.isClientControlledPattern();
        boolean usesContext = this.isSimplePattern() || isContainerClass;
        collection.add(QUALIFIED_CONSUMES);
        collection.add(QUALIFIED_GET);
        collection.add(QUALIFIED_PRODUCES);
        if (usesContext) {
            collection.add(QUALIFIED_CONTEXT);
            collection.add(QUALIFIED_URI_INFO);
            collection.add(QUALIFIED_PATH);
        } else {
            collection.add(QUALIFIED_DELETE);
        }
        if (isContainerClass) {
            if (!isClientPattern) {
                collection.add(QUALIFIED_POST);
                collection.add(QUALIFIED_RESPONSE);
            } else {
                collection.remove(QUALIFIED_CONSUMES);
            }
            if (this.getParamList() != null) {
                collection.add(QUALIFIED_PATH_PARAM);
            }
        } else {
            collection.add(QUALIFIED_PUT);
        }
        if ((repClass = this.getProperty(repPropName = isContainerClass ? "AddGenericResource.CONTAINER_REPRESENTATION_CLASS" : "AddGenericResource.REPRESENTATION_CLASS")) != null) {
            collection.add(repClass);
            int index = repClass.lastIndexOf(".");
            if (index != -1) {
                String packageName = repClass.substring(0, index);
                if (repClass.startsWith("java.lang.") && !packageName.equals("java.lang")) {
                    TreeSet<String> myCollection = new TreeSet<String>();
                    myCollection.addAll(collection);
                    myCollection.add(repClass);
                    return myCollection;
                }
            }
        }
        return collection;
    }

    protected boolean isSimplePattern() {
        String patternProp = this.getProperty("AddGenericResource.PATTERN");
        return patternProp.equals(SIMPLE_PATTERN);
    }

    protected boolean isClientControlledPattern() {
        String patternProp = this.getProperty("AddGenericResource.PATTERN");
        return patternProp.equals(CLIENT_CONTAINER_PATTERN);
    }

    public String getProperty(String propertyName) {
        return this.dataModel.getStringProperty(propertyName);
    }

    protected String getMethodNameSuffixFromMimeType() {
        String mimeType = this.getProperty("AddGenericResource.MIME_TYPE");
        return mimeType != null ? typeToSuffix.get(mimeType) : null;
    }

    protected String getUnqualifiedRepresentationClass() {
        return this.getUnqualifiedRepresentationClass("AddGenericResource.REPRESENTATION_CLASS");
    }

    protected String getUnqualifiedContainerRepresentationClass() {
        return this.getUnqualifiedRepresentationClass("AddGenericResource.CONTAINER_REPRESENTATION_CLASS");
    }

    protected String getUnqualifiedRepresentationClass(String propertyName) {
        int index;
        String repClass = this.getProperty(propertyName);
        if (repClass != null && (index = repClass.lastIndexOf(".")) != -1) {
            return repClass.substring(index + 1);
        }
        return null;
    }

    protected String[] getParamList() {
        if (!this.isSimplePattern()) {
            String path = this.getProperty("AddGenericResource.PATH");
            StringTokenizer segments = new StringTokenizer(path, "/ ");
            ArrayList<String> pathParts = new ArrayList<String>();
            while (segments.hasMoreTokens()) {
                String segment = segments.nextToken();
                if (!segment.startsWith("{") || segment.length() <= 2 || !segment.endsWith("}")) continue;
                pathParts.add(segment.substring(1, segment.length() - 1));
            }
            return pathParts.isEmpty() ? null : pathParts.toArray(new String[0]);
        }
        return null;
    }

    protected String getCommaSeparatedParamList() {
        return this.buildCommaSeparatedParamList(null);
    }

    protected String getCommaSeparatedParamListWithTypes() {
        return this.buildCommaSeparatedParamList("String");
    }

    private String buildCommaSeparatedParamList(String additionalString) {
        String[] paramList = this.getParamList();
        StringBuffer buffer = new StringBuffer();
        if (paramList != null) {
            int count = paramList.length;
            int i = 0;
            while (i < count) {
                String string = paramList[i];
                if (additionalString != null) {
                    buffer.append(additionalString);
                    buffer.append(" ");
                }
                buffer.append(string);
                if (i < count - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    protected void setIsContainerClass() {
        String existingClassName = this.getProperty("NewJavaClassDataModel.CLASS_NAME");
        this.dataModel.setBooleanProperty("AddGenericResource.IN_CONTAINER_CLASS", Boolean.TRUE.booleanValue());
        this.dataModel.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)(String.valueOf(existingClassName) + CONTAINER_PATTERN));
        this.dataModel.setProperty("AddGenericResource.ORIGINAL_CLASS_NAME", (Object)existingClassName);
    }

    private boolean isContainerClass() {
        return this.dataModel.getBooleanProperty("AddGenericResource.IN_CONTAINER_CLASS");
    }
}

