/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.rest.wizards;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.ui.rest.wizards.AddGenericResourceClassOperation;
import oracle.eclipse.tools.glassfish.ui.rest.wizards.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaEEArtifactClassOperation;
import org.eclipse.jst.j2ee.internal.web.operations.AddWebClassOperation;
import org.eclipse.jst.j2ee.internal.web.operations.NewWebClassDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddGenericResourceDataModelProvider
extends NewWebClassDataModelProvider {
    public static final String PATTERN = "AddGenericResource.PATTERN";
    public static final String PATH = "AddGenericResource.PATH";
    public static final String MIME_TYPE = "AddGenericResource.MIME_TYPE";
    public static final String REPRESENTATION_CLASS = "AddGenericResource.REPRESENTATION_CLASS";
    public static final String CONTAINER_REPRESENTATION_CLASS = "AddGenericResource.CONTAINER_REPRESENTATION_CLASS";
    public static final String CONTAINER_PATH = "AddGenericResource.CONTAINER_PATH";
    public static final String IN_CONTAINER_CLASS = "AddGenericResource.IN_CONTAINER_CLASS";
    public static final String ORIGINAL_CLASS_NAME = "AddGenericResource.ORIGINAL_CLASS_NAME";

    public IDataModelOperation getDefaultOperation() {
        return new AddWebClassOperation(this.getDataModel()){

            protected NewJavaEEArtifactClassOperation getNewClassOperation() {
                return new AddGenericResourceClassOperation(this.getDataModel());
            }

            protected void generateMetaData(IDataModel aModel, String qualifiedClassName) {
            }
        };
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add(REPRESENTATION_CLASS);
        propertyNames.add(MIME_TYPE);
        propertyNames.add(CONTAINER_REPRESENTATION_CLASS);
        propertyNames.add(CONTAINER_PATH);
        propertyNames.add(PATH);
        propertyNames.add(PATTERN);
        propertyNames.add(IN_CONTAINER_CLASS);
        propertyNames.add(ORIGINAL_CLASS_NAME);
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        String className;
        if (REPRESENTATION_CLASS.equals(propertyName) || CONTAINER_REPRESENTATION_CLASS.equals(propertyName)) {
            return "java.lang.String";
        }
        if (PATTERN.equals(propertyName)) {
            return "Simple";
        }
        if (PATH.equals(propertyName)) {
            return this.isSimplePattern() ? "generic" : (this.isClientControlledPattern() ? "{name}" : "{id}");
        }
        if (CONTAINER_PATH.equals(propertyName) && (className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME")) != null && className.length() > 0) {
            return "/" + className.substring(0, 1).toLowerCase() + className.substring(1) + "s";
        }
        if (IN_CONTAINER_CLASS.equals(propertyName)) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (CONTAINER_REPRESENTATION_CLASS.equals(propertyName) || CONTAINER_PATH.equals(propertyName)) {
            return !this.isSimplePattern();
        }
        return super.isPropertyEnabled(propertyName);
    }

    public IStatus validate(String propertyName) {
        String value;
        if (MIME_TYPE.equals(propertyName) && ((value = (String)this.getProperty(MIME_TYPE)) == null || value.trim().length() == 0)) {
            return GlassfishToolsPlugin.createErrorStatus((String)Messages.errorMimeTypeMissing, null);
        }
        if (REPRESENTATION_CLASS.equals(propertyName)) {
            return this.validateRepClass(REPRESENTATION_CLASS, Messages.errorRepresentationClassMissing, Messages.errorRepresentationClassInvalid);
        }
        if (PATH.equals(propertyName)) {
            return this.validatePath((String)this.getProperty(PATH));
        }
        if (this.isPropertyEnabled(propertyName)) {
            if (CONTAINER_PATH.equals(propertyName) && ((value = (String)this.getProperty(CONTAINER_PATH)) == null || value.trim().length() == 0)) {
                return GlassfishToolsPlugin.createErrorStatus((String)Messages.errorContainerPathMissing, null);
            }
            if (CONTAINER_REPRESENTATION_CLASS.equals(propertyName)) {
                return this.validateRepClass(CONTAINER_REPRESENTATION_CLASS, Messages.errorContainerRepresentationClassMissing, Messages.errorContainerRepresentationClassInvalid);
            }
        }
        IStatus status = super.validate(propertyName);
        return status;
    }

    private boolean isSimplePattern() {
        return "Simple".equals(this.getStringProperty(PATTERN));
    }

    private boolean isClientControlledPattern() {
        return "Client".equals(this.getStringProperty(PATTERN));
    }

    protected IStatus validateRepClass(String propertyName, String errorMessageKeyMissing, String errorMessageKeyInvalid) {
        IStatus javaStatus;
        String value = (String)this.getProperty(propertyName);
        if (value == null || value.trim().length() == 0) {
            return GlassfishToolsPlugin.createErrorStatus((String)errorMessageKeyMissing, null);
        }
        String className = value;
        int index = value.lastIndexOf(".");
        if (index != -1) {
            className = value.substring(index + 1);
        }
        if ((javaStatus = this.validateJavaClassName(className)).getSeverity() != 4) {
            IJavaProject javaProject = JavaCore.create((IProject)this.getTargetProject());
            IType type = null;
            try {
                type = javaProject.findType(value);
            }
            catch (Exception exception) {}
            if (type == null) {
                return WTPCommonPlugin.createErrorStatus((String)errorMessageKeyInvalid);
            }
            return WTPCommonPlugin.OK_STATUS;
        }
        return javaStatus;
    }

    private IStatus validatePath(String path) {
        if (path == null || path.trim().length() == 0) {
            return GlassfishToolsPlugin.createErrorStatus((String)Messages.errorPathMissing, null);
        }
        if (!this.isSimplePattern()) {
            StringTokenizer segments = new StringTokenizer(path, "/ ");
            HashSet<String> pathParts = new HashSet<String>();
            while (segments.hasMoreTokens()) {
                String segment = segments.nextToken();
                if (segment.startsWith("{")) {
                    if (segment.length() > 2 && segment.endsWith("}")) {
                        String pathPart = segment.substring(1, segment.length() - 1);
                        IStatus javaStatus = JavaConventions.validateIdentifier((String)pathPart, (String)"1.3", (String)"1.3");
                        if (javaStatus.getSeverity() == 4) {
                            String msg = javaStatus.getMessage();
                            return WTPCommonPlugin.createErrorStatus((String)msg);
                        }
                        if (javaStatus.getSeverity() == 2) {
                            String msg = javaStatus.getMessage();
                            return WTPCommonPlugin.createWarningStatus((String)msg);
                        }
                        if (pathParts.contains(pathPart)) {
                            return WTPCommonPlugin.createErrorStatus((String)Messages.errorPathInvalid);
                        }
                        pathParts.add(pathPart);
                        continue;
                    }
                    return WTPCommonPlugin.createErrorStatus((String)Messages.errorPathInvalid);
                }
                if (!segment.contains("{") && !segment.contains("}")) continue;
                return WTPCommonPlugin.createErrorStatus((String)Messages.errorPathInvalid);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

