/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.resources.wizards;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.glassfish.ui.resources.JDBCInfo;
import oracle.eclipse.tools.glassfish.ui.resources.wizards.JDBCResourceWizardPage;
import oracle.eclipse.tools.glassfish.ui.resources.wizards.Messages;
import oracle.eclipse.tools.glassfish.ui.resources.wizards.ResourceWizard;
import oracle.eclipse.tools.glassfish.utils.ResourceUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.glassfish.tools.ide.server.parser.ResourcesReader;

public class JDBCWizard
extends ResourceWizard {
    private JDBCResourceWizardPage page;

    public JDBCWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        IContainer containerResource = this.getContainerResource();
        IProject selectedProject = containerResource != null ? containerResource.getProject() : null;
        this.page = new JDBCResourceWizardPage(selectedProject, this.getGlassFishAndSailfinProjects());
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String jndiName = this.page.getJNDIName();
        final JDBCInfo jdbcInfo = this.page.getJDBCInfo();
        final IProject selectedProject = this.page.getSelectedProject();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        JDBCWizard.this.doFinish(jndiName, jdbcInfo, selectedProject, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            String message = realException.getMessage();
            if (message == null) {
                message = Messages.errorUnknown;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ErrorTitle, (String)message);
            return false;
        }
        return true;
    }

    private void doFinish(String jndiName, JDBCInfo jdbcInfo, IProject selectedProject, IProgressMonitor monitor) throws CoreException {
        this.checkDir(selectedProject);
        monitor.beginTask("Creating sun-resources.xml", 2);
        final IFile file = this.folder.getFile((IPath)new Path("sun-resources.xml"));
        try {
            String fragment = JDBCWizard.createFragment(jndiName, jdbcInfo, selectedProject);
            InputStream stream = ResourceUtils.appendResource((IFile)file, (String)fragment);
            if (!this.folder.exists()) {
                this.folder.create(true, true, monitor);
            }
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    public static String createFragment(String jndiName, JDBCInfo jdbcInfo, IProject selectedProject) throws CoreException {
        String newline = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String serverName = jdbcInfo.getServerName();
        String portNumber = jdbcInfo.getPort();
        String databaseName = JDBCWizard.getDatabaseName(jdbcInfo);
        String vendorName = jdbcInfo.getDatabaseVendor();
        String user = jdbcInfo.getUserName();
        String poolName = JDBCWizard.constructPoolName(vendorName, databaseName, user);
        String driverClass = jdbcInfo.getDriverClass();
        String datasourceClass = jdbcInfo.getDatasourceClass();
        String password = jdbcInfo.getUserPassword();
        String url = jdbcInfo.getURL();
        boolean matchStart = false;
        boolean matchEnd = false;
        boolean createConnPool = true;
        if (ResourceUtils.isDuplicate((String)poolName, (ResourcesReader.ResourceType)ResourcesReader.ResourceType.JDBC_CONNECTION_POOL, (IProject)selectedProject)) {
            createConnPool = false;
        }
        try {
            InputStream input = JDBCInfo.class.getResourceAsStream("templates/sun-resources-xml-template.resource");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf("<jdbc-resource") != -1) {
                        matchStart = true;
                    }
                    if (!matchStart || matchEnd) continue;
                    if (createConnPool) {
                        if (line.indexOf("</jdbc-connection-pool>") != -1) {
                            matchEnd = true;
                        }
                    } else if (line.indexOf("/>") != -1) {
                        matchEnd = true;
                    }
                    line = line.replaceAll("\\$\\{jndiName\\}", jndiName);
                    line = line.replaceAll("\\$\\{poolName\\}", poolName);
                    line = JDBCWizard.replaceOrRemove(line, "\\$\\{serverName\\}", serverName);
                    line = JDBCWizard.replaceOrRemove(line, "\\$\\{port\\}", portNumber);
                    line = JDBCWizard.replaceOrRemove(line, "\\$\\{databaseName\\}", databaseName);
                    line = JDBCWizard.replaceOrRemove(line, "\\$\\{driverClass\\}", driverClass);
                    line = JDBCWizard.replaceOrRemove(line, "\\$\\{datasourceClass\\}", datasourceClass);
                    line = JDBCWizard.replaceOrRemove(line, "\\$\\{user\\}", user);
                    line = JDBCWizard.replaceOrRemove(line, "\\$\\{password\\}", password);
                    if ((line = JDBCWizard.replaceOrRemove(line, "\\$\\{url\\}", url)) == null) continue;
                    sb.append(line);
                    sb.append(newline);
                }
            }
        }
        catch (IOException ioe) {
            Status status = new Status(4, "JDBCWizard", 0, ioe.getLocalizedMessage(), null);
            throw new CoreException((IStatus)status);
        }
        return sb.toString();
    }

    private static String getDatabaseName(JDBCInfo jdbcInfo) {
        String databaseName = jdbcInfo.getDatabaseName();
        if (databaseName == null) {
            databaseName = jdbcInfo.getAlternateDatabaseName();
        }
        return databaseName;
    }

    private static String constructPoolName(String vendorName, String dbName, String userName) {
        StringBuffer poolName = new StringBuffer(vendorName);
        if (dbName != null) {
            poolName.append("_" + dbName);
        }
        if (userName != null) {
            poolName.append("_" + userName);
        }
        poolName.append("Pool");
        return poolName.toString();
    }
}

