/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.resources;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlData {
    private static String DBURL_PATTERN = "((?:[^:\\n]+:){2,3})(?://|@|([^ \\t]+)@)([^:;/\\\\ \\t]+)(?:\\\\([^ \\t:/;]+)|)(?::([0-9]+)|)(?:(?:/|:)([^:/;?&]+)|)((?:(?:;|\\?|&|:)(?:[^;&]+)|)+)";
    private static final int DB_PREFIX = 0;
    private static final int DB_ALT_DBNAME = 1;
    private static final int DB_HOST = 2;
    private static final int DB_INSTANCE_NAME = 3;
    private static final int DB_PORT = 4;
    private static final int DB_PRIMARY_DBNAME = 5;
    private static final int DB_PROPERTIES = 6;
    private static final int NUM_PARTS = 7;
    private static Pattern urlPattern = Pattern.compile(DBURL_PATTERN);
    private final String url;
    private final String[] parts = new String[7];
    private final Map<String, String> props = new LinkedHashMap<String, String>();

    public UrlData(String newUrl) {
        this.url = newUrl;
        this.parseUrl();
    }

    public UrlData(String prefix, String host, String port, String dbname, String sid) {
        this(prefix, host, port, dbname, null, null, UrlData.parseProperties(sid));
    }

    public UrlData(String prefix, String host, String port, String dbname, Map<String, String> properties) {
        this(prefix, host, port, dbname, null, null, properties);
    }

    public UrlData(String prefix, String host, String port, String dbname, String altdbname, String instancename, Map<String, String> properties) {
        this.parts[0] = prefix;
        this.parts[1] = altdbname;
        this.parts[2] = host;
        this.parts[3] = instancename;
        this.parts[4] = port;
        this.parts[5] = dbname;
        this.parts[6] = null;
        this.props.putAll(properties);
        this.url = this.constructUrl();
    }

    private void parseUrl() {
        Logger.getLogger("glassfish.javaee").log(Level.FINEST, "Parsing DB Url: " + this.url);
        Matcher matcher = urlPattern.matcher(this.url);
        if (matcher.matches()) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                String part = matcher.group(i);
                Logger.getLogger("glassfish.javaee").log(Level.FINEST, "    Part " + i + " is " + part);
                this.parts[i - 1] = part;
                ++i;
            }
            this.props.putAll(UrlData.parseProperties(this.parts[6]));
        } else {
            Logger.getLogger("glassfish.javaee").log(Level.FINE, "Url parsing failed for " + this.url);
        }
    }

    private static Map<String, String> parseProperties(String data) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (data != null && data.length() > 0) {
            String[] properties = data.split("[;?&:]");
            int i = 0;
            while (i < properties.length) {
                if (properties[i] != null && properties[i].length() > 0) {
                    int eqIndex = properties[i].indexOf("=");
                    if (eqIndex != -1) {
                        result.put(properties[i].substring(0, eqIndex), properties[i].substring(eqIndex + 1));
                    } else {
                        result.put(properties[i], "");
                    }
                }
                ++i;
            }
        }
        return result;
    }

    String constructUrl() {
        String value;
        Map.Entry<String, String> entry;
        StringBuilder builder = new StringBuilder(256);
        builder.append(this.parts[0]);
        if (UrlData.notEmpty(this.parts[1])) {
            builder.append(this.parts[1]);
            builder.append('@');
        } else if ("jdbc:oracle:thin:".equals(this.parts[0])) {
            builder.append('@');
        } else {
            builder.append("//");
        }
        builder.append(this.parts[2]);
        if (UrlData.notEmpty(this.parts[3])) {
            builder.append('\\');
            builder.append(this.parts[3]);
        }
        if (UrlData.notEmpty(this.parts[4])) {
            builder.append(':');
            builder.append(this.parts[4]);
        }
        if (UrlData.notEmpty(this.parts[5])) {
            if ("jdbc:oracle:thin:".equals(this.parts[0])) {
                builder.append(':');
            } else {
                builder.append('/');
            }
            builder.append(this.parts[5]);
        }
        char propertyInitialSeparator = ';';
        char propertySeparator = ';';
        if ("jdbc:mysql:".equals(this.parts[0])) {
            propertyInitialSeparator = '?';
            propertySeparator = '&';
        } else if ("jdbc:informix-sqli:".equals(this.parts[0])) {
            propertyInitialSeparator = ':';
        }
        Set<Map.Entry<String, String>> entries = this.props.entrySet();
        Iterator<Map.Entry<String, String>> entryIterator = entries.iterator();
        if (entryIterator.hasNext()) {
            builder.append(propertyInitialSeparator);
            entry = entryIterator.next();
            builder.append(entry.getKey());
            value = entry.getValue();
            if (UrlData.notEmpty(value)) {
                builder.append('=');
                builder.append(value);
            }
        }
        while (entryIterator.hasNext()) {
            builder.append(propertySeparator);
            entry = entryIterator.next();
            builder.append(entry.getKey());
            value = entry.getValue();
            if (!UrlData.notEmpty(value)) continue;
            builder.append('=');
            builder.append(value);
        }
        return builder.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public String getPrefix() {
        return this.parts[0];
    }

    public String getHostName() {
        return this.parts[2];
    }

    public String getPort() {
        return this.parts[4];
    }

    public String getInstanceName() {
        return this.parts[3];
    }

    public String getDatabaseName() {
        String dbname = this.parts[5];
        if (dbname == null && (dbname = this.parts[1]) == null && (dbname = this.props.get("databaseName")) == null && (dbname = this.props.get("databasename")) == null && (dbname = this.props.get("SID")) == null) {
            dbname = this.props.get("database name");
        }
        return dbname;
    }

    public String getAlternateDBName() {
        return this.parts[1];
    }

    public String getSid() {
        return this.props.get("SID");
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    private static boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }
}

