/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.resources;

import oracle.eclipse.tools.glassfish.ui.resources.DriverMaps;
import oracle.eclipse.tools.glassfish.ui.resources.UrlData;
import org.eclipse.datatools.connectivity.IConnectionProfile;

public class JDBCInfo {
    private IConnectionProfile connectionProfile;
    private UrlData urlDataParser;

    public JDBCInfo(IConnectionProfile profile) {
        this.connectionProfile = profile;
        this.urlDataParser = new UrlData(this.getURL());
    }

    private String getProperty(String propName) {
        if (this.connectionProfile != null) {
            return this.connectionProfile.getBaseProperties().getProperty(propName);
        }
        return null;
    }

    public String getUserName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.username");
    }

    public String getUserPassword() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.password");
    }

    public String getURL() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public String getDriverClass() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
    }

    public String getDatasourceClass() {
        return DriverMaps.getDSClassName(this.getURL());
    }

    public String getDatabaseVendor() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.vendor");
    }

    public String getPort() {
        return this.urlDataParser.getPort();
    }

    public String getServerName() {
        return this.urlDataParser.getHostName();
    }

    public String getDatabaseName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    public String getAlternateDatabaseName() {
        return this.urlDataParser.getAlternateDBName();
    }
}

