/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.properties;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.Messages;
import oracle.eclipse.tools.glassfish.SunAppServerCommands;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.glassfish.tools.ide.data.GlassFishVersion;

public class ServerPropertyPage
extends PropertyPage {
    IServerWorkingCopy serverWC = null;
    GlassfishGenericServer sunserver;
    Text username = null;
    Text password = null;
    Text adminServerPortNumber = null;
    Text serverPortNumber = null;
    Text domaindir = null;
    private Map<String, String> oldProps;

    protected Control createContents(Composite parent) {
        IServer server = (IServer)this.getElement();
        this.serverWC = server instanceof IServerWorkingCopy ? (IServerWorkingCopy)server : server.createWorkingCopy();
        this.sunserver = (GlassfishGenericServer)this.serverWC.loadAdapter(GlassfishGenericServer.class, (IProgressMonitor)new NullProgressMonitor());
        this.oldProps = new HashMap<String, String>(this.sunserver.getProps());
        final Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.verticalSpacing = 5;
        gl.marginWidth = 10;
        gl.marginHeight = 5;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, false, false));
        GridDataFactory txtGDF = GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(50, -1);
        boolean isRemote = this.sunserver.isRemote();
        if (!isRemote) {
            Label pathLabel = new Label(comp, 0);
            pathLabel.setText(Messages.DomainDirectory);
            this.domaindir = new Text(comp, 2048);
            this.domaindir.setText(this.sunserver.getDomainPath());
            txtGDF.align(4, 0x1000000).span(1, 1).applyTo((Control)this.domaindir);
            this.domaindir.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertyPage.this.execute(new SunAppServerCommands(ServerPropertyPage.this.sunserver, ServerPropertyPage.this.domaindir.getText(), "sunappserver.domainpath"));
                    ServerPropertyPage.this.validate();
                }
            });
            this.domaindir.selectAll();
            this.domaindir.setFocus();
            Button button = new Button(comp, 8);
            button.setText("Browse");
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dlg = new DirectoryDialog(comp.getShell());
                    dlg.setFilterPath(ServerPropertyPage.this.domaindir.getText().replace('\\', '/'));
                    String res = dlg.open();
                    if (res != null) {
                        ServerPropertyPage.this.domaindir.setText(res.replace('\\', '/'));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        txtGDF.align(4, 0x1000000).span(2, 1);
        Label adminLabel = new Label(comp, 0);
        adminLabel.setText(Messages.AdminName);
        this.username = new Text(comp, 2048);
        this.username.setText(this.sunserver.getAdminName());
        txtGDF.applyTo((Control)this.username);
        this.username.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPropertyPage.this.execute(new SunAppServerCommands(ServerPropertyPage.this.sunserver, ServerPropertyPage.this.username.getText(), "sunappserver.adminname"));
                ServerPropertyPage.this.validate();
            }
        });
        Label passwdLabel = new Label(comp, 0);
        passwdLabel.setText(Messages.AdminPassword);
        this.password = new Text(comp, 2048);
        this.password.setText(this.sunserver.getAdminPassword());
        this.password.setEchoChar('*');
        txtGDF.applyTo((Control)this.password);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPropertyPage.this.execute(new SunAppServerCommands(ServerPropertyPage.this.sunserver, ServerPropertyPage.this.password.getText(), "sunappserver.adminpassword"));
                ServerPropertyPage.this.validate();
            }
        });
        new Label(comp, 0).setText(Messages.ServerPortNumber);
        this.serverPortNumber = new Text(comp, 2048);
        this.serverPortNumber.setText(this.sunserver.getServerPort() != null ? this.sunserver.getServerPort() : "");
        txtGDF.applyTo((Control)this.serverPortNumber);
        if (!isRemote) {
            this.serverPortNumber.setEditable(false);
            this.serverPortNumber.setEnabled(false);
        }
        this.serverPortNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPropertyPage.this.execute(new SunAppServerCommands(ServerPropertyPage.this.sunserver, ServerPropertyPage.this.serverPortNumber.getText(), "sunappserver.serverportnumber"));
                ServerPropertyPage.this.validate();
            }
        });
        new Label(comp, 0).setText(Messages.AdminServerPortNumber);
        this.adminServerPortNumber = new Text(comp, 2048);
        this.adminServerPortNumber.setText(this.sunserver.getAdminServerPort());
        txtGDF.applyTo((Control)this.adminServerPortNumber);
        if (!isRemote) {
            this.adminServerPortNumber.setEditable(false);
            this.adminServerPortNumber.setEnabled(false);
        }
        this.adminServerPortNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPropertyPage.this.execute(new SunAppServerCommands(ServerPropertyPage.this.sunserver, ServerPropertyPage.this.adminServerPortNumber.getText(), "sunappserver.adminserverportnumber"));
                ServerPropertyPage.this.validate();
            }
        });
        if (!this.sunserver.getVersion().equals((Object)GlassFishVersion.GF_2)) {
            final Button useAnonymousConnection = new Button(comp, 32);
            useAnonymousConnection.setText(Messages.UseAnonymousConnection);
            boolean useAnon = this.sunserver.getUseAnonymousConnections().equals("true");
            useAnonymousConnection.setSelection(useAnon);
            this.username.setEnabled(!useAnon);
            this.password.setEnabled(!useAnon);
            txtGDF.span(3, 1).indent(0, 0).applyTo((Control)useAnonymousConnection);
            useAnonymousConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = useAnonymousConnection.getSelection();
                    ServerPropertyPage.this.username.setEnabled(!selected);
                    ServerPropertyPage.this.password.setEnabled(!selected);
                    ServerPropertyPage.this.execute(new SunAppServerCommands(ServerPropertyPage.this.sunserver, "" + selected, "sunappserver.useAnonymousConnection"));
                    ServerPropertyPage.this.validate();
                }
            });
            final Button keepSessions = new Button(comp, 32);
            keepSessions.setText(Messages.keepSessions);
            keepSessions.setSelection(this.sunserver.getKeepSessions().equals("true"));
            txtGDF.applyTo((Control)keepSessions);
            keepSessions.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = keepSessions.getSelection();
                    ServerPropertyPage.this.execute(new SunAppServerCommands(ServerPropertyPage.this.sunserver, "" + selected, "sunappserver.keepSessions"));
                    ServerPropertyPage.this.validate();
                }
            });
            if (!isRemote) {
                final Button jarDeploy = new Button(comp, 32);
                jarDeploy.setText(Messages.jarDeploy);
                jarDeploy.setSelection(this.sunserver.getJarDeploy().equals("true"));
                txtGDF.hint(400, -1).applyTo((Control)jarDeploy);
                jarDeploy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean selected = jarDeploy.getSelection();
                        ServerPropertyPage.this.execute(new SunAppServerCommands(ServerPropertyPage.this.sunserver, "" + selected, "sunappserver.jarDeploy"));
                        ServerPropertyPage.this.validate();
                    }
                });
            }
        }
        return comp;
    }

    protected void execute(SunAppServerCommands sunAppServerCommands) {
        sunAppServerCommands.execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    private void validate() {
        IStatus s = this.sunserver.validate();
        if (s.isOK()) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(s.getMessage());
            this.setValid(false);
        }
    }

    public String getErrorMessage() {
        IStatus status = this.sunserver.validate();
        if (!status.isOK()) {
            return status.getMessage();
        }
        return super.getErrorMessage();
    }

    public IStatus[] getSaveStatus() {
        IStatus status = this.sunserver.validate();
        return new IStatus[]{status};
    }

    protected Label createLabel(Composite parent, String text, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        return label;
    }

    protected Spinner createSpinner(Composite parent, String text, FormToolkit toolkit) {
        Spinner autoPublishTime = new Spinner(parent, 2048);
        autoPublishTime.setMinimum(0);
        autoPublishTime.setMaximum(120);
        autoPublishTime.setSelection(6789);
        GridData data = new GridData(32);
        data.widthHint = 60;
        autoPublishTime.setLayoutData((Object)data);
        return autoPublishTime;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("domainupdate" == evt.getPropertyName()) {
            this.username.setText(this.sunserver.getAdminName());
            this.password.setText(this.sunserver.getAdminPassword());
            this.adminServerPortNumber.setText(this.sunserver.getAdminServerPort());
            this.serverPortNumber.setText(this.sunserver.getServerPort());
        }
    }

    public boolean performOk() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            final IServer server = this.serverWC.save(true, (IProgressMonitor)monitor);
            this.sunserver.saveConfiguration((IProgressMonitor)monitor);
            this.oldProps = new HashMap<String, String>(this.sunserver.getProps());
            Job job = new Job("Update Glassfish server state"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        GlassfishGenericServerBehaviour serverBehavior = (GlassfishGenericServerBehaviour)ServerPropertyPage.this.serverWC.loadAdapter(GlassfishGenericServerBehaviour.class, monitor);
                        serverBehavior.updateServerStatus();
                    }
                    catch (Exception exception) {
                        ((Server)server).setServerState(4);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    public boolean performCancel() {
        for (Map.Entry<String, String> e : this.oldProps.entrySet()) {
            this.sunserver.getProps().put(e.getKey(), e.getValue());
        }
        return super.performCancel();
    }

    public boolean isValid() {
        IStatus s = this.sunserver.validate();
        return s.isOK();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.password.setText("");
        this.username.setText("admin");
        File rtDir = this.serverWC.getRuntime().getLocation().toFile();
        this.domaindir.setText(new File(rtDir, "/domains/domain1").getAbsolutePath());
    }
}

