/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.ant;

import oracle.cloud.paas.client.ant.CloudCliBaseTask;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloud.paas.client.cli.command.DescribeJob;
import oracle.cloud.paas.client.cli.command.JobProvider;
import oracle.cloud.paas.client.clix.CliExtensionUtils;
import oracle.cloud.paas.client.clix.jobstatus.JobFailedException;
import oracle.cloud.paas.client.clix.jobstatus.JobStatusWaitable;
import oracle.cloud.paas.model.Job;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliExitCodeException;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public abstract class JobCreatingBaseTask
extends CloudCliBaseTask {
    private String jobidproperty;
    private ResourceBusyConfig config = new ResourceBusyConfig();

    public ResourceBusyConfig createOnresourcebusy() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performCli() throws Exception {
        if (!JobProvider.class.isAssignableFrom(this.cmd.getCliProvider().getExecClass())) {
            throw new Exception(this.cmd.getCliProvider().getExecClass().getName() + " is not a sub-class of " + JobProvider.class.getName());
        }
        if (this.config.iswaitfor()) {
            this.config.setCmdJobStatus((CommandLine)((CommandLine)Main.allCommands.get((Object)"job-status")).simpleClone());
            for (NameValuePair pair : this.config.getCurrentCommandLine().getArgs().getList()) {
                CommandLineArg arg = (CommandLineArg)pair.getValue();
                arg.setOptionValue(this.cmd.getArgValue(arg.getOptionName()));
            }
        }
        Job job = null;
        int count = this.config.getRetrycount();
        do {
            try {
                super.performCli();
            }
            catch (CliExitCodeException cli) {
                // empty catch block
            }
            job = ((JobProvider)this.cmd.getExecutor()).getCreatedJob();
            if (job != null) break;
            Job activeJob = ((JobProvider)this.cmd.getExecutor()).getActiveJob();
            if (activeJob == null) {
                throw new Exception("New job is not created. No active job is found.");
            }
            if (count != 0) {
                this.config.getCurrentCommandLine().setValue("jobid", activeJob.getJobId());
                try {
                    Logger.getDEFAULT().println();
                    Logger.getDEFAULT().println();
                    Logger.getDEFAULT().printlnInfo("Waiting for the active job to complete. Retry(" + (this.config.getRetrycount() - count + 1) + " of " + this.config.getRetrycount() + ")");
                    activeJob = CliExtensionUtils.putOnWait((JobStatusWaitable)this.config, (String)"active-job");
                }
                catch (JobFailedException jfe) {}
            } else {
                if (this.config.getRetrycount() == 0) {
                    throw new Exception("There is an active job with id:" + activeJob.getJobId());
                }
                if (this.config.getRetrycount() == 1) {
                    throw new Exception("There is still an active job with id:" + activeJob.getJobId() + " after one retry");
                }
                throw new Exception("There is still an active job with id:" + activeJob.getJobId() + " after " + this.config.getRetrycount() + " retries");
            }
        } while (--count >= 0);
        this.setAntProperty(this.jobidproperty, job.getJobId());
    }

    public void setJobidproperty(String jobidproperty) {
        this.jobidproperty = jobidproperty;
    }

    public String getJobidproperty() {
        return this.jobidproperty;
    }

    public class ResourceBusyConfig
    implements JobStatusWaitable {
        private int timeoutsecs = 600;
        private int pollintervalmillis = 30000;
        CommandLine cmdJobStatus;
        private int retrycount = 3;

        public boolean iswaitfor() {
            return this.retrycount > 0;
        }

        public void setTimeoutsecs(int timeoutsecs) {
            this.timeoutsecs = timeoutsecs;
        }

        public int getTimeoutsecs() {
            return this.timeoutsecs;
        }

        public void setPollintervalmillis(int pollintervalmillis) {
            if (pollintervalmillis <= 0) {
                throw new RuntimeException("Invalid value:" + pollintervalmillis + ", poll interval must be a positive integer.");
            }
            this.pollintervalmillis = pollintervalmillis;
        }

        public int getPollintervalmillis() {
            return this.pollintervalmillis;
        }

        public boolean isdownloadlastlogonfailure() {
            return false;
        }

        public String getdownloadlastlogpath() {
            return null;
        }

        public String getjobstatusproperty() {
            return null;
        }

        public String getlastlogproperty() {
            return null;
        }

        public int gettimeoutsecs() {
            return this.timeoutsecs;
        }

        public int getpollintervalmillis() {
            return this.pollintervalmillis;
        }

        public void setProperty(String name, String val) {
            JobCreatingBaseTask.this.setAntProperty(name, val);
        }

        public DescribeJob poll() throws Exception {
            this.cmdJobStatus.perform(true);
            return (DescribeJob)this.cmdJobStatus.getExecutor();
        }

        public CommandLine getCurrentCommandLine() {
            return this.cmdJobStatus;
        }

        public void setCmdJobStatus(CommandLine cmdJobStatus) {
            this.cmdJobStatus = cmdJobStatus;
        }

        public void setRetrycount(int retrycount) {
            if (retrycount < 0) {
                throw new RuntimeException("retrycount can not be negative. Please set 0 or more.");
            }
            this.retrycount = retrycount;
        }

        public int getRetrycount() {
            return this.retrycount;
        }
    }
}

