/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.ant;

import java.util.List;
import oracle.cloud.paas.client.ant.CloudCliBaseTask;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloud.paas.client.cli.command.DescribeServiceInstance;
import oracle.cloud.paas.model.Association;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public class DescribeServiceInstanceTask
extends CloudCliBaseTask {
    private String dbserviceinstanceproperty;
    private String serviceinstancestatusproperty;
    private String serviceinstancesizeproperty;

    @Override
    public void performCli() throws Exception {
        super.performCli();
        DescribeServiceInstance desc = (DescribeServiceInstance)this.cmd.getExecutor();
        List list = desc.getDBAssociations();
        if (this.serviceinstancesizeproperty != null && desc.getServiceInstance().getSize() != null) {
            this.setAntProperty(this.serviceinstancesizeproperty, desc.getServiceInstance().getSize().toString());
        }
        if (this.serviceinstancestatusproperty != null && desc.getServiceInstance().getState() != null) {
            this.setAntProperty(this.serviceinstancestatusproperty, desc.getServiceInstance().getState().toString());
        }
        if (this.dbserviceinstanceproperty != null) {
            List props = CloudUtil.parseString((String)this.dbserviceinstanceproperty, (String)",", (boolean)true);
            if (list.isEmpty()) {
                throw new Exception("There is no Database association found");
            }
            for (int count = 0; count < list.size(); ++count) {
                if (props.size() <= count) continue;
                this.setAntProperty((String)props.get(count), ((Association)list.get(count)).getTargetInstanceName());
            }
        }
    }

    @Override
    public CommandLine getCommandLine() {
        return (CommandLine)Main.allCommands.get((Object)"describe-service-instance");
    }

    public void setdbserviceinstanceproperty(String dbserviceinstancesproperty) {
        this.dbserviceinstanceproperty = dbserviceinstancesproperty;
    }

    public String getdbserviceinstanceproperty() {
        return this.dbserviceinstanceproperty;
    }

    public void setserviceinstancestatusproperty(String serviceinstancestatusproperty) {
        this.serviceinstancestatusproperty = serviceinstancestatusproperty;
    }

    public String getserviceinstancestatusproperty() {
        return this.serviceinstancestatusproperty;
    }

    public void setserviceinstancesizeproperty(String serviceinstancesizeproperty) {
        this.serviceinstancesizeproperty = serviceinstancesizeproperty;
    }

    public String getserviceinstancesizeproperty() {
        return this.serviceinstancesizeproperty;
    }
}

