/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.ant;

import java.util.List;
import oracle.cloud.paas.client.ant.CloudCliBaseTask;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloud.paas.client.cli.command.DescribeApplication;
import oracle.cloud.paas.exception.UnknownResourceException;
import oracle.cloud.paas.model.Application;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class DescribeApplicationTask
extends CloudCliBaseTask {
    private String applicationexistproperty;
    private String applicationurlproperty;
    private String applicationstatusproperty;

    @Override
    public void performCli() throws Exception {
        try {
            super.performCli();
            this.setAntProperty(this.applicationexistproperty, "true");
            DescribeApplication desc = (DescribeApplication)this.cmd.getExecutor();
            Application app = desc.getApplication();
            if (this.applicationstatusproperty != null && app.getState() != null) {
                this.setAntProperty(this.applicationstatusproperty, app.getState().toString());
            }
            if (this.applicationurlproperty != null) {
                List urlProperties = CloudUtil.parseString((String)this.applicationurlproperty, (String)",", (boolean)true);
                for (int count = 0; count < app.getApplicationUrls().size(); ++count) {
                    if (urlProperties.size() <= count) continue;
                    this.setAntProperty((String)urlProperties.get(count), (String)app.getApplicationUrls().get(count));
                }
            }
        }
        catch (Exception un) {
            String existing;
            if (CloudUtil.isCausedBy((Throwable)un, UnknownResourceException.class) && (existing = this.getProject().getProperty(this.applicationexistproperty)) != null) {
                this.setAntProperty(this.applicationexistproperty, "false");
                Logger.getDEFAULT().printlnWarning("ANT property:" + this.applicationexistproperty + " is already set with a value:" + existing + ". Resetting the value to false.");
            }
            throw un;
        }
    }

    @Override
    public CommandLine getCommandLine() {
        return (CommandLine)Main.allCommands.get((Object)"describe-application");
    }

    public void setApplicationexistproperty(String applicationexistproperty) {
        this.applicationexistproperty = applicationexistproperty;
    }

    public String getApplicationexistproperty() {
        return this.applicationexistproperty;
    }

    public void setApplicationurlproperty(String applicationurlproperty) {
        this.applicationurlproperty = applicationurlproperty;
    }

    public String getApplicationurlproperty() {
        return this.applicationurlproperty;
    }

    public void setApplicationstatusproperty(String applicationstatusproperty) {
        this.applicationstatusproperty = applicationstatusproperty;
    }

    public String getApplicationstatusproperty() {
        return this.applicationstatusproperty;
    }
}

