/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks.ui.query.internal;

import com.tasktop.c2c.server.common.service.domain.criteria.Criteria;
import com.tasktop.c2c.server.common.service.domain.criteria.CriteriaParser;
import com.tasktop.c2c.server.tasks.domain.Component;
import com.tasktop.c2c.server.tasks.domain.FieldDescriptor;
import com.tasktop.c2c.server.tasks.domain.FieldType;
import com.tasktop.c2c.server.tasks.domain.Iteration;
import com.tasktop.c2c.server.tasks.domain.Keyword;
import com.tasktop.c2c.server.tasks.domain.Milestone;
import com.tasktop.c2c.server.tasks.domain.PredefinedTaskQuery;
import com.tasktop.c2c.server.tasks.domain.Priority;
import com.tasktop.c2c.server.tasks.domain.Product;
import com.tasktop.c2c.server.tasks.domain.RepositoryConfiguration;
import com.tasktop.c2c.server.tasks.domain.TaskResolution;
import com.tasktop.c2c.server.tasks.domain.TaskSeverity;
import com.tasktop.c2c.server.tasks.domain.TaskStatus;
import com.tasktop.c2c.server.tasks.domain.TaskUserProfile;
import java.net.URLDecoder;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevRepositoryConnector;
import oracle.eclipse.tools.cloud.dev.tasks.ui.query.CustomQueryTerms;
import oracle.eclipse.tools.cloud.dev.tasks.ui.query.Query;
import oracle.eclipse.tools.cloud.dev.tasks.ui.query.internal.QueryConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.util.IdentityHashSet;

public final class QueryServices {
    private static final Product getProduct(String name, RepositoryConfiguration configuration) {
        for (Product product : configuration.getProducts()) {
            if (!product.getName().equals(name)) continue;
            return product;
        }
        return null;
    }

    public static final class ComponentPossibleValuesService
    extends QueryTermsPossibleValuesService {
        Listener productListener;

        protected void init() {
            super.init();
            this.productListener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    ComponentPossibleValuesService.this.broadcast();
                }
            };
            ((CustomQueryTerms)this.context(CustomQueryTerms.class)).attach(this.productListener, "Products/Product");
            ((CustomQueryTerms)this.context(CustomQueryTerms.class)).getProducts().attach(this.productListener);
        }

        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                CustomQueryTerms queryTerms = (CustomQueryTerms)this.context(CustomQueryTerms.class);
                boolean hasProduct = false;
                for (CustomQueryTerms.ProductListEntry entry : queryTerms.getProducts()) {
                    String productName = (String)entry.getProduct().content();
                    Product product = QueryServices.getProduct(productName, configuration);
                    if (product == null) continue;
                    hasProduct = true;
                    for (Component component : configuration.getComponents(product)) {
                        String name = component.getName();
                        if (values.contains(name)) continue;
                        values.add(name);
                    }
                }
                if (!hasProduct) {
                    for (Component component : configuration.getComponents()) {
                        values.add(component.getName());
                    }
                }
            }
        }
    }

    public static final class CustomFieldNamePossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (FieldDescriptor field : configuration.getCustomFields()) {
                    values.add(field.getName());
                }
            }
        }
    }

    public static final class CustomFieldNameValueLabelService
    extends ValueLabelService {
        protected final RepositoryConfiguration configuration() {
            AbstractRepositoryConnector connector;
            Query query = (Query)this.context(Query.class);
            TaskRepository repository = (TaskRepository)query.getTaskRepository().content();
            if (repository != null && (connector = TasksUi.getRepositoryConnector((String)repository.getConnectorKind())) instanceof CloudDevRepositoryConnector) {
                try {
                    return ((CloudDevRepositoryConnector)connector).getRepositoryConfiguration(repository, false, null);
                }
                catch (CoreException coreException) {}
            }
            return null;
        }

        public String provide(String value) {
            RepositoryConfiguration configuration;
            if (value != null && (configuration = this.configuration()) != null) {
                for (FieldDescriptor field : configuration.getCustomFields()) {
                    if (!value.equals(field.getName())) continue;
                    return field.getDescription();
                }
            }
            return "(" + value + ")";
        }
    }

    public static final class CustomFieldValuePossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void init() {
            super.init();
            CustomQueryTerms.CustomFieldListEntry customFieldQueryTerm = (CustomQueryTerms.CustomFieldListEntry)this.context(CustomQueryTerms.CustomFieldListEntry.class);
            customFieldQueryTerm.getName().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    CustomFieldValuePossibleValuesService.this.broadcast();
                }
            });
        }

        protected void fillPossibleValues(Set<String> values) {
            FieldDescriptor fieldDescriptor;
            CustomQueryTerms.CustomFieldListEntry customFieldQueryTerm = (CustomQueryTerms.CustomFieldListEntry)this.context(CustomQueryTerms.CustomFieldListEntry.class);
            String customFieldName = customFieldQueryTerm.getName().text();
            if (customFieldName != null && (fieldDescriptor = this.findFieldDescriptor(customFieldName)) != null) {
                switch (fieldDescriptor.getFieldType()) {
                    case CHECKBOX: {
                        values.add("true");
                        values.add("false");
                        break;
                    }
                    case SINGLE_SELECT: 
                    case MULTI_SELECT: {
                        values.addAll(fieldDescriptor.getValueStrings());
                    }
                }
            }
        }

        public Status.Severity getInvalidValueSeverity(String value) {
            FieldType type;
            FieldDescriptor fieldDescriptor;
            CustomQueryTerms.CustomFieldListEntry customFieldQueryTerm = (CustomQueryTerms.CustomFieldListEntry)this.context(CustomQueryTerms.CustomFieldListEntry.class);
            String customFieldName = customFieldQueryTerm.getName().text();
            if (customFieldName != null && (fieldDescriptor = this.findFieldDescriptor(customFieldName)) != null && ((type = fieldDescriptor.getFieldType()) == FieldType.CHECKBOX || type == FieldType.SINGLE_SELECT || type == FieldType.MULTI_SELECT)) {
                return Status.Severity.ERROR;
            }
            return Status.Severity.OK;
        }

        public String getInvalidValueMessage(String value) {
            CustomQueryTerms.CustomFieldListEntry customFieldQueryTerm = (CustomQueryTerms.CustomFieldListEntry)this.context(CustomQueryTerms.CustomFieldListEntry.class);
            String customFieldName = customFieldQueryTerm.getName().text();
            if (customFieldName == null) {
                return super.getInvalidValueMessage(value);
            }
            return NLS.bind((String)Resources.invalidCustomFieldValue, (Object)value, (Object)customFieldName);
        }

        private FieldDescriptor findFieldDescriptor(String name) {
            RepositoryConfiguration configuration;
            if (name != null && (configuration = this.configuration()) != null) {
                for (FieldDescriptor field : configuration.getCustomFields()) {
                    if (!name.equals(field.getName())) continue;
                    return field;
                }
            }
            return null;
        }
    }

    public static final class CustomQueryTermListener
    extends FilteredListener<PropertyContentEvent> {
        private static final Pattern URL_PATTERN = Pattern.compile("http://.*/tasks/s/(.*)");
        private static final Set<CustomQueryTerms> UPDATING = new IdentityHashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleTypedEvent(PropertyContentEvent event) {
            CustomQueryTerms qt = (CustomQueryTerms)event.property().element().nearest(CustomQueryTerms.class);
            Set<CustomQueryTerms> set = UPDATING;
            synchronized (set) {
                if (UPDATING.contains(qt)) {
                    return;
                }
                UPDATING.add(qt);
            }
            try {
                if (event.property().definition() == CustomQueryTerms.PROP_URL) {
                    Criteria criteria;
                    Matcher matcher;
                    String url = qt.getUrl().text();
                    if (url != null && (matcher = URL_PATTERN.matcher(url)).matches() && (criteria = CustomQueryTermListener.decode(matcher.group(1))) != null) {
                        for (Property property : qt.properties()) {
                            if (property.definition() == CustomQueryTerms.PROP_URL) continue;
                            property.clear();
                        }
                        QueryConverter.convertFromMylynQuery(criteria, qt);
                    }
                } else {
                    TaskRepository repository = (TaskRepository)((Query)qt.nearest(Query.class)).getTaskRepository().content();
                    if (repository != null) {
                        Criteria criteria = QueryConverter.readCriteriaFromQuery(qt);
                        String encoded = CustomQueryTermListener.encode(criteria);
                        if (encoded.length() == 0) {
                            qt.setUrl(null);
                        } else {
                            String url = repository.getRepositoryUrl();
                            url = String.valueOf(url.replace("/s/", "/#projects/")) + "/s/";
                            url = String.valueOf(url) + encoded;
                            qt.setUrl(url);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Set<CustomQueryTerms> set2 = UPDATING;
                synchronized (set2) {
                    UPDATING.remove(qt);
                }
                throw throwable;
            }
            Set<CustomQueryTerms> set3 = UPDATING;
            synchronized (set3) {
                UPDATING.remove(qt);
            }
        }

        private static final String encode(Criteria criteria) {
            String str = criteria.toString();
            str = str.replace(' ', '+');
            str = str.replace("<", "%3C");
            str = str.replace(">", "%3E");
            return str;
        }

        private static final Criteria decode(String string) {
            Criteria criteria = null;
            try {
                String str = URLDecoder.decode(string, "UTF-8");
                str = URLDecoder.decode(str, "UTF-8");
                criteria = CriteriaParser.parse((String)str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return criteria;
        }
    }

    public static final class IterationPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (Iteration iteration : configuration.getIterations()) {
                    values.add(iteration.getValue());
                }
            }
        }

        public boolean ordered() {
            return true;
        }
    }

    public static final class NameValidationService
    extends ValidationService {
        protected Status compute() {
            Query query = (Query)this.context(Query.class);
            String name = (String)query.getName().content();
            if (name != null) {
                IRepositoryQuery mq = (IRepositoryQuery)query.getTaskRepositoryQuery().content();
                for (RepositoryQuery q : TasksUiPlugin.getTaskList().getQueries()) {
                    if (q == mq || !name.equals(q.getSummary())) continue;
                    return Status.createErrorStatus((String)Resources.uniqueQueryNameRequired);
                }
            }
            return Status.createOkStatus();
        }
    }

    public static final class PersonPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (TaskUserProfile user : configuration.getUsers()) {
                    values.add(user.getLoginName());
                }
            }
        }
    }

    public static final class PriorityPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (Priority priority : configuration.getPriorities()) {
                    values.add(priority.getValue());
                }
            }
        }

        public boolean ordered() {
            return true;
        }
    }

    public static final class ProductPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (Product product : configuration.getProducts()) {
                    values.add(product.getName());
                }
            }
        }
    }

    public static abstract class QueryTermsPossibleValuesService
    extends PossibleValuesService {
        protected final RepositoryConfiguration configuration() {
            AbstractRepositoryConnector connector;
            Query query = (Query)this.context(Query.class);
            TaskRepository repository = (TaskRepository)query.getTaskRepository().content();
            if (repository != null && (connector = TasksUi.getRepositoryConnector((String)repository.getConnectorKind())) instanceof CloudDevRepositoryConnector) {
                try {
                    return ((CloudDevRepositoryConnector)connector).getRepositoryConfiguration(repository, false, null);
                }
                catch (CoreException coreException) {}
            }
            return null;
        }
    }

    public static final class ReleasePossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (Milestone milestone : configuration.getMilestones()) {
                    values.add(milestone.getValue());
                }
            }
        }

        public boolean ordered() {
            return true;
        }
    }

    public static final class ResolutionPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (TaskResolution resolution : configuration.getResolutions()) {
                    values.add(resolution.getValue());
                }
            }
        }

        public boolean ordered() {
            return true;
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidCustomFieldValue;
        public static String uniqueQueryNameRequired;

        static {
            Resources.initializeMessages((String)QueryServices.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    public static final class SavedQueryPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                PredefinedTaskQuery[] predefinedTaskQueryArray = PredefinedTaskQuery.values();
                int n = predefinedTaskQueryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PredefinedTaskQuery query = predefinedTaskQueryArray[n2];
                    values.add(query.toString());
                    ++n2;
                }
            }
        }
    }

    public static final class SeverityPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (TaskSeverity severity : configuration.getSeverities()) {
                    values.add(severity.getValue());
                }
            }
        }

        public boolean ordered() {
            return true;
        }
    }

    public static final class StatusPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (TaskStatus status : configuration.getStatuses()) {
                    values.add(status.getValue());
                }
            }
        }

        public boolean ordered() {
            return true;
        }
    }

    public static final class TagPossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                for (Keyword keyword : configuration.getKeywords()) {
                    values.add(keyword.getName());
                }
            }
        }
    }

    public static final class TaskRepositoryQueryListener
    extends FilteredListener<PropertyContentEvent> {
        protected void handleTypedEvent(PropertyContentEvent event) {
            Query query = (Query)event.property().element();
            IRepositoryQuery mq = (IRepositoryQuery)query.getTaskRepositoryQuery().content();
            if (mq != null) {
                QueryConverter.convertFromMylynQuery(mq, query);
            }
        }
    }

    public static final class TypePossibleValuesService
    extends QueryTermsPossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            RepositoryConfiguration configuration = this.configuration();
            if (configuration != null) {
                values.addAll(configuration.getTaskTypes());
            }
        }

        public boolean ordered() {
            return true;
        }
    }
}

