/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks.ui;

import java.net.URL;
import oracle.eclipse.tools.cloud.dev.BuiltInQuery;
import oracle.eclipse.tools.cloud.dev.UserDefinedQuery;
import oracle.eclipse.tools.cloud.dev.tasks.ui.CloudViewTasksContentProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;

public class CloudViewTasksLabelProvider
extends TaskElementLabelProvider {
    private static final String PLUGIN_ID = "oracle.eclipse.tools.cloud.dev.tasks.ui";
    private static final String IMG_BUILTIN_QUERY = "images/QueryInactive.png";
    private Image repositoryQueryImage = TasksUiImages.QUERY.createImage();
    private Image builtInQueryImage = null;
    static String DEFAULT_JOB_KEY = "org.eclipse.ui.internal.progress.PROGRESS_DEFAULT";

    public String getText(Object object) {
        if (object instanceof ITask) {
            String taskKey;
            ITask task = (ITask)object;
            String summary = task.getSummary();
            if (summary == null) {
                summary = Messages.TaskElementLabelProvider__no_summary_available_;
            }
            if ((taskKey = task.getTaskKey()) != null) {
                return String.valueOf(taskKey) + ": " + summary;
            }
            return summary;
        }
        if (object instanceof BuiltInQuery) {
            return ((BuiltInQuery)object).getName();
        }
        if (object instanceof UserDefinedQuery) {
            return ((UserDefinedQuery)object).getRepositoryQuery().getSummary();
        }
        if (object instanceof IRepositoryQuery) {
            IRepositoryQuery rq = (IRepositoryQuery)object;
            String label = rq.getSummary();
            return label;
        }
        if (object instanceof IRepositoryElement) {
            IRepositoryElement element = (IRepositoryElement)object;
            return element.getSummary();
        }
        if (object instanceof CloudViewTasksContentProvider.SynchronizingNode) {
            return ((CloudViewTasksContentProvider.SynchronizingNode)object).getLabel();
        }
        return null;
    }

    private Image createImage(String path) {
        URL url = Platform.getBundle((String)PLUGIN_ID).getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }

    public Image getImage(Object element) {
        if (element instanceof CloudViewTasksContentProvider.SynchronizingNode) {
            return JFaceResources.getImage((String)DEFAULT_JOB_KEY);
        }
        if (element instanceof UserDefinedQuery) {
            return this.repositoryQueryImage;
        }
        if (element instanceof BuiltInQuery) {
            if (this.builtInQueryImage == null) {
                this.builtInQueryImage = this.createImage(IMG_BUILTIN_QUERY);
            }
            return this.builtInQueryImage;
        }
        return super.getImage(element);
    }

    public void dispose() {
        super.dispose();
        this.repositoryQueryImage.dispose();
        if (this.builtInQueryImage != null) {
            this.builtInQueryImage.dispose();
        }
    }
}

