/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks.ui;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import com.tasktop.c2c.server.profile.domain.project.ProjectService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.dev.tasks.ui.settings.CloudDevSetting;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CloudDevSettingsPage
extends WizardPage
implements ITaskRepositoryPage,
IAdaptable {
    private TaskRepository taskRepository;
    private CloudDevSetting setting;
    private Set<String> repositoryUrls;
    private String originalUrl;

    public CloudDevSettingsPage(TaskRepository taskRepository) {
        super("CloudDevSettingsPage");
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
        this.taskRepository = taskRepository;
    }

    public void createControl(Composite parent) {
        this.setting = (CloudDevSetting)CloudDevSetting.TYPE.instantiate();
        if (this.taskRepository != null) {
            String label = this.taskRepository.getProperty("label");
            if (label != null) {
                this.setting.setLabel(label);
            }
            this.originalUrl = this.taskRepository.getUrl();
            this.setting.setConnection(this.taskRepository.getProperty(CloudDevSetting.PROP_CONNECTION.name()));
            this.setting.setProject(this.taskRepository.getProperty(CloudDevSetting.PROP_PROJECT.name()));
        }
        this.setting.attach((Listener)new FilteredListener<PropertyValidationEvent>(){

            protected void handleTypedEvent(PropertyValidationEvent event) {
                SwtUtil.runOnDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CloudDevSettingsPage.this.isPageComplete();
                        if (CloudDevSettingsPage.this.getWizard() != null) {
                            CloudDevSettingsPage.this.getWizard().getContainer().updateButtons();
                        }
                    }
                });
            }
        }, "*");
        SapphireForm form = new SapphireForm(parent, (Element)this.setting, DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("SettingPage").form("Setting"));
        this.setControl((Control)form);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void applyTo(TaskRepository repository) {
        repository.setRepositoryLabel((String)this.setting.getLabel().content());
        repository.setProperty("category", "org.eclipse.mylyn.category.tasks");
        repository.setProperty(CloudDevSetting.PROP_CONNECTION.name(), (String)this.setting.getConnection().content());
        repository.setProperty(CloudDevSetting.PROP_PROJECT.name(), (String)this.setting.getProject().content());
        CloudConnection connection = OracleCloudTools.connection((String)((String)this.setting.getConnection().content()));
        ICloudProfile profile = connection.profile();
        AuthenticationCredentials webCredentials = new AuthenticationCredentials((String)profile.getUser().content(), (String)profile.getPassword().content());
        repository.setCredentials(AuthenticationType.HTTP, webCredentials, true);
    }

    public String getRepositoryUrl() {
        CloudConnection connection = OracleCloudTools.connection((String)((String)this.setting.getConnection().content()));
        for (Object service : (List)connection.services().content()) {
            if (!(service instanceof DevServiceDesc)) continue;
            DevServiceDesc svc = (DevServiceDesc)service;
            CloudProject project = svc.project((String)this.setting.getProject().content());
            return ((ProjectService)project.getProject().getProjectServicesOfType(ServiceType.TASKS).get(0)).getUrl();
        }
        throw new IllegalStateException();
    }

    public void performFinish(TaskRepository repository) {
        this.applyTo(repository);
    }

    public boolean preFinish(TaskRepository repository) {
        return true;
    }

    public boolean isPageComplete() {
        Status status = this.setting.validation();
        if (status.severity() == Status.Severity.ERROR) {
            this.setMessage(status.message(), 3);
        } else if (status.severity() == Status.Severity.WARNING) {
            this.setMessage(status.message(), 2);
        } else {
            this.setMessage(null, 0);
            if (!this.isUniqueUrl(this.getRepositoryUrl())) {
                this.setMessage(Resources.repositoryAlreadyExists, 3);
                return false;
            }
        }
        return status.ok();
    }

    protected boolean isUniqueUrl(String urlString) {
        if (!urlString.equals(this.originalUrl)) {
            if (this.repositoryUrls == null) {
                List repositories = TasksUi.getRepositoryManager().getAllRepositories();
                this.repositoryUrls = new HashSet<String>(repositories.size());
                for (TaskRepository repository : repositories) {
                    this.repositoryUrls.add(repository.getRepositoryUrl());
                }
            }
            if (this.repositoryUrls.contains(urlString)) {
                return false;
            }
        }
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;
        public static String repositoryAlreadyExists;

        static {
            Resources.initializeMessages((String)CloudDevSettingsPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

