/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.utils;

import java.util.LinkedList;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern SLASH = Pattern.compile("\\/");

    private StringUtils() {
    }

    public static String join(char delimiter, Iterable parts) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object part : parts) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static String capitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }

    public static String stripParts(String string, int level) {
        int i = 0;
        while (i < level) {
            int index = string.lastIndexOf(47);
            if (index < 0) {
                return "";
            }
            string = string.substring(0, index);
            ++i;
        }
        return string;
    }

    public static LinkedList<String> dotSplitter(String string) {
        return StringUtils.splitter(string, DOT);
    }

    public static LinkedList<String> slashSplitter(String string) {
        return StringUtils.splitter(string, SLASH);
    }

    public static LinkedList<String> splitter(String string, Pattern re) {
        LinkedList<String> parts = new LinkedList<String>();
        String[] stringArray = re.split(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            parts.add(part);
            ++n2;
        }
        return parts;
    }
}

