/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.core.model.OffsetStrategyModel;
import org.python.pydev.refactoring.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetStrategyProvider
implements IStructuredContentProvider {
    private List<OffsetStrategyModel> strategies = new ArrayList<OffsetStrategyModel>();
    private String initLabel;
    private String beginLabel;
    private String endLabel;

    public OffsetStrategyProvider(int strategyOption) {
        this.initLabel();
        this.initStrategies(strategyOption);
    }

    public OffsetStrategyProvider(AbstractScopeNode<?> scopeAdapter, int strategyOption) {
        strategyOption = this.updateLabel(scopeAdapter, strategyOption);
        this.initStrategies(strategyOption);
    }

    private void initLabel() {
        this.initLabel = Messages.offsetStrategyAfterInit;
        this.beginLabel = Messages.offsetStrategyBegin;
        this.endLabel = Messages.offsetStrategyEnd;
    }

    private int updateLabel(AbstractScopeNode<?> scopeAdapter, int strategyOption) {
        if (scopeAdapter != null) {
            if (scopeAdapter.getNodeBodyIndent().length() == 0) {
                this.beginLabel = Messages.offsetStrategyBeginModule;
                this.endLabel = Messages.offsetStrategyEndModule;
                if ((strategyOption & 1) == 1) {
                    strategyOption &= 0xFFFFFFFE;
                }
            } else {
                this.initLabel();
            }
        }
        return strategyOption;
    }

    private void initStrategies(int strategyOption) {
        this.setStrategy(strategyOption, 8, "Before current method.");
        this.setStrategy(strategyOption, 1, this.initLabel);
        this.setStrategy(strategyOption, 2, this.beginLabel);
        this.setStrategy(strategyOption, 4, this.endLabel);
    }

    private void setStrategy(int strategyOption, int id, String label) {
        if ((strategyOption & id) == id) {
            this.strategies.add(new OffsetStrategyModel(id, label));
        }
    }

    public OffsetStrategyModel get(int i) {
        return this.strategies.get(i);
    }

    public Object[] getElements(Object inputElement) {
        return this.strategies.toArray();
    }

    public void dispose() {
        this.strategies = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

