/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.annotate;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jpt.jpa.annotate.DatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.annotate.JptJpaAnnotateMessages;
import org.eclipse.jpt.jpa.annotate.mapping.BasicEntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.EntityMappingsDoc;
import org.eclipse.jpt.jpa.annotate.mapping.EntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.GeneratedValueAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.IdEntityPropertyElement;
import org.eclipse.jpt.jpa.annotate.mapping.JoinStrategy;
import org.eclipse.jpt.jpa.annotate.mapping.JoinTableAttributes;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.ColumnMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.GeneratedValue;
import org.eclipse.jpt.jpa.core.context.GenerationType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneRelationship;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneRelationship;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneRelationship2_0;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassAnnotater {
    private PersistentType persistentType;
    private EntityMappingsDoc mappingDoc;
    private DatabaseAnnotationNameBuilder databaseAnnotationNameBuilder = DatabaseAnnotationNameBuilder.Default.INSTANCE;
    private Schema schema;
    private Table table;

    public JavaClassAnnotater(PersistentType persistentType, EntityMappingsDoc mappingDoc, Schema schema) {
        this.persistentType = persistentType;
        this.mappingDoc = mappingDoc;
        this.schema = schema;
        if (mappingDoc.getTableAttrs().getTableName() != null) {
            this.table = this.schema.getTableNamed(mappingDoc.getTableAttrs().getTableName());
        }
    }

    public void annotate(IProgressMonitor pm) {
        if (this.table != null) {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)(this.mappingDoc.getEntityProperties().length + 1));
            sm.setTaskName(JptJpaAnnotateMessages.ANNOTATE_JAVA_CLASS);
            this.syncTableAnnotation();
            sm.worked(1);
            EntityPropertyElem[] entityPropertyElemArray = this.mappingDoc.getEntityProperties();
            int n = entityPropertyElemArray.length;
            int n2 = 0;
            while (n2 < n) {
                EntityPropertyElem entityPropertyElem = entityPropertyElemArray[n2];
                this.syncPropAnnotation(entityPropertyElem, entityPropertyElem.getPropertyName());
                sm.worked(1);
                ++n2;
            }
        }
    }

    public DatabaseAnnotationNameBuilder getDatabaseAnnotationNameBuilder() {
        return this.databaseAnnotationNameBuilder;
    }

    public void setDatabaseAnnotationNameBuilder(DatabaseAnnotationNameBuilder databaseAnnotationNameBuilder) {
        if (databaseAnnotationNameBuilder == null) {
            throw new NullPointerException("database annotation name builder is required");
        }
        this.databaseAnnotationNameBuilder = databaseAnnotationNameBuilder;
    }

    private void syncTableAnnotation() {
        Entity entity = (Entity)this.persistentType.getMapping();
        String tableName = this.databaseAnnotationNameBuilder.buildTableAnnotationName(entity.getName(), this.table);
        if (tableName != null) {
            entity.getTable().setSpecifiedName(tableName);
        }
    }

    private void syncPropAnnotation(EntityPropertyElem propElem, String attributeName) {
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.persistentType.getAttributeNamed(attributeName);
        if (propElem == null || propElem.isUnmapped()) {
            persistentAttribute.setMappingKey(null);
            return;
        }
        String tagName = propElem.getTagName();
        if (tagName.equals("basic")) {
            this.syncBasicAnnotation(propElem, persistentAttribute);
        } else if (tagName.equals("id")) {
            this.syncIdAnnotation(propElem, persistentAttribute);
        } else if (tagName.equals("many-to-many")) {
            this.syncManyToManyAnnotation(propElem, persistentAttribute);
        } else if (tagName.equals("many-to-one")) {
            this.syncManyToOneAnnotation(propElem, persistentAttribute);
        } else if (tagName.equals("one-to-many")) {
            this.syncOneToManyAnnotation(propElem, persistentAttribute);
        } else if (tagName.equals("one-to-one")) {
            this.syncOneToOneAnnotation(propElem, persistentAttribute);
        }
    }

    private void syncBasicAnnotation(EntityPropertyElem propElem, SpecifiedPersistentAttribute persistentAttribute) {
        AttributeMapping mapping = persistentAttribute.setMappingKey(null);
        BasicMapping basicMapping = (BasicMapping)mapping;
        assert (propElem instanceof BasicEntityPropertyElem);
        BasicEntityPropertyElem basicElem = (BasicEntityPropertyElem)propElem;
        basicElem.getTemporalType();
        this.syncColumnAnnotation(propElem, (ColumnMapping)basicMapping);
    }

    private void syncIdAnnotation(EntityPropertyElem propElem, SpecifiedPersistentAttribute persistentAttribute) {
        AttributeMapping mapping = persistentAttribute.setMappingKey("id");
        IdMapping idMapping = (IdMapping)mapping;
        assert (propElem instanceof IdEntityPropertyElement);
        IdEntityPropertyElement idElem = (IdEntityPropertyElement)propElem;
        GeneratedValueAttributes genAttrs = idElem.getGeneratedValueAttrs();
        if (genAttrs != null) {
            GenerationType type;
            GeneratedValue gv = idMapping.addGeneratedValue();
            if (genAttrs.getStrategy() != null && (type = this.getGenerationType(genAttrs.getStrategy())) != null && type != gv.getDefaultStrategy()) {
                gv.setSpecifiedStrategy(type);
            }
            if (genAttrs.getGenerator() != null && genAttrs.getGenerator().equals(gv.getDefaultGenerator())) {
                gv.setSpecifiedGenerator(genAttrs.getGenerator());
            }
        }
        this.syncColumnAnnotation(propElem, (ColumnMapping)idMapping);
    }

    private void syncColumnAnnotation(EntityPropertyElem propElem, ColumnMapping columnMapping) {
        ColumnAttributes colAttrs = propElem.getColumnAnnotationAttrs();
        SpecifiedColumn column = columnMapping.getColumn();
        if (propElem.getDBColumn() != null) {
            Column dbColumn = propElem.getDBColumn();
            String colName = this.databaseAnnotationNameBuilder.buildColumnAnnotationName(propElem.getPropertyName(), dbColumn);
            if (colName != null) {
                column.setSpecifiedName(colName);
                if (colAttrs.isSetUnique() && colAttrs.isUnique()) {
                    column.setSpecifiedUnique(Boolean.valueOf(colAttrs.isUnique()));
                }
                if (colAttrs.isSetNullable() && !colAttrs.isNullable()) {
                    column.setSpecifiedNullable(Boolean.valueOf(colAttrs.isNullable()));
                }
                if (colAttrs.isSetLength() && colAttrs.getLength() != column.getDefaultLength()) {
                    column.setSpecifiedLength(Integer.valueOf(colAttrs.getLength()));
                }
                if (colAttrs.isSetPrecision() && colAttrs.getPrecision() != column.getDefaultPrecision()) {
                    column.setSpecifiedPrecision(Integer.valueOf(colAttrs.getPrecision()));
                }
                if (colAttrs.isSetScale() && colAttrs.getScale() != column.getDefaultScale()) {
                    column.setSpecifiedScale(Integer.valueOf(colAttrs.getScale()));
                }
                if (colAttrs.isSetInsertable() && !colAttrs.isInsertable()) {
                    column.setSpecifiedInsertable(Boolean.valueOf(colAttrs.isInsertable()));
                }
                if (colAttrs.isSetUpdatable() && !colAttrs.isUpdatable()) {
                    column.setSpecifiedUpdatable(Boolean.valueOf(colAttrs.isUpdatable()));
                }
            }
        }
        if (colAttrs != null && colAttrs.getColumnDefinition() != null) {
            column.setColumnDefinition(colAttrs.getColumnDefinition());
        }
    }

    private void syncManyToOneAnnotation(EntityPropertyElem propElem, SpecifiedPersistentAttribute persistentAttribute) {
        FetchType fetchType;
        assert (propElem instanceof EntityRefPropertyElem);
        EntityRefPropertyElem refPropElem = (EntityRefPropertyElem)propElem;
        AttributeMapping mapping = persistentAttribute.setMappingKey("manyToOne");
        ManyToOneMapping mtoMapping = (ManyToOneMapping)mapping;
        if (refPropElem.getRefEntityClassName() != null && !refPropElem.getRefEntityClassName().equals(mtoMapping.getDefaultTargetEntity())) {
            mtoMapping.setSpecifiedTargetEntity(refPropElem.getRefEntityClassName());
        }
        if (propElem.getAnnotationAttribute("fetch") != null && (fetchType = this.getFetchType(propElem.getAnnotationAttribute((String)"fetch").attrValue)) != null && fetchType != mtoMapping.getDefaultFetch()) {
            mtoMapping.setSpecifiedFetch(fetchType);
        }
        this.syncCascadeMember((RelationshipMapping)mtoMapping, refPropElem);
        if (!this.isJpa1_0Project() && refPropElem.getJoinTable() != null) {
            ManyToOneRelationship relation = mtoMapping.getRelationship();
            ManyToOneRelationship2_0 relation2 = (ManyToOneRelationship2_0)relation;
            relation2.setStrategyToJoinTable();
            SpecifiedJoinTableRelationshipStrategy joinTableStrategy = relation2.getJoinTableStrategy();
            this.syncJoinTableAnnotation(refPropElem, joinTableStrategy);
        } else if (!refPropElem.getJoinColumns().isEmpty()) {
            mtoMapping.getRelationship().setStrategyToJoinColumn();
            SpecifiedJoinColumnRelationshipStrategy joinColumnStrategy = mtoMapping.getRelationship().getJoinColumnStrategy();
            this.syncJoinColumnsAnnotations(refPropElem.getDBTable(), refPropElem.getReferencedTable(), refPropElem.getPropertyName(), refPropElem.getJoinColumns(), joinColumnStrategy);
        }
    }

    private void syncOneToManyAnnotation(EntityPropertyElem propElem, SpecifiedPersistentAttribute persistentAttribute) {
        FetchType fetchType;
        assert (propElem instanceof EntityRefPropertyElem);
        EntityRefPropertyElem refPropElem = (EntityRefPropertyElem)propElem;
        AttributeMapping mapping = persistentAttribute.setMappingKey("oneToMany");
        OneToManyMapping otmMapping = (OneToManyMapping)mapping;
        if (refPropElem.getRefEntityClassName() != null && !refPropElem.getRefEntityClassName().equals(otmMapping.getDefaultTargetEntity())) {
            otmMapping.setSpecifiedTargetEntity(refPropElem.getRefEntityClassName());
        }
        if (propElem.getAnnotationAttribute("fetch") != null && (fetchType = this.getFetchType(propElem.getAnnotationAttribute((String)"fetch").attrValue)) != null && fetchType != otmMapping.getDefaultFetch()) {
            otmMapping.setSpecifiedFetch(fetchType);
        }
        this.syncCascadeMember((RelationshipMapping)otmMapping, refPropElem);
        this.syncToManyAnnotations(propElem, (CollectionMapping)otmMapping);
        if (propElem.getAnnotationAttribute("mappedBy") != null) {
            otmMapping.getRelationship().setStrategyToMappedBy();
            SpecifiedMappedByRelationshipStrategy mappedByStrategy = otmMapping.getRelationship().getMappedByStrategy();
            mappedByStrategy.setMappedByAttribute(propElem.getAnnotationAttribute((String)"mappedBy").attrValue);
        } else if (refPropElem.getJoinTable() != null) {
            otmMapping.getRelationship().setStrategyToJoinTable();
            SpecifiedJoinTableRelationshipStrategy joinTableStrategy = otmMapping.getRelationship().getJoinTableStrategy();
            this.syncJoinTableAnnotation(refPropElem, joinTableStrategy);
        } else if (!this.isJpa1_0Project() && !refPropElem.getJoinColumns().isEmpty()) {
            SpecifiedJoinColumnRelationshipStrategy joinColumnStrategy = null;
            if (otmMapping.getRelationship() instanceof OneToManyRelationship2_0) {
                OneToManyRelationship2_0 relation2_0 = (OneToManyRelationship2_0)otmMapping.getRelationship();
                relation2_0.setStrategyToJoinColumn();
                joinColumnStrategy = relation2_0.getJoinColumnStrategy();
            }
            if (joinColumnStrategy != null) {
                this.syncJoinColumnsAnnotations(refPropElem.getDBTable(), refPropElem.getReferencedTable(), refPropElem.getPropertyName(), refPropElem.getJoinColumns(), joinColumnStrategy);
            }
        }
    }

    private void syncOneToOneAnnotation(EntityPropertyElem propElem, SpecifiedPersistentAttribute persistentAttribute) {
        FetchType fetchType;
        assert (propElem instanceof EntityRefPropertyElem);
        EntityRefPropertyElem refPropElem = (EntityRefPropertyElem)propElem;
        AttributeMapping mapping = persistentAttribute.setMappingKey("oneToOne");
        OneToOneMapping otoMapping = (OneToOneMapping)mapping;
        if (refPropElem.getRefEntityClassName() != null && !refPropElem.getRefEntityClassName().equals(otoMapping.getDefaultTargetEntity())) {
            otoMapping.setSpecifiedTargetEntity(refPropElem.getRefEntityClassName());
        }
        if (propElem.getAnnotationAttribute("fetch") != null && (fetchType = this.getFetchType(propElem.getAnnotationAttribute((String)"fetch").attrValue)) != null && fetchType != otoMapping.getDefaultFetch()) {
            otoMapping.setSpecifiedFetch(fetchType);
        }
        this.syncCascadeMember((RelationshipMapping)otoMapping, refPropElem);
        if (propElem.getAnnotationAttribute("mappedBy") != null) {
            otoMapping.getRelationship().setStrategyToMappedBy();
            SpecifiedMappedByRelationshipStrategy mappedByStrategy = otoMapping.getRelationship().getMappedByStrategy();
            mappedByStrategy.setMappedByAttribute(propElem.getAnnotationAttribute((String)"mappedBy").attrValue);
        } else if (!refPropElem.getJoinColumns().isEmpty()) {
            otoMapping.getRelationship().setStrategyToJoinColumn();
            SpecifiedJoinColumnRelationshipStrategy joinColumnStrategy = otoMapping.getRelationship().getJoinColumnStrategy();
            this.syncJoinColumnsAnnotations(refPropElem.getDBTable(), refPropElem.getReferencedTable(), refPropElem.getPropertyName(), refPropElem.getJoinColumns(), joinColumnStrategy);
        } else if (refPropElem.getJoinStrategy() == JoinStrategy.PRIMARY_KEY_JOIN_COLUMNS) {
            otoMapping.getRelationship().setStrategyToPrimaryKeyJoinColumn();
            SpecifiedPrimaryKeyJoinColumnRelationshipStrategy pkJoinStrategy = otoMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
            this.syncPkJoinColumnAnnotations(refPropElem.getPkJoinColumns(), pkJoinStrategy);
        } else if (!this.isJpa1_0Project() && refPropElem.getJoinTable() != null) {
            OneToOneRelationship relation = otoMapping.getRelationship();
            OneToOneRelationship2_0 relation2 = (OneToOneRelationship2_0)relation;
            relation2.setStrategyToJoinTable();
            SpecifiedJoinTableRelationshipStrategy joinTableStrategy = relation2.getJoinTableStrategy();
            this.syncJoinTableAnnotation(refPropElem, joinTableStrategy);
        }
    }

    private void syncManyToManyAnnotation(EntityPropertyElem propElem, SpecifiedPersistentAttribute persistentAttribute) {
        FetchType fetchType;
        assert (propElem instanceof EntityRefPropertyElem);
        EntityRefPropertyElem refPropElem = (EntityRefPropertyElem)propElem;
        AttributeMapping mapping = persistentAttribute.setMappingKey("manyToMany");
        ManyToManyMapping mtmMapping = (ManyToManyMapping)mapping;
        if (refPropElem.getRefEntityClassName() != null && !refPropElem.getRefEntityClassName().equals(mtmMapping.getDefaultTargetEntity())) {
            mtmMapping.setSpecifiedTargetEntity(refPropElem.getRefEntityClassName());
        }
        if (propElem.getAnnotationAttribute("fetch") != null && (fetchType = this.getFetchType(propElem.getAnnotationAttribute((String)"fetch").attrValue)) != null && fetchType != mtmMapping.getDefaultFetch()) {
            mtmMapping.setSpecifiedFetch(fetchType);
        }
        this.syncCascadeMember((RelationshipMapping)mtmMapping, refPropElem);
        this.syncToManyAnnotations(propElem, (CollectionMapping)mtmMapping);
        if (refPropElem.getAnnotationAttribute("mappedBy") != null) {
            mtmMapping.getRelationship().setStrategyToMappedBy();
            SpecifiedMappedByRelationshipStrategy mappedByStrategy = mtmMapping.getRelationship().getMappedByStrategy();
            mappedByStrategy.setMappedByAttribute(propElem.getAnnotationAttribute((String)"mappedBy").attrValue);
        } else if (refPropElem.getJoinTable() != null) {
            mtmMapping.getRelationship().setStrategyToJoinTable();
            SpecifiedJoinTableRelationshipStrategy joinTableStrategy = mtmMapping.getRelationship().getJoinTableStrategy();
            this.syncJoinTableAnnotation(refPropElem, joinTableStrategy);
        }
    }

    private void syncCascadeMember(RelationshipMapping relationMapping, EntityRefPropertyElem refPropElem) {
        Cascade cascade = relationMapping.getCascade();
        cascade.setAll(false);
        cascade.setMerge(false);
        cascade.setPersist(false);
        cascade.setRefresh(false);
        cascade.setRemove(false);
        List<String> cascadeStrs = refPropElem.getAllCascades();
        for (String cascadeStr : cascadeStrs) {
            if (cascadeStr.equals("cascade-all")) {
                cascade.setAll(true);
            }
            if (cascadeStr.equals("cascade-persist")) {
                cascade.setPersist(true);
            }
            if (cascadeStr.equals("cascade-merge")) {
                cascade.setMerge(true);
            }
            if (cascadeStr.equals("cascade-remove")) {
                cascade.setRemove(true);
            }
            if (!cascadeStr.equals("cascade-refresh")) continue;
            cascade.setRefresh(true);
        }
    }

    private void syncJoinTableAnnotation(EntityRefPropertyElem refPropEmElem, SpecifiedJoinTableRelationshipStrategy jtRelation) {
        JoinTableAttributes joinTableAttrs = refPropEmElem.getJoinTable();
        assert (joinTableAttrs != null);
        SpecifiedJoinTable joinTable = jtRelation.getJoinTable();
        Table dbJoinTable = null;
        if (joinTableAttrs.getTableName() != null && (dbJoinTable = this.schema.getTableNamed(joinTableAttrs.getTableName())) != null) {
            String joinTableName = this.databaseAnnotationNameBuilder.buildJoinTableAnnotationName(dbJoinTable);
            joinTable.setSpecifiedName(joinTableName != null ? joinTableName : dbJoinTable.getName());
        }
        List<ColumnAttributes> cols = joinTableAttrs.getJoinColumns();
        for (ColumnAttributes col : cols) {
            SpecifiedJoinColumn joinColumn = joinTable.addSpecifiedJoinColumn();
            this.syncJoinColumnAnnotations(true, dbJoinTable, refPropEmElem.getDBTable(), refPropEmElem.getPropertyName(), col, joinColumn);
        }
        List<ColumnAttributes> inverseCols = joinTableAttrs.getInverseJoinColumns();
        for (ColumnAttributes col : inverseCols) {
            SpecifiedJoinColumn joinColumn = joinTable.addSpecifiedInverseJoinColumn();
            this.syncJoinColumnAnnotations(true, dbJoinTable, refPropEmElem.getReferencedTable(), refPropEmElem.getPropertyName(), col, joinColumn);
        }
    }

    private void syncJoinColumnAnnotations(boolean isJoinTable, Table baseTable, Table refTable, String propName, ColumnAttributes col, SpecifiedJoinColumn joinColumn) {
        if (baseTable == null || refTable == null) {
            return;
        }
        boolean printoutNameOrRefName = false;
        if (col.getName() != null) {
            Column refDbCol;
            Column dbColumn = baseTable.getColumnNamed(col.getName());
            ForeignKey fk = this.getForeignKey(dbColumn);
            Column column = refDbCol = col.getReferencedColumnName() != null ? refTable.getColumnNamed(col.getReferencedColumnName()) : null;
            if (fk != null && !fk.referencesSingleColumnPrimaryKey() || isJoinTable) {
                if (refDbCol != null) {
                    String colName = this.databaseAnnotationNameBuilder.buildJoinColumnAnnotationName(dbColumn);
                    String refColName = this.databaseAnnotationNameBuilder.buildJoinColumnAnnotationName(refDbCol);
                    joinColumn.setSpecifiedName(colName);
                    joinColumn.setSpecifiedReferencedColumnName(refColName);
                    printoutNameOrRefName = true;
                }
            } else {
                String colName = this.databaseAnnotationNameBuilder.buildColumnAnnotationName(propName, dbColumn);
                if (colName != null) {
                    joinColumn.setSpecifiedName(colName);
                    printoutNameOrRefName = true;
                }
            }
        }
        if (printoutNameOrRefName) {
            if (col.isSetUnique() && col.isUnique()) {
                joinColumn.setSpecifiedUnique(Boolean.valueOf(col.isUnique()));
            }
            if (col.isSetNullable() && !col.isNullable()) {
                joinColumn.setSpecifiedNullable(Boolean.valueOf(col.isNullable()));
            }
            if (col.isSetInsertable() && !col.isInsertable()) {
                joinColumn.setSpecifiedInsertable(Boolean.valueOf(col.isInsertable()));
            }
            if (col.isSetUpdatable() && !col.isUpdatable()) {
                joinColumn.setSpecifiedUpdatable(Boolean.valueOf(col.isUpdatable()));
            }
            if (col.getColumnDefinition() != null) {
                joinColumn.setColumnDefinition(col.getColumnDefinition());
            }
        }
    }

    private void syncJoinColumnsAnnotations(Table baseTable, Table refTable, String propertyName, List<ColumnAttributes> joinColumns, SpecifiedJoinColumnRelationshipStrategy joinColumnStrategy) {
        if (joinColumns == null || joinColumns.size() == 0) {
            return;
        }
        int count = joinColumns.size();
        int i = count - 1;
        while (i >= 0) {
            if (joinColumns.get(i).isEmpty()) {
                joinColumns.remove(i);
            }
            --i;
        }
        count = joinColumns.size();
        i = 0;
        while (i < count) {
            ColumnAttributes col = joinColumns.get(i);
            SpecifiedJoinColumn joinColumn = joinColumnStrategy.addSpecifiedJoinColumn();
            this.syncJoinColumnAnnotations(false, baseTable, refTable, propertyName, col, joinColumn);
            ++i;
        }
    }

    private void syncToManyAnnotations(EntityPropertyElem propElem, CollectionMapping collectionMapping) {
        assert (propElem instanceof EntityPropertyElem);
        EntityRefPropertyElem refPropElem = (EntityRefPropertyElem)propElem;
        if (refPropElem.getOrderBy() != null) {
            collectionMapping.getOrderable().setSpecifiedOrderBy(refPropElem.getOrderBy());
        }
    }

    private void syncPkJoinColumnAnnotations(List<ColumnAttributes> pkJoinCols, SpecifiedPrimaryKeyJoinColumnRelationshipStrategy pkJoinStrategy) {
        for (ColumnAttributes pkJoinCol : pkJoinCols) {
            SpecifiedPrimaryKeyJoinColumn pkJoinColumn = pkJoinStrategy.addPrimaryKeyJoinColumn();
            if (pkJoinCol.getName() != null && !pkJoinCol.getName().equals(pkJoinColumn.getDefaultName())) {
                pkJoinColumn.setSpecifiedName(pkJoinCol.getName());
            }
            if (pkJoinCol.getReferencedColumnName() != null && !pkJoinCol.getReferencedColumnName().equals(pkJoinColumn.getDefaultReferencedColumnName())) {
                pkJoinColumn.setSpecifiedReferencedColumnName(pkJoinCol.getReferencedColumnName());
            }
            if (pkJoinCol.getColumnDefinition() == null) continue;
            pkJoinColumn.setColumnDefinition(pkJoinCol.getColumnDefinition());
        }
    }

    private GenerationType getGenerationType(String strategy) {
        if (strategy.equalsIgnoreCase("auto")) {
            return GenerationType.AUTO;
        }
        if (strategy.equalsIgnoreCase("identity")) {
            return GenerationType.IDENTITY;
        }
        if (strategy.equalsIgnoreCase("sequence")) {
            return GenerationType.SEQUENCE;
        }
        if (strategy.equalsIgnoreCase("table")) {
            return GenerationType.TABLE;
        }
        return null;
    }

    private FetchType getFetchType(String fetch) {
        if (fetch == null) {
            return null;
        }
        if (fetch.equalsIgnoreCase("eager")) {
            return FetchType.EAGER;
        }
        if (fetch.equalsIgnoreCase("lazy")) {
            return FetchType.LAZY;
        }
        return null;
    }

    private boolean isJpa1_0Project() {
        return this.persistentType.getPersistenceUnit().getJpaPlatform().getJpaVersion().getVersion().equals("1.0");
    }

    private ForeignKey getForeignKey(Column dbColumn) {
        if (dbColumn == null || !dbColumn.isPartOfForeignKey()) {
            return null;
        }
        ForeignKey foreignKey = null;
        Iterable it = dbColumn.getTable().getForeignKeys();
        for (ForeignKey fk : it) {
            Column c = (Column)fk.getBaseColumns().iterator().next();
            if (!c.equals(dbColumn)) continue;
            foreignKey = fk;
            break;
        }
        return foreignKey;
    }
}

