/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.adfdt.view.common.binding.creator.CreatorInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.util.BindingInfoQuery;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class AdfFrameworkCommandProvider
implements CommandProvider {
    private BindingInfoQuery _bindingInfoQuery;

    public void _adfv1(CommandInterpreter ci) {
        String arg;
        ArrayList<String> args = new ArrayList<String>();
        while ((arg = ci.nextArgument()) != null) {
            args.add(arg);
        }
        this.processAdfCommand(ci, args);
    }

    private void processAdfCommand(CommandInterpreter ci, List<String> args) {
        String arg1;
        if (args.isEmpty()) {
            ci.println((Object)"Usage: adfv1 <args>");
        }
        if ("list".equals(arg1 = args.remove(0))) {
            this.handleCiList(ci, args);
        }
    }

    private void handleCiList(CommandInterpreter ci, List<String> args) {
        if (args.isEmpty()) {
            ci.println((Object)"Usage: adfv1 list <args>");
            return;
        }
        String arg1 = args.remove(0);
        if ("names".equals(arg1)) {
            this.handleCiListNames(ci, args);
        } else if ("properties".equals(arg1)) {
            this.handleCliProperties(ci, args);
        }
    }

    private void handleCliProperties(CommandInterpreter ci, List<String> args) {
        if (args.isEmpty()) {
            this.listProperties(ci, Collections.EMPTY_LIST);
        } else {
            this.listProperties(ci, args);
        }
    }

    private void listProperties(CommandInterpreter ci, List<String> args) {
        BindingInfoQuery bindingInfoQuery = this.getOrCreateBindingInfoQuery();
        for (Map.Entry<String, List<CreatorInfo>> entry : bindingInfoQuery.getByProperty().entrySet()) {
            boolean isInFilter = args.isEmpty();
            for (String filterArg : args) {
                if (!entry.getKey().startsWith(filterArg)) continue;
                isInFilter = true;
            }
            if (!isInFilter) continue;
            ci.println((Object)("Property " + entry.getKey()));
            for (CreatorInfo creatorinfo : entry.getValue()) {
                ci.println((Object)("\t" + this.getText(creatorinfo)));
            }
        }
    }

    private void handleCiListNames(CommandInterpreter ci, List<String> args) {
        if (args.isEmpty()) {
            this.listNames(ci, null);
        } else {
            this.listNames(ci, args.get(0));
        }
    }

    private void listNames(CommandInterpreter ci, String filter) {
        BindingInfoQuery bindingInfoQuery = this.getOrCreateBindingInfoQuery();
        int matching = 0;
        for (Map.Entry<String, CreatorInfo> entry : bindingInfoQuery.getIndexByName().entrySet()) {
            String name = entry.getKey();
            if (filter != null && !name.contains(filter)) continue;
            ci.println((Object)this.getText(entry.getValue()));
            ++matching;
        }
        ci.println((Object)String.format("Found %d matches %s", matching, filter == null ? "" : "for " + filter));
    }

    private String getText(CreatorInfo creatorInfo) {
        return String.format("%s, ns = %s, localName = %s", creatorInfo.getName(), creatorInfo.getNamespace(), creatorInfo.getLocalName());
    }

    private BindingInfoQuery getOrCreateBindingInfoQuery() {
        if (this._bindingInfoQuery == null) {
            this._bindingInfoQuery = new BindingInfoQuery();
            this._bindingInfoQuery.init();
        }
        return this._bindingInfoQuery;
    }

    public String getHelp() {
        return null;
    }
}

