/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphUtils;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;

class OepeGraphUtils {
    OepeGraphUtils() {
    }

    public static int convertGraphTypeToInt(String graphSubType) {
        return CommonGraph.convertGraphTypeToInt((String)graphSubType);
    }

    public static boolean isO1AxisSupported(String graphSubType) {
        return graphSubType == null || graphSubType.isEmpty() ? false : GraphUtils.isO1AxisSupported((int)OepeGraphUtils.convertGraphTypeToInt(graphSubType));
    }

    public static boolean isDualYGraph(IPresentationLayout layout) {
        String graphSubtype;
        if (layout != null && (graphSubtype = layout.getVariationType()) != null && !graphSubtype.isEmpty()) {
            return OepeGraphUtils.isDualYGraph(graphSubtype);
        }
        return false;
    }

    public static boolean isDualYGraph(String graphSubType) {
        if (graphSubType == null || graphSubType.isEmpty()) {
            return false;
        }
        int type = OepeGraphUtils.convertGraphTypeToInt(graphSubType);
        return GraphUtils.isAssignedToY2Supported((int)type) || 95 == type;
    }

    public static boolean isRadarGraph(String graphSubType) {
        return graphSubType == null || graphSubType.isEmpty() ? false : GraphUtils.isRadarGraph((int)OepeGraphUtils.convertGraphTypeToInt(graphSubType));
    }

    public static boolean isPieY1AxisSupported(String graphSubType) {
        if (graphSubType == null || graphSubType.isEmpty()) {
            return false;
        }
        int type = OepeGraphUtils.convertGraphTypeToInt(graphSubType);
        return type == 93 || type == 94;
    }

    public static boolean isMultiPieRing(IPresentationLayout layout) {
        String graphSubtype;
        if (layout != null && (graphSubtype = layout.getVariationType()) != null && !graphSubtype.isEmpty()) {
            return OepeGraphUtils.isMultiPieRing(graphSubtype);
        }
        return false;
    }

    public static boolean isMultiPieRing(String graphSubType) {
        if (graphSubType == null || graphSubType.isEmpty()) {
            return false;
        }
        int type = OepeGraphUtils.convertGraphTypeToInt(graphSubType);
        switch (type) {
            case 57: 
            case 58: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPieRingBar(IPresentationLayout layout) {
        String graphSubtype;
        if (layout != null && (graphSubtype = layout.getVariationType()) != null && !graphSubtype.isEmpty()) {
            return OepeGraphUtils.isPieRingBar(graphSubtype);
        }
        return false;
    }

    public static boolean isPieRingBar(String graphSubType) {
        if (graphSubType == null || graphSubType.isEmpty()) {
            return false;
        }
        int type = OepeGraphUtils.convertGraphTypeToInt(graphSubType);
        switch (type) {
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRingTypeGraph(IPresentationLayout layout) {
        String graphSubtype;
        if (layout != null && (graphSubtype = layout.getVariationType()) != null && !graphSubtype.isEmpty()) {
            return OepeGraphUtils.isRingTypeGraph(graphSubtype);
        }
        return false;
    }

    public static boolean isRingTypeGraph(String graphSubType) {
        if (graphSubType == null || graphSubType.isEmpty()) {
            return false;
        }
        int type = OepeGraphUtils.convertGraphTypeToInt(graphSubType);
        switch (type) {
            case 56: 
            case 58: 
            case 94: {
                return true;
            }
        }
        return false;
    }
}

