/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphOptions;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphSubtitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendArea;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.O1Title;
import oracle.adfdt.view.dvt.binding.pattern.graph.Y1Title;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsResources;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.ICommonAxisGraphOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.OepeGraphUtils;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AxisGraphOptionsMapper<O extends GraphOptions>
extends GraphOptionsMapper<O> {
    protected static final String PLOTAREA_TAG_NAME = "graphPlotArea";
    private static final String QUICKLAYOUT_QL2 = "QL2_all_titles";
    private static final String QUICKLAYOUT_QL3 = "QL3_old_titles";
    private static final String QUICKLAYOUT_QL4 = "QL4_new_titles";
    private static final String QUICKLAYOUT_QL5 = "QL5_no_gridlines";
    private static final String O1AXIS_TAG_NAME = "o1Axis";
    private static final String TICKSTYLE_ATTR_NAME = "tickStyle";
    private static final String TICKSTYLE_GS_NONE = "GS_NONE";
    private static final String X1AXIS_TAG_NAME = "x1Axis";
    private static final String Y2AXIS_TAG_NAME = "y2Axis";
    private static final String Y1MAJORTICK_TAG_NAME = "y1MajorTick";
    private static final int VALIDATE_STATE_START = 0;
    private static final int VALIDATE_STATE_NON_NUMERIC = 1;
    private static final int VALIDATE_STATE_NUMERIC = 2;
    private static final int VALIDATE_STATE_NON_NUMERIC_NUMERIC = 3;
    private static final int VALIDATE_STATE_NUMERIC_NON_NUMERIC = 4;
    private static final int VALIDATE_STATE_ERROR_SPLIT_EDGE = 5;
    private static final int VALIDATE_STATE_ERROR_SPLIT_EDGES = 6;
    private static final int VALIDATE_OP_NON_NUMERIC = 0;
    private static final int VALIDATE_OP_NUMERIC = 1;

    public AxisGraphOptionsMapper(BindOperationType opType, Widget<O> widget, CreatorParams<O> params) {
        super(opType, widget, params);
    }

    @Override
    public IStatus validateModel() {
        IStatus status = this.validateSeriesAndGroups(this.getModel());
        if (status != null && status.getSeverity() == 4) {
            return status;
        }
        boolean dataIsOnSeries = this.getModel().isDataOnSeries();
        String dataEdgeLabel = null;
        List dataPointEdge = null;
        if (dataIsOnSeries) {
            dataEdgeLabel = this.getSeriesLabel();
            dataPointEdge = this.getModel().getSeriesItemContexts();
        } else {
            dataEdgeLabel = this.getGroupsLabel();
            dataPointEdge = this.getModel().getGroupsItemContexts();
        }
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (OepeGraphUtils.isDualYGraph(layout)) {
            if (!AxisGraphOptionsMapper.edgeHasDataItemCount(dataPointEdge, 2)) {
                String message = GraphOptionsResources.error_missingDualYNumericDataPoints;
                message = NLS.bind((String)message, (Object)dataEdgeLabel);
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", message);
            }
        } else if (!AxisGraphOptionsMapper.edgeHasDataItemCount(dataPointEdge, 1)) {
            String message = GraphOptionsResources.error_missingNumericDataPoint;
            message = NLS.bind((String)message, (Object)dataEdgeLabel);
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", message);
        }
        return this.getDuplicateValueError();
    }

    private IStatus validateSeriesAndGroups(IGraphOptionsModel graphModel) {
        boolean dataOnSeries = graphModel.isDataOnSeries();
        IStatus status = this.validateEdge(graphModel.getSeriesItemContexts(), dataOnSeries);
        if (status != null && status.getSeverity() == 4) {
            return status;
        }
        return this.validateEdge(graphModel.getGroupsItemContexts(), !dataOnSeries);
    }

    private IStatus validateEdge(List<EdgeItemContext> edgeItemContexts, boolean dataEdge) {
        if (edgeItemContexts == null || edgeItemContexts.isEmpty()) {
            return null;
        }
        int validationState = 0;
        for (EdgeItemContext item : edgeItemContexts) {
            if ((validationState = this.validateItem(validationState, item, dataEdge)) == 5) {
                String message = GraphOptionsResources.error_intermingledDataEdge;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", message);
            }
            if (validationState != 6) continue;
            String message = GraphOptionsResources.error_dataPointsOnMultipleEdges;
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", message);
        }
        return null;
    }

    protected int validateItem(int validationState, EdgeItemContext itemAccess, boolean dataEdge) {
        boolean nOperator = false;
        if (itemAccess != null && itemAccess.isNumeric() && !itemAccess.isTreatAsText()) {
            nOperator = true;
        }
        switch (validationState) {
            case 0: {
                if (!nOperator) {
                    validationState = 1;
                    break;
                }
                if (!nOperator) break;
                validationState = 2;
                if (dataEdge) break;
                validationState = 6;
                break;
            }
            case 1: {
                if (!nOperator) break;
                validationState = 3;
                if (dataEdge) break;
                validationState = 6;
                break;
            }
            case 2: {
                if (nOperator) break;
                validationState = 4;
                break;
            }
            case 3: {
                if (nOperator) break;
                validationState = 4;
                break;
            }
            case 4: {
                if (!nOperator) break;
                validationState = 5;
                if (dataEdge) break;
                validationState = 6;
            }
        }
        return validationState;
    }

    protected IStatus getDuplicateValueError() {
        ArrayList allItems = new ArrayList(this.getModel().getGroupsItemContexts());
        allItems.addAll(this.getModel().getSeriesItemContexts());
        HashSet<String> itemSet = new HashSet<String>();
        for (EdgeItemContext item : allItems) {
            if (itemSet.contains(item.getName())) {
                String message = GraphOptionsResources.error_duplicateValue;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", NLS.bind((String)message, (Object)item.getName()));
            }
            itemSet.add(item.getName());
        }
        return null;
    }

    protected abstract String getSeriesLabel();

    protected String getGroupsLabel() {
        return GraphOptionsResources.axisGraph_groupsLabel;
    }

    @Override
    public void updateOptions() {
        ICommonAxisGraphOptions commonOptions = this.getCommonGraphOptions();
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            commonOptions.setGraphSubType(layout.getVariationType());
            String quickLayout = layout.getQuickLayout();
            if (quickLayout.equals(QUICKLAYOUT_QL2)) {
                AxisGraphOptionsMapper.configureQuickLayout2(commonOptions);
                if (OepeGraphUtils.isO1AxisSupported(layout.getVariationType())) {
                    if (!OepeGraphUtils.isRadarGraph(layout.getVariationType())) {
                        this.addO1Title(commonOptions);
                    }
                } else {
                    this.addX1Title(commonOptions);
                }
                if (!OepeGraphUtils.isRadarGraph(layout.getVariationType())) {
                    this.addY1Title(commonOptions);
                }
            } else if (quickLayout.equals(QUICKLAYOUT_QL3)) {
                AxisGraphOptionsMapper.configureAxisQuickLayout3(commonOptions);
            } else if (quickLayout.equals(QUICKLAYOUT_QL4)) {
                AxisGraphOptionsMapper.configureAxisQuickLayout4(commonOptions);
            } else if (quickLayout.equals(QUICKLAYOUT_QL5)) {
                AxisGraphOptionsMapper.configureAxisQuickLayout5(commonOptions);
            }
        }
        this.update(commonOptions);
    }

    @Override
    protected abstract ICommonAxisGraphOptions getCommonGraphOptions();

    protected void addO1Title(ICommonAxisGraphOptions options) {
        O1Title title = new O1Title();
        title.setText(GraphOptionsResources.quickLayout_o1Title);
        options.setO1Title(title);
    }

    protected void addX1Title(ICommonAxisGraphOptions options) {
    }

    protected void addY1Title(ICommonAxisGraphOptions options) {
        Y1Title title = new Y1Title();
        title.setText(GraphOptionsResources.quickLayout_y1Title);
        options.setY1Title(title);
    }

    private static void configureAxisQuickLayout3(ICommonAxisGraphOptions options) {
        LegendArea legendArea = new LegendArea();
        legendArea.setPosition("LAP_BOTTOM");
        options.setLegendArea(legendArea);
        LegendTitle legendTitle = new LegendTitle();
        legendTitle.setText(GraphOptionsResources.quickLayout_legendTitle);
        options.setLegendTitle(legendTitle);
        GraphSubtitle graphSubtitle = new GraphSubtitle();
        graphSubtitle.setHorizontalAlignment("CENTER");
        graphSubtitle.setText(GraphOptionsResources.quickLayout_graphSubtitle);
        options.setGraphSubtitle(graphSubtitle);
        GraphTitle graphTitle = new GraphTitle();
        graphTitle.setHorizontalAlignment("CENTER");
        graphTitle.setText(GraphOptionsResources.quickLayout_graphTitle);
        options.setGraphTitle(graphTitle);
    }

    private static void configureAxisQuickLayout4(ICommonAxisGraphOptions options) {
        LegendArea legendArea = new LegendArea();
        legendArea.setPosition("LAP_TOP");
        options.setLegendArea(legendArea);
        GraphSubtitle graphSubtitle = new GraphSubtitle();
        graphSubtitle.setText(GraphOptionsResources.quickLayout_graphSubtitle);
        options.setGraphSubtitle(graphSubtitle);
        GraphTitle graphTitle = new GraphTitle();
        graphTitle.setText(GraphOptionsResources.quickLayout_graphTitle);
        options.setGraphTitle(graphTitle);
    }

    private static void configureAxisQuickLayout5(ICommonAxisGraphOptions options) {
        LegendArea legendArea = new LegendArea();
        legendArea.setRendered(false);
        options.setLegendArea(legendArea);
    }

    @Override
    public void postProcess(Node node) {
        Element graphElement = AxisGraphOptionsMapper.getSingleBindRoot(node);
        if (graphElement == null || !this.getType().toString().equals(graphElement.getLocalName())) {
            return;
        }
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            Element refChild = AxisGraphOptionsMapper.addBackgroundTag(graphElement);
            refChild = AxisGraphOptionsMapper.addTag(graphElement, PLOTAREA_TAG_NAME, refChild);
            refChild = AxisGraphOptionsMapper.addSeriesSetTag(graphElement, refChild);
            refChild = this.addAxisTags(layout.getVariationType(), graphElement, refChild);
            String quickLayout = layout.getQuickLayout();
            if (quickLayout.equals("QL1_default") || quickLayout.equals(QUICKLAYOUT_QL2) || quickLayout.equals(QUICKLAYOUT_QL4)) {
                this.updateLegendAreaAutomaticPlacementAttr(graphElement);
            } else if (quickLayout.equals(QUICKLAYOUT_QL3)) {
                graphElement.setAttribute("customLayout", "CL_NONE");
                this.updateLegendAreaAutomaticPlacementAttr(graphElement);
            } else if (quickLayout.equals(QUICKLAYOUT_QL5)) {
                this.addAxisQuickLayout5(graphElement);
            }
        }
    }

    protected Element addAxisTags(String graphSubType, Element graph, Element refChild) {
        Element nextRefChild = OepeGraphUtils.isO1AxisSupported(graphSubType) ? AxisGraphOptionsMapper.addTag(graph, O1AXIS_TAG_NAME, refChild) : AxisGraphOptionsMapper.addTag(graph, X1AXIS_TAG_NAME, refChild);
        nextRefChild = AxisGraphOptionsMapper.addTag(graph, "y1Axis", nextRefChild);
        if (OepeGraphUtils.isDualYGraph(graphSubType)) {
            nextRefChild = AxisGraphOptionsMapper.addTag(graph, Y2AXIS_TAG_NAME, nextRefChild);
        }
        return nextRefChild;
    }

    private void addAxisQuickLayout5(Element graph) {
        Document doc = graph.getOwnerDocument();
        Element newTag = doc.createElementNS("http://xmlns.oracle.com/dss/adf/faces", Y1MAJORTICK_TAG_NAME);
        newTag.setAttribute(TICKSTYLE_ATTR_NAME, TICKSTYLE_GS_NONE);
        Node legendArea = null;
        NodeList children = graph.getElementsByTagNameNS("http://xmlns.oracle.com/dss/adf/faces", "legendArea");
        if (children.getLength() == 1) {
            legendArea = (Element)children.item(0);
        }
        if (legendArea == null || legendArea.getNextSibling() == null) {
            graph.appendChild(newTag);
        } else {
            graph.insertBefore(newTag, legendArea.getNextSibling());
        }
    }
}

