/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import oracle.eclipse.tools.adf.dtrt.vbundle.bindingobject.el.ParameterELBindStrategy;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.TaskFlowWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.WidgetType;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui.TextDialogCellEditor;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogWidgetAdapter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class ParameterViewer {
    private static final String NAME_COLUMN = "name";
    private static final String VALUE_COLUMN = "value";
    private static final String[] COLUMN_NAMES = new String[]{"name", "value"};
    private DataBindingContext dataBindingContext;
    private ParameterELBindStrategy elBindStrategy;
    private WidgetType widgetType;
    private TableModel tableModel = new TableModel();
    private TableViewer tableViewer;
    private int parameterNumber = 0;
    private String parameterMapEL;
    private TypedListenerList<IStatusListener> statusListeners;
    private IStatus status = Status.OK_STATUS;

    ParameterViewer() {
    }

    public void dispose() {
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
            this.dataBindingContext = null;
        }
        if (this.tableModel != null) {
            this.tableModel.dispose();
            this.tableModel = null;
        }
        if (this.elBindStrategy != null) {
            this.elBindStrategy.dispose();
            this.elBindStrategy = null;
        }
        this.tableViewer = null;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void addStatusListener(IStatusListener listener) {
        if (this.statusListeners == null) {
            this.statusListeners = new TypedListenerList();
        }
        this.statusListeners.add((Object)listener);
    }

    public void removeStatusListener(IStatusListener listener) {
        if (this.statusListeners != null) {
            this.statusListeners.remove((Object)listener);
            if (this.statusListeners.isEmpty()) {
                this.statusListeners = null;
            }
        }
    }

    private void notifyStatusListener(IStatus status) {
        this.status = status;
        if (this.statusListeners != null) {
            for (IStatusListener listener : this.statusListeners) {
                listener.handleStatus(status);
            }
        }
    }

    public String getParameterMapEL() {
        return this.parameterMapEL;
    }

    public List<? extends Pair<String, String>> getParameterPairs() {
        List<Parameter> paremeters;
        if (this.tableModel != null && !(paremeters = this.tableModel.getParameters()).isEmpty()) {
            ArrayList<Pair> pairs = new ArrayList<Pair>(paremeters.size());
            for (Parameter parameter : paremeters) {
                if (parameter.getName() == null || parameter.getValue() == null) continue;
                pairs.add(new Pair((Object)parameter.getName(), (Object)parameter.getValue()));
            }
            if (!pairs.isEmpty()) {
                return Collections.unmodifiableList(pairs);
            }
        }
        return Collections.emptyList();
    }

    public Control createControl(Composite parent, IWebPageContext context, TaskFlowWidget widget) {
        this.dataBindingContext = new DataBindingContext();
        this.elBindStrategy = new ParameterELBindStrategy((IOEPEContext)context);
        this.widgetType = widget.getType();
        AbstractObservableValue parameterMapELModel = new AbstractObservableValue(){

            public Object getValueType() {
                return String.class;
            }

            protected Object doGetValue() {
                return ParameterViewer.this.parameterMapEL;
            }

            protected void doSetValue(Object value) {
                String string = (String)value;
                if (string != null && string.trim().length() == 0) {
                    string = null;
                }
                if (!DTRTUtil.equals((Object)ParameterViewer.this.parameterMapEL, (Object)string)) {
                    String old = ParameterViewer.this.parameterMapEL;
                    ParameterViewer.this.parameterMapEL = string;
                    this.fireValueChange(Diffs.createValueDiff((Object)old, (Object)ParameterViewer.this.parameterMapEL));
                }
            }
        };
        parameterMapELModel.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ParameterViewer.this.validate();
            }
        });
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(15, 15).applyTo(composite);
        Composite parameterMapComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(parameterMapComposite);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)parameterMapComposite);
        new Label(parameterMapComposite, 0).setText(Messages.parameterMapLabel);
        Text parameterMapELText = new Text(parameterMapComposite, 2052);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)parameterMapELText);
        ISWTObservableValue target = SWTObservables.observeText((Control)parameterMapELText, (int)24);
        this.dataBindingContext.bindValue((IObservableValue)target, (IObservableValue)parameterMapELModel);
        TextDialogCellEditor.addBindButton(parameterMapComposite, (DialogCreationStrategy)this.elBindStrategy, (IObservableValue)parameterMapELModel, 0x800000);
        Composite bottom = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(bottom);
        DTRTUIUtil.applyGrabAllGridData((Control)bottom).heightHint = 200;
        Composite parameterTitleComposite = new Composite(bottom, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parameterTitleComposite);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)parameterTitleComposite);
        Label parameterTitleLabel = new Label(parameterTitleComposite, 0);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)parameterTitleLabel).verticalAlignment = 0x1000000;
        parameterTitleLabel.setText(Messages.inputParametersLabel);
        if (this.widgetType == WidgetType.DYNAMIC_REGION) {
            ToolBar parameterToolBar = DialogWidgetAdapter.INSTANCE.createToolBar(parameterTitleComposite, 0x800000);
            parameterToolBar.setLayoutData((Object)new GridData(131072, 128, false, false));
            ToolItem add = new ToolItem(parameterToolBar, 8);
            add.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_ADD));
            add.setToolTipText(Messages.addParameterToolTip);
            add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterViewer.this.tableModel.addParameter(new Parameter(ParameterViewer.this.generateParameterName()));
                    ParameterViewer.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            ToolItem delete = new ToolItem(parameterToolBar, 8);
            delete.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_DELETE));
            delete.setToolTipText(Messages.deleteParameterToolTip);
            delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Parameter parameter = (Parameter)((IStructuredSelection)ParameterViewer.this.tableViewer.getSelection()).getFirstElement();
                    if (parameter != null) {
                        ParameterViewer.this.tableModel.deleteParameter(parameter);
                        ParameterViewer.this.validate();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        } else {
            for (IWebPageContext.IParameterProxy parameter : widget.forObject().getParameters()) {
                this.tableModel.addParameter(new Parameter(parameter));
            }
        }
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)new Label(bottom, 258));
        Table table = this.createTable(bottom);
        DTRTUIUtil.applyGrabAllGridData((Control)table);
        this.tableViewer = this.createTableViewer(table);
        if (this.tableModel.hasRequiredParameter()) {
            new Label(bottom, 16384).setText(Messages.requiredToolTip);
        }
        this.validate();
        return composite;
    }

    private void validate() {
        if (this.parameterMapEL != null && !TaskFlowWidget.hasEL(this.parameterMapEL)) {
            this.notifyStatusListener((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", Messages.invalidParameterMap));
            return;
        }
        for (Parameter parameter : this.tableModel.getParameters()) {
            if (parameter.getName() != null) continue;
            this.notifyStatusListener((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", Messages.noParameterNameError));
            return;
        }
        if (this.parameterMapEL == null) {
            for (Parameter parameter : this.tableModel.getParameters()) {
                if (!parameter.isRequired() || parameter.getValue() != null) continue;
                this.notifyStatusListener((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", Messages.noValueForRequiredParameterError));
                return;
            }
        }
        this.notifyStatusListener(Status.OK_STATUS);
    }

    private String generateParameterName() {
        return NLS.bind((String)Messages.newParameterName, (Object)this.parameterNumber++);
    }

    private Table createTable(Composite parent) {
        int tableStyle = 101124;
        Table table = new Table(parent, tableStyle);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn nameCol = new TableColumn(table, 16384, 0);
        nameCol.setText(Messages.nameColumnTitle);
        nameCol.setWidth(150);
        TableColumn valueCol = new TableColumn(table, 16384, 1);
        valueCol.setText(Messages.valueColumnTitle);
        valueCol.setWidth(300);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 23;
            }
        });
        return table;
    }

    private TableViewer createTableViewer(Table table) {
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setColumnProperties(COLUMN_NAMES);
        tableViewer.setContentProvider((IContentProvider)new ParameterContentProvider());
        TableViewerColumn nameColViewer = new TableViewerColumn(tableViewer, table.getColumn(0));
        nameColViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Parameter) {
                    Parameter parameter = (Parameter)element;
                    return parameter.isRequired() ? NLS.bind((String)Messages.requiredLabel, (Object)parameter.getName()) : parameter.getName();
                }
                return "";
            }
        });
        if (this.widgetType == WidgetType.DYNAMIC_REGION) {
            nameColViewer.setEditingSupport((EditingSupport)new NameEditingSupport(tableViewer));
        }
        TableViewerColumn valueColViewer = new TableViewerColumn(tableViewer, table.getColumn(1));
        valueColViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Parameter) {
                    Parameter parameter = (Parameter)element;
                    return parameter.getValue();
                }
                return "";
            }
        });
        valueColViewer.setEditingSupport((EditingSupport)new ValueEditingSupport(tableViewer));
        tableViewer.setInput((Object)this.tableModel);
        return tableViewer;
    }

    public static interface IStatusListener {
        public void handleStatus(IStatus var1);
    }

    private final class NameEditingSupport
    extends EditingSupport {
        public NameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            TableViewer tableViewer = (TableViewer)this.getViewer();
            return new TextCellEditor((Composite)tableViewer.getControl()){

                public CellEditor.LayoutData getLayoutData() {
                    CellEditor.LayoutData data = super.getLayoutData();
                    data.minimumHeight = 21;
                    data.verticalAlignment = 1024;
                    return data;
                }
            };
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            Parameter parameter = (Parameter)element;
            return parameter.getName() == null ? "" : parameter.getName();
        }

        protected void setValue(Object element, Object value) {
            ((Parameter)element).setName((String)value);
            this.getViewer().update(element, null);
            ParameterViewer.this.validate();
        }
    }

    private static final class Parameter {
        private String name;
        private String value;
        private boolean required;
        private boolean canChangeName = true;

        public Parameter(String name) {
            this.setName(name);
            this.required = false;
        }

        public Parameter(IWebPageContext.IParameterProxy parameter) {
            this.setName(parameter.getName());
            Object value = parameter.getDefaultValue();
            if (value != null) {
                this.setValue(value.toString());
            }
            this.required = parameter.isRequired();
            this.canChangeName = false;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setName(String name) {
            if (!this.canChangeName) {
                throw new UnsupportedOperationException("Cannot change the name of a task flow parameter");
            }
            this.name = name == null ? name : (name.trim().equals("") ? null : name.trim());
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value == null ? value : (value.trim().equals("") ? null : value.trim());
        }

        public String getValue() {
            return this.value;
        }
    }

    private static final class ParameterContentProvider
    implements IStructuredContentProvider,
    TableModel.ITableModelListener {
        private TableModel tableModel;
        private TableViewer tableViewer;

        private ParameterContentProvider() {
        }

        public void dispose() {
            if (this.tableModel != null) {
                this.tableModel.removeChangeListener(this);
                this.tableModel = null;
            }
            this.tableViewer = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.tableModel = (TableModel)newInput;
            this.tableViewer = (TableViewer)viewer;
            if (newInput != null) {
                ((TableModel)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((TableModel)oldInput).removeChangeListener(this);
            }
        }

        public Object[] getElements(Object inputElement) {
            return ((TableModel)inputElement).getParameters().toArray();
        }

        @Override
        public void addParameter(Parameter parameter) {
            if (this.tableViewer != null) {
                this.tableViewer.add((Object)parameter);
            }
        }

        @Override
        public void deleteParameter(Parameter parameter) {
            if (this.tableViewer != null) {
                this.tableViewer.remove((Object)parameter);
            }
        }
    }

    private static final class TableModel {
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private ListenerList listeners = new ListenerList();
        private boolean hasRequiredParameter;

        private TableModel() {
        }

        public void dispose() {
            if (this.listeners != null) {
                this.listeners.clear();
                this.listeners = null;
            }
            if (this.parameters != null) {
                this.parameters.clear();
                this.parameters = null;
            }
        }

        public boolean hasRequiredParameter() {
            return this.hasRequiredParameter;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void addParameter(Parameter parameter) {
            this.hasRequiredParameter = this.hasRequiredParameter || parameter.isRequired();
            this.parameters.add(parameter);
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((ITableModelListener)listener).addParameter(parameter);
                ++n2;
            }
        }

        public void deleteParameter(Parameter parameter) {
            this.parameters.remove(parameter);
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((ITableModelListener)listener).deleteParameter(parameter);
                ++n2;
            }
        }

        public void addChangeListener(ITableModelListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeChangeListener(ITableModelListener listener) {
            this.listeners.remove((Object)listener);
        }

        public static interface ITableModelListener {
            public void addParameter(Parameter var1);

            public void deleteParameter(Parameter var1);
        }
    }

    private final class ValueEditingSupport
    extends EditingSupport {
        private final IObservableValue parameterModel;

        public ValueEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.parameterModel = new WritableValue(null, String.class);
        }

        private IObservableValue getInitializedModel(Object element) {
            this.parameterModel.setValue(this.getValue(element));
            return this.parameterModel;
        }

        protected CellEditor getCellEditor(Object element) {
            TableViewer tableViewer = (TableViewer)this.getViewer();
            return new TextDialogCellEditor((Composite)tableViewer.getControl(), (DialogCreationStrategy)ParameterViewer.this.elBindStrategy, this.getInitializedModel(element));
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            Parameter parameter = (Parameter)element;
            return parameter.getValue() == null ? "" : parameter.getValue();
        }

        protected void setValue(Object element, Object value) {
            ((Parameter)element).setValue((String)value);
            this.getViewer().update(element, null);
            ParameterViewer.this.validate();
        }
    }
}

