/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.adf.controller.internal.dtrt.binding.DTTaskFlowBinding;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.IBindCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.command.IUIProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.CreatableType;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.CreateCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.BindCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.TaskFlowWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui.DynamicRegionWizard;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui.RegionParameterDialog;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.ITaskFlowOptionsProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public final class WidgetType
extends Enum<WidgetType> {
    public static final /* enum */ WidgetType REGION = new WidgetType();
    public static final /* enum */ WidgetType REGION_WITH_PARAMETERS = new WidgetType();
    public static final /* enum */ WidgetType DYNAMIC_REGION = new WidgetType();
    public static final /* enum */ WidgetType TASK_FLOW_CALL_BUTTON = new WidgetType();
    public static final /* enum */ WidgetType TASK_FLOW_CALL_LINK = new WidgetType();
    public static final /* enum */ WidgetType DYNAMIC_REGION_LINK = new WidgetType();
    public static final String MANAGED_BEAN_KEY = "dtrt.taskFlowWidget.ManagedBean";
    public static final String MANAGED_BEAN_CREATED_KEY = "dtrt.taskFlowWidget.ManagedBeanCreated";
    private static final String PARAMETER_MAP_EL_KEY = "dtrt.taskFlowWidget.ParameterMapEL";
    private static final String INPUT_PARAMETERS_KEY = "INPUT_PARAMETERS_KEY";
    public static final String TASK_FLOW_NAME_KEY = "dtrt.taskFlowWidget.TaskFlowName";
    public static final String BIND_NAME_KEY = "dtrt.taskFlowWidget.BindName";
    public static final String LINK_NAME_KEY = "dtrt.taskFlowWidget.LinkName";
    public static final String DEFAULT_BIND_NAME = "dynamicTaskFlowId";
    private static final /* synthetic */ WidgetType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new WidgetType[]{REGION, REGION_WITH_PARAMETERS, DYNAMIC_REGION, TASK_FLOW_CALL_BUTTON, TASK_FLOW_CALL_LINK, DYNAMIC_REGION_LINK};
    }

    private static String getDefaultTaskFlowName(IWebPageContext.ITaskFlowProxy taskFlow) {
        return String.valueOf(TaskFlowWidget.getWebProjectRelativePath((IResource)taskFlow.getTaskFlowFile())) + '#' + taskFlow.getTaskFlowId();
    }

    public String toString() {
        switch (this) {
            case REGION: {
                return Messages.labelRegion;
            }
            case REGION_WITH_PARAMETERS: {
                return Messages.labelRegionWithParameters;
            }
            case DYNAMIC_REGION: {
                return Messages.labelDynamicRegion;
            }
            case TASK_FLOW_CALL_BUTTON: {
                return Messages.labelTaskFlowCallButton;
            }
            case TASK_FLOW_CALL_LINK: {
                return Messages.labelTaskFlowCallLink;
            }
            case DYNAMIC_REGION_LINK: {
                return Messages.labelDynamicRegionLink;
            }
        }
        return super.toString();
    }

    DocumentFragment createDocumentFragment(IWebPageContext context, Document document, IWebPageContext.ITaskFlowProxy taskFlow, IBindingObject bindingObject, Map<String, Object> executionParameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        switch (this) {
            case REGION: 
            case REGION_WITH_PARAMETERS: 
            case DYNAMIC_REGION: {
                sb.append("<af:region").append(" value=\"").append("#{bindings.").append(bindingObject.getId()).append(".regionModel}").append('\"').append("/>");
                break;
            }
            case TASK_FLOW_CALL_BUTTON: {
                sb.append("<af:goButton").append(" text=\"").append(taskFlow.getTaskFlowId()).append('\"').append(" destination=\"adf.task-flow?").append("_id=").append(taskFlow.getTaskFlowId()).append("&amp;_document=").append(TaskFlowWidget.getWebProjectRelativePath((IResource)taskFlow.getTaskFlowFile())).append('\"').append("/>");
                break;
            }
            case TASK_FLOW_CALL_LINK: {
                sb.append("<af:goLink").append(" text=\"").append(taskFlow.getTaskFlowId()).append('\"').append(" destination=\"adf.task-flow?").append("_id=").append(taskFlow.getTaskFlowId()).append("&amp;_document=").append(TaskFlowWidget.getWebProjectRelativePath((IResource)taskFlow.getTaskFlowFile())).append('\"').append("/>");
                break;
            }
            case DYNAMIC_REGION_LINK: {
                IWebPageContext.IManagedBean managedBean = this.getManagedBean(context, bindingObject, null);
                if (managedBean == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.unableToLocateManagedBeanForBindingObject, (Object)DTRTUtil.getLabel((IDescribable)bindingObject), (Object)bindingObject));
                }
                if (!context.getManagedBeanManager().isBoundToTaskFlow(managedBean)) {
                    throw new IllegalStateException(NLS.bind((String)Messages.mustBeUsedManagedBean, (Object)DTRTUtil.getLabel((IDescribable)bindingObject), (Object)bindingObject));
                }
                executionParameters.put(MANAGED_BEAN_KEY, managedBean);
                executionParameters.put(TASK_FLOW_NAME_KEY, WidgetType.getDefaultTaskFlowName(taskFlow));
                String linkName = this.getValidLinkName(context.getManagedBeanManager(), managedBean, JavaUtil.toJavaIdentifier((String)taskFlow.getTaskFlowId()), (String)executionParameters.get(TASK_FLOW_NAME_KEY));
                executionParameters.put(LINK_NAME_KEY, linkName);
                sb.append("<af:commandLink").append(" text=\"").append(taskFlow.getTaskFlowId()).append('\"').append(" action=\"").append(this.computeEL(managedBean, linkName, true)).append('\"').append("/>");
            }
        }
        return DTRTvCommonUtil.createDocumentFragment((Document)document, Collections.singletonMap("af", "http://xmlns.oracle.com/adf/faces/rich"), (String)sb.toString());
    }

    private String getValidLinkName(IWebPageContext.IManagedBeanManager managedBeanManager, IWebPageContext.IManagedBean managedBean, String linkName, String taskFlowName) throws Exception {
        String name = linkName;
        int i = 1;
        while (!managedBeanManager.isValidLinkName(managedBean, name, taskFlowName)) {
            name = String.valueOf(linkName) + i++;
        }
        return name;
    }

    private String getValidBindName(IWebPageContext.IManagedBeanManager managedBeanManager, IWebPageContext.IManagedBean managedBean, String bindName) throws Exception {
        String name = bindName;
        int i = 1;
        while (!managedBeanManager.isValidTaskFlowBindName(managedBean, name)) {
            name = String.valueOf(bindName) + i++;
        }
        return name;
    }

    private IWebPageContext.IManagedBean getManagedBean(IWebPageContext context, IBindingObject bindingObject, IProgressMonitor monitor) throws Exception {
        String[] parsed = TaskFlowWidget.parseTaskFlowIdEL(OEPEContextImpl.getTranslator((IOEPEContext)context), bindingObject);
        if (parsed != null) {
            List<? extends IWebPageContext.IManagedBean> managedBeans = TaskFlowWidget.collectManagedBeans(context, monitor);
            for (IWebPageContext.IManagedBean iManagedBean : managedBeans) {
                if (!DTRTUtil.equals((Object)DTRTUtil.getLabel((IDescribable)iManagedBean), (Object)parsed[1]) || !this.beanScopeMatches(iManagedBean.getScope(), parsed[0])) continue;
                return iManagedBean;
            }
        }
        return null;
    }

    private boolean beanScopeMatches(Variable.SCOPE beanScope, String scopeStr) {
        return beanScope != null ? DTRTUtil.equals((Object)beanScope.getScopeStr(), (Object)scopeStr) : scopeStr == null;
    }

    IBindingObject createBindingObject(IWebPageContext context, IWebPageContext.ITaskFlowProxy taskFlow, Map<String, Object> executionParameters) throws Exception {
        switch (this) {
            case REGION: 
            case REGION_WITH_PARAMETERS: {
                return this.createTaskFlowBindingObject(context, taskFlow, executionParameters, JavaUtil.toJavaIdentifier((String)taskFlow.getTaskFlowId(), (char)'_'), WidgetType.getDefaultTaskFlowName(taskFlow));
            }
            case DYNAMIC_REGION: {
                IWebPageContext.IManagedBean managedBean = (IWebPageContext.IManagedBean)executionParameters.get(MANAGED_BEAN_KEY);
                assert (managedBean != null);
                executionParameters.put(TASK_FLOW_NAME_KEY, WidgetType.getDefaultTaskFlowName(taskFlow));
                executionParameters.put(BIND_NAME_KEY, DEFAULT_BIND_NAME);
                assert (!executionParameters.containsKey(LINK_NAME_KEY));
                return this.createTaskFlowBindingObject(context, taskFlow, executionParameters, "dynamicRegion", this.computeEL(managedBean, this.getValidBindName(context.getManagedBeanManager(), managedBean, DEFAULT_BIND_NAME), false));
            }
        }
        return null;
    }

    private String computeEL(IWebPageContext.IManagedBean managedBean, String suffix, boolean deferred) {
        StringBuilder el = null;
        el = deferred ? new StringBuilder(managedBean.getEL().replace("${", "#{")) : new StringBuilder(managedBean.getEL());
        if (el.charAt(el.length() - 1) == '}') {
            return el.deleteCharAt(el.length() - 1).append('.').append(suffix).append('}').toString();
        }
        return null;
    }

    private IBindingObject createTaskFlowBindingObject(IWebPageContext context, IWebPageContext.ITaskFlowProxy taskFlow, Map<String, Object> executionParameters, String idBaseName, String bindingTaskFlowId) throws Exception {
        List parameterPairs;
        IObjectTranslator translator = OEPEContextImpl.getTranslator((IOEPEContext)context);
        PageDefinition pageDefinition = (PageDefinition)translator.toADFObject((IObject)context.getPageDefinition());
        if (pageDefinition == null) {
            CreateCommand createPageDefinitionCommand = new CreateCommand((IOEPEExecutableContext)context);
            createPageDefinitionCommand.setType(CreatableType.TYPE_PageDefinition);
            createPageDefinitionCommand.execute(null);
            pageDefinition = (PageDefinition)translator.toADFObject((IObject)context.getPageDefinition());
            if (pageDefinition == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.unableToCreatePageDefinitionFor, (Object)context.getWebPageFile()));
            }
        }
        CreateCommand createBindingCommand = new CreateCommand((IOEPEExecutableContext)context);
        createBindingCommand.setType(CreatableType.TYPE_TaskFlowBinding);
        createBindingCommand.setParent((IObject)context.getPageDefinition());
        createBindingCommand.setObjectId(DTRTvCommonUtil.computeUniqueValue((Document)pageDefinition.getDocument(), (String)"id", (String)idBaseName));
        createBindingCommand.execute(null);
        IBindingObject bindingObject = (IBindingObject)createBindingCommand.getAffectedObjects().get(0);
        DTTaskFlowBinding binding = (DTTaskFlowBinding)translator.toADFObject((IObject)bindingObject);
        binding.setTaskFlowId(bindingTaskFlowId);
        binding.setActivation("deferred");
        String parameterMap = (String)executionParameters.get(PARAMETER_MAP_EL_KEY);
        if (parameterMap != null) {
            binding.setParametersMap(parameterMap);
        }
        if ((parameterPairs = (List)executionParameters.get(INPUT_PARAMETERS_KEY)) != null && !parameterPairs.isEmpty()) {
            for (Pair pair : parameterPairs) {
                binding.addParameter((String)pair.getFirst(), (String)pair.getSecond());
            }
        }
        return bindingObject;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IStatus collectUserInput(BindCommand command, TaskFlowWidget widget, Map<String, Object> executionParameters) throws Exception {
        switch (this) {
            case REGION_WITH_PARAMETERS: {
                IWebPageContext.ITaskFlowProxy taskFlow = widget.forObject();
                Shell shell = this.shouldShowUI(command, taskFlow, executionParameters);
                if (shell == null) return Status.OK_STATUS;
                RegionParameterDialog dialog = null;
                try {
                    dialog = new RegionParameterDialog(shell, command, widget);
                    if (dialog.open() != 0) {
                        dialog.dispose();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        if (dialog == null) return iStatus;
                        dialog.dispose();
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    if (dialog == null) throw throwable;
                    dialog.dispose();
                    throw throwable;
                }
                {
                    executionParameters.put(PARAMETER_MAP_EL_KEY, dialog.getParameterMapEL());
                    executionParameters.put(INPUT_PARAMETERS_KEY, dialog.getParameterPairs());
                }
                if (dialog == null) return Status.OK_STATUS;
                dialog.dispose();
                return Status.OK_STATUS;
            }
            case DYNAMIC_REGION: {
                IWebPageContext.ITaskFlowProxy taskFlow = widget.forObject();
                Shell shell = this.shouldShowUI(command, taskFlow, executionParameters);
                if (shell == null) return Status.OK_STATUS;
                DynamicRegionWizard wizard = new DynamicRegionWizard(command, widget);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                if (dialog.open() != 0) {
                    return Status.CANCEL_STATUS;
                }
                IWebPageContext.IManagedBean managedBean = wizard.getManagedBean();
                assert (managedBean != null);
                executionParameters.put(MANAGED_BEAN_KEY, managedBean);
                executionParameters.put(PARAMETER_MAP_EL_KEY, wizard.getParameterMapEL());
                executionParameters.put(INPUT_PARAMETERS_KEY, wizard.getParameterPairs());
                executionParameters.put(MANAGED_BEAN_CREATED_KEY, wizard.isNewManagedBean());
                return Status.OK_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    private Shell shouldShowUI(IBindCommand command, IWebPageContext.ITaskFlowProxy taskFlow, Map<String, Object> executionParameters) {
        Shell shell;
        IBindCommand.IBindCommandParticipant participant = command.getParticipant();
        Shell shell2 = shell = participant instanceof IUIProvider ? ((IUIProvider)participant).getShell() : null;
        if (shell != null && !shell.isDisposed()) {
            return shell;
        }
        this.collectUserInput(command, taskFlow, executionParameters);
        if (this == DYNAMIC_REGION && !executionParameters.containsKey(MANAGED_BEAN_KEY)) {
            throw new IllegalStateException("A shell provider is needed in order to collect the information about the managed bean.");
        }
        return null;
    }

    private void collectUserInput(IBindCommand command, IWebPageContext.ITaskFlowProxy taskFlow, Map<String, Object> executionParameters) {
        IBindCommand.IBindCommandParticipant participant = command.getParticipant();
        ITaskFlowOptionsProvider provider = participant instanceof ITaskFlowOptionsProvider ? (ITaskFlowOptionsProvider)participant : null;
        List parameters = taskFlow.getParameters();
        if (!parameters.isEmpty()) {
            ArrayList<Pair> parameterPairs = new ArrayList<Pair>(parameters.size());
            Map parameterValueMap = provider != null ? provider.getParameterValueMap() : null;
            for (IWebPageContext.IParameterProxy parameter : parameters) {
                Object value = this.getValue(parameterValueMap, parameter);
                if (value == null) {
                    if (!parameter.isRequired()) continue;
                    throw new IllegalStateException("A shell provider is needed in order to collect the information about the required parameters.");
                }
                parameterPairs.add(new Pair((Object)parameter.getName(), (Object)value.toString()));
            }
            if (!parameterPairs.isEmpty()) {
                executionParameters.put(INPUT_PARAMETERS_KEY, parameterPairs);
            }
        }
        if (provider != null) {
            String parameterMapEL;
            IWebPageContext.IManagedBean managedBean = provider.getManagedBean();
            if (managedBean != null) {
                executionParameters.put(MANAGED_BEAN_KEY, managedBean);
                executionParameters.put(MANAGED_BEAN_CREATED_KEY, provider.isManagedBeanCreated());
            }
            if ((parameterMapEL = provider.getParameterMapEL()) != null) {
                executionParameters.put(PARAMETER_MAP_EL_KEY, parameterMapEL);
            }
        }
    }

    private Object getValue(Map<String, ?> parameterValueMap, IWebPageContext.IParameterProxy parameter) {
        Object value = null;
        if (parameterValueMap != null) {
            for (Map.Entry<String, ?> entry : parameterValueMap.entrySet()) {
                if (!DTRTUtil.equals((Object)parameter.getName(), (Object)entry.getKey())) continue;
                value = entry.getValue();
                break;
            }
        }
        if (value == null) {
            value = parameter.getDefaultValue();
        }
        return value;
    }

    public static WidgetType[] values() {
        WidgetType[] widgetTypeArray = ENUM$VALUES;
        int n = widgetTypeArray.length;
        WidgetType[] widgetTypeArray2 = new WidgetType[n];
        System.arraycopy(ENUM$VALUES, 0, widgetTypeArray2, 0, n);
        return widgetTypeArray2;
    }

    public static WidgetType valueOf(String string) {
        return Enum.valueOf(WidgetType.class, string);
    }

    private static class Messages
    extends NLS {
        public static String labelRegion;
        public static String labelRegionWithParameters;
        public static String labelDynamicRegion;
        public static String labelTaskFlowCallButton;
        public static String labelTaskFlowCallLink;
        public static String labelDynamicRegionLink;
        public static String unableToLocateManagedBeanForBindingObject;
        public static String mustBeUsedManagedBean;
        public static String unableToCreatePageDefinitionFor;

        static {
            NLS.initializeMessages((String)WidgetType.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

