/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.adf.model.adapter.dataformat.MethodReturnDef;
import oracle.adfdt.model.binding.AdfModelConfigurationException;
import oracle.adfdt.model.objects.AccessorIterator;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.CtrlList;
import oracle.adfdt.model.objects.CtrlMethodAction;
import oracle.adfdt.model.objects.MethodIteratorBinding;
import oracle.adfdt.model.util.JSR227Util;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AccessorParameterDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.OperationReturnDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructuredTypeObject;
import oracle.eclipse.tools.adf.dtrt.object.IVariableObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ActionOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.DataControl;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ExecutableFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IAccessorIterator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlAction;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlHier;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlList;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlValue;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IDataControlStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IMethodIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IVariable;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IVariablesIterator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IteratorBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.NamedData;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.util.DtrtSwitch;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.meta.IDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.meta.INamedDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ADFTypeResolver;
import org.eclipse.emf.common.util.EList;

public final class ObjectImplUtil {
    private ObjectImplUtil() {
    }

    public static void createDataControlStructureObjects(List<IDataControlChild> children, IDataControlObject parent, DefinitionContainer definitionContainer) {
        if (definitionContainer != null && !definitionContainer.isEmpty()) {
            for (NamedDefinition namedDefinition : definitionContainer) {
                children.add(ObjectImplUtil.createDataControlStructureObjectForDefinition(parent, namedDefinition));
            }
        }
    }

    public static IDataControlStructureObject createDataControlStructureObjectForDefinition(IDataControlObject parent, NamedDefinition namedDefinition) {
        IDataControlStructureObject dataControlChild = ExecutableFactory.eINSTANCE.createIDataControlStructureObject();
        dataControlChild.setParent((IObject)parent);
        dataControlChild.setDecoratedObject(namedDefinition);
        return dataControlChild;
    }

    public static IStructuredTypeObject getStructureTypeObjectForVariable(ICtrlValue ctrlAttrs) {
        IteratorBinding currentBinding = ctrlAttrs.getIteratorBinding();
        if (currentBinding instanceof IVariablesIterator) {
            String firstAttribute = ctrlAttrs.getFirstAttribute();
            IObject parent = ((IVariablesIterator)currentBinding).getParent();
            if (parent instanceof PageDefinition && firstAttribute != null) {
                return ((PageDefinition)parent).findVariable(firstAttribute);
            }
        }
        return null;
    }

    public static IStructuredTypeObject getDataControlObjectForFirstAttribute(ICtrlValue ctrlAttrs) {
        IDataControlObject dataControlObject;
        IteratorBinding currentBinding = ctrlAttrs.getIteratorBinding();
        if (currentBinding instanceof IVariablesIterator) {
            return ObjectImplUtil.getStructureTypeObjectForVariable(ctrlAttrs);
        }
        IDefinition firstAttributeDefinition = ctrlAttrs.getFirstAttributeDefinition();
        if (firstAttributeDefinition instanceof INamedDefinition && currentBinding != null && (dataControlObject = currentBinding.getDataControlObject()) != null) {
            return ObjectImplUtil.findChild(dataControlObject, ((INamedDefinition)firstAttributeDefinition).getFullName());
        }
        return null;
    }

    public static IStructuredTypeObject getDataControlObjectForTargetAttribute(ICtrlList iCtrlList) {
        CtrlList realControlList = (CtrlList)iCtrlList.getDecoratedObject();
        oracle.adfdt.model.objects.IteratorBinding realIteratorBinding = realControlList.getIteratorBinding();
        if (realIteratorBinding != null) {
            IteratorBinding iIteratorBinding = iCtrlList.getIteratorBinding();
            if (iIteratorBinding instanceof IVariablesIterator) {
                String varName = iCtrlList.getFirstAttribute();
                if (varName != null && !varName.trim().isEmpty()) {
                    IStructuredTypeObject structuredTypeObject = ((IVariablesIterator)iIteratorBinding).getStructuredTypeObject();
                    for (IStructuredTypeObject child : structuredTypeObject.getChildren()) {
                        if (!varName.equals(child.getId())) continue;
                        return child;
                    }
                }
                return null;
            }
            NamedDefinition namedDefinition = realIteratorBinding.getNamedDefinition();
            if (namedDefinition != null) {
                switch (namedDefinition.getDefinitionType()) {
                    case 50: {
                        return ObjectImplUtil.getDataControlObjectForFirstAttribute(iCtrlList);
                    }
                    case 30: {
                        IDataControlObject attrControlObj = iCtrlList.getDataControlObject();
                        String name = namedDefinition.getName();
                        return ObjectImplUtil.findChild(attrControlObj, name);
                    }
                    case 40: {
                        AccessorDefinition accessorDef = (AccessorDefinition)namedDefinition;
                        if (accessorDef.getJavaTypeString() != null) {
                            if (!accessorDef.isCollection()) break;
                            return ObjectImplUtil.findChild(iCtrlList.getIteratorBinding().getDataControlObject(), iCtrlList.getFirstAttribute());
                        }
                        IteratorBinding iteratorBinding = iCtrlList.getIteratorBinding();
                        if (iteratorBinding == null) break;
                        return iteratorBinding.getDataControlObject();
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported Type: " + namedDefinition.getDefinitionType());
                    }
                }
            }
        }
        return null;
    }

    public static IDataControlObject getDataControlObjectForListSourceAttribute(ICtrlList iCtrlList) {
        IteratorBinding listIteratorBinding = iCtrlList.getListIteratorBinding();
        if (listIteratorBinding == null) {
            return null;
        }
        oracle.adfdt.model.objects.IteratorBinding realIteratorBinding = (oracle.adfdt.model.objects.IteratorBinding)listIteratorBinding.getDecoratedObject();
        if (realIteratorBinding != null) {
            NamedDefinition namedDefinition = null;
            try {
                namedDefinition = realIteratorBinding.getNamedDefinition();
            }
            catch (AdfModelConfigurationException adfModelConfigurationException) {
                namedDefinition = null;
            }
            if (namedDefinition != null) {
                switch (namedDefinition.getDefinitionType()) {
                    case 30: 
                    case 50: {
                        return null;
                    }
                    case 40: {
                        AccessorDefinition accessorDef = (AccessorDefinition)namedDefinition;
                        if (ADFTypeResolver.INSTANCE.isSimpleCollection((Definition)accessorDef)) {
                            return ObjectImplUtil.findChild(iCtrlList.getListIteratorBinding().getDataControlObject(), String.valueOf(accessorDef.getName()) + ".element");
                        }
                        IteratorBinding iteratorBinding = iCtrlList.getListIteratorBinding();
                        if (iteratorBinding == null) break;
                        return iteratorBinding.getDataControlObject();
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported Type: " + namedDefinition.getDefinitionType());
                    }
                }
            }
        }
        return null;
    }

    public static IDataControlObject getDataControlObjectForTreeTargetAttribute(ICtrlHier iCtrlHier) {
        IteratorBinding treeIteratorBinding;
        if (iCtrlHier != null && (treeIteratorBinding = iCtrlHier.getIteratorBinding()) != null) {
            oracle.adfdt.model.objects.IteratorBinding realIteratorBinding = (oracle.adfdt.model.objects.IteratorBinding)treeIteratorBinding.getDecoratedObject();
            if (realIteratorBinding instanceof MethodIteratorBinding) {
                return treeIteratorBinding.getDataControlObject();
            }
            if (realIteratorBinding instanceof AccessorIterator) {
                return treeIteratorBinding.getDataControlObject();
            }
        }
        return null;
    }

    public static IDataControlObject getDataControlObjectForMethodIteratorBinding(IMethodIteratorBinding methodIterator) {
        IDataControlObject parentIterator;
        Object decoratedObject = methodIterator.getDecoratedObject();
        if (decoratedObject instanceof MethodIteratorBinding && (parentIterator = ObjectImplUtil.getParentIterator(methodIterator)) != null) {
            IDataControlChild parent;
            Definition definitionParent2;
            Definition definitionParent;
            StructureDefinition definition = ((MethodIteratorBinding)decoratedObject).getDefinition();
            if (definition != null && (definitionParent = definition.getDefinitionParent()) instanceof MethodReturnDef && (definitionParent2 = ((MethodReturnDef)definitionParent).getDefinitionParent()) instanceof OperationDefinition && (parent = ObjectImplUtil.findChild(parentIterator, ((NamedDefinition)definitionParent).getFullName())) != null) {
                return ObjectImplUtil.createDataControlStructureObjectForDefinition((IDataControlObject)parent, (NamedDefinition)definitionParent);
            }
            IStructureObject structureObject = parentIterator.getStructureObject();
            if (StructureObjectType.getStructureObjectType(structureObject) == StructureObjectType.CONSTRUCTOR) {
                return parentIterator;
            }
        }
        return null;
    }

    private static IDataControlObject getParentIterator(IMethodIteratorBinding methodIterator) {
        ICtrlAction methodAction = methodIterator.getMethodAction();
        if (methodAction == null) {
            return null;
        }
        return methodAction.getDataControlObject();
    }

    public static IDataControlObject getDataControlObjectForActionTarget(ICtrlAction iCtrlAction) {
        ActionOptions actionOption = iCtrlAction.getActionOptions();
        if (actionOption == null) {
            return null;
        }
        IteratorBinding actionIterator = iCtrlAction.getIteratorBinding();
        if (actionIterator == null) {
            DataControl dataControl = iCtrlAction.getDataControl();
            String instanceName = iCtrlAction.getActionBindingInstanceName();
            String methodName = iCtrlAction.getMethodName();
            if (dataControl != null && methodName != null) {
                Object decoratedObject = iCtrlAction.getDecoratedObject();
                if (instanceName == null && decoratedObject instanceof CtrlMethodAction && ((CtrlMethodAction)decoratedObject).isConstructorAction()) {
                    oracle.adfdt.model.objects.DataControl rawDc = dataControl.getDecoratedObject();
                    DataControlDefinition dataControlDefinition = rawDc.getDataControlDefinition();
                    instanceName = String.valueOf(dataControlDefinition.getName()) + ".dataProvider";
                }
                String fullName = String.valueOf(instanceName) + "." + methodName;
                return ObjectImplUtil.findDataControlChild(dataControl, fullName);
            }
        } else {
            NamedDefinition namedDefinition;
            oracle.adfdt.model.objects.IteratorBinding realIteratorBinding = (oracle.adfdt.model.objects.IteratorBinding)actionIterator.getDecoratedObject();
            if (realIteratorBinding != null && (namedDefinition = ObjectImplUtil.getNamedDefinition(realIteratorBinding)) != null) {
                switch (namedDefinition.getDefinitionType()) {
                    case 30: {
                        return null;
                    }
                    case 40: 
                    case 50: {
                        IDataControlObject findChild = ObjectImplUtil.findOperation(actionOption, iCtrlAction, actionIterator);
                        return findChild;
                    }
                }
                throw new UnsupportedOperationException("Unsupported Type: " + namedDefinition.getDefinitionType());
            }
        }
        return null;
    }

    private static IDataControlObject getMasterIteratorDataControlObject(IAccessorIterator iAccessorIterator) {
        IteratorBinding masterIterator = iAccessorIterator.getMasterIterator();
        return masterIterator != null ? masterIterator.getDataControlObject() : null;
    }

    public static IDataControlObject getDataControlObjectForAccessorIterator(IAccessorIterator iAccessorIterator) {
        IDataControlObject dataControlObject;
        Definition definitionParent;
        AccessorDefinition accessorDefinition = null;
        AccessorIterator accessorIterator = (AccessorIterator)iAccessorIterator.getDecoratedObject();
        StructureDefinition definition = accessorIterator.getDefinition();
        if (definition != null && (definitionParent = definition.getDefinitionParent()) instanceof AccessorDefinition) {
            accessorDefinition = (AccessorDefinition)definitionParent;
        }
        if (accessorDefinition == null) {
            try {
                definition = accessorIterator.getNamedDefinition();
                if (definition instanceof AccessorDefinition) {
                    accessorDefinition = (AccessorDefinition)definition;
                }
            }
            catch (AdfModelConfigurationException amce) {
                DTRTvBundle.log(amce);
            }
        }
        if (accessorDefinition != null && (dataControlObject = ObjectImplUtil.getMasterIteratorDataControlObject(iAccessorIterator)) != null) {
            return ObjectImplUtil.findChild(dataControlObject, accessorDefinition.getFullName());
        }
        return null;
    }

    public static boolean isValidIteratorParentForAccessorOnChild(IDataControlObject candidateParent, IDataControlObject child) {
        IDataControlObject parent = child.getParent();
        return ObjectImplUtil.arePathsAndTypesSame(parent, candidateParent);
    }

    private static NamedDefinition getNamedDefinition(oracle.adfdt.model.objects.IteratorBinding realIteratorBinding) {
        try {
            return realIteratorBinding.getNamedDefinition();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static NamedDefinition getNamedDefinition(IStructuredTypeObject dataControlObject) {
        Object decoratedObject;
        if (dataControlObject instanceof IDataControlStructureObject && (decoratedObject = ((IDataControlStructureObject)dataControlObject).getDecoratedObject()) instanceof NamedDefinition) {
            return (NamedDefinition)decoratedObject;
        }
        return null;
    }

    private static IDataControlObject findOperation(ActionOptions actionOption, ICtrlAction action, IDataControlObject parent, OperationDefinition findOp, int depth) {
        for (IDataControlChild child : parent.getChildren()) {
            IDataControlObject object;
            if (child instanceof IDataControlStructureObject) {
                Object decoratedObject = ((IDataControlStructureObject)child).getDecoratedObject();
                if (!(decoratedObject instanceof OperationDefinition)) continue;
                OperationDefinition operation = (OperationDefinition)decoratedObject;
                if (!(actionOption.getValue() == 999 ? (action != null ? ObjectImplUtil.doesOperationMatchAction(operation, action) : findOp != null && ObjectImplUtil.doOperationsMatch((OperationDefinition)decoratedObject, findOp)) : actionOption.getValue() == operation.getOperationId())) continue;
                return child;
            }
            if (depth >= 10 || (object = ObjectImplUtil.findOperation(actionOption, action, (IDataControlObject)child, findOp, depth + 1)) == null) continue;
            return object;
        }
        return null;
    }

    private static boolean doesOperationMatchAction(OperationDefinition operation, ICtrlAction action) {
        if (operation.getName().equals(action.getMethodName())) {
            EList<NamedData> actionParams = action.getParameters();
            Iterator it = operation.getOperationParameters().iterator();
            ArrayList<ParameterDefinition> paramDefs = new ArrayList<ParameterDefinition>();
            while (it.hasNext()) {
                paramDefs.add((ParameterDefinition)it.next());
            }
            if (actionParams.size() == paramDefs.size()) {
                int i = 0;
                while (i < actionParams.size()) {
                    ParameterDefinition paramDef;
                    NamedData nd = (NamedData)actionParams.get(i);
                    if (!ObjectImplUtil.equals(nd, paramDef = (ParameterDefinition)paramDefs.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean equals(NamedData nd, ParameterDefinition paramDef) {
        String typeName;
        if (nd != null && paramDef != null && (typeName = nd.getTypeName()) != null) {
            return typeName.equals(paramDef.getJavaTypeString());
        }
        return false;
    }

    private static boolean doOperationsMatch(OperationDefinition first, OperationDefinition second) {
        if (first.getName().equals(second.getName())) {
            DefinitionContainer firstParams = first.getOperationParameters();
            DefinitionContainer secondParams = second.getOperationParameters();
            ArrayList<AccessorParameterDefinition> copyFirstParams = new ArrayList<AccessorParameterDefinition>(4);
            for (AccessorParameterDefinition paramDef : firstParams) {
                copyFirstParams.add(paramDef);
            }
            Iterator secondParamIt = secondParams.iterator();
            ArrayList<AccessorParameterDefinition> copySecondParams = new ArrayList<AccessorParameterDefinition>();
            while (secondParamIt.hasNext()) {
                AccessorParameterDefinition paramDef = (AccessorParameterDefinition)secondParamIt.next();
                copySecondParams.add(paramDef);
            }
            if (copyFirstParams.size() == copySecondParams.size()) {
                int i = 0;
                while (i < copyFirstParams.size()) {
                    AccessorParameterDefinition param1 = (AccessorParameterDefinition)copyFirstParams.get(i);
                    AccessorParameterDefinition param2 = (AccessorParameterDefinition)copySecondParams.get(i);
                    String javaTypeString1 = param1.getJavaTypeString();
                    String javaTypeString2 = param2.getJavaTypeString();
                    if (javaTypeString1 != null && !javaTypeString1.equals(javaTypeString2)) {
                        return false;
                    }
                    ++i;
                }
            }
            OperationReturnDefinition firstReturnType = first.getOperationReturnType();
            OperationReturnDefinition secondReturnType = second.getOperationReturnType();
            if (firstReturnType == null && secondReturnType == null) {
                return true;
            }
            if (firstReturnType != null) {
                String javaTypeString1 = firstReturnType.getJavaTypeString();
                String javaTypeString2 = secondReturnType.getJavaTypeString();
                if (javaTypeString1 != null && !javaTypeString1.equals(javaTypeString2)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static IDataControlObject findOperation(ActionOptions actionOption, ICtrlAction action, IteratorBinding actionIterator) {
        IDataControlObject dataControlObject = actionIterator.getDataControlObject();
        if (dataControlObject != null) {
            return ObjectImplUtil.findOperation(actionOption, action, dataControlObject, null, 0);
        }
        return null;
    }

    public static IDataControlObject findDataControlChild(IDataControl dataControl, String fullName) {
        String fixedFullName = ObjectImplUtil.fixFullName(fullName);
        if (fullName != null && !fullName.equals(fixedFullName) && fixedFullName.equals(dataControl.getId())) {
            return dataControl;
        }
        return dataControl != null && fixedFullName != null ? ObjectImplUtil.findDataControlChild(new HashSet<String>(), fixedFullName, dataControl.getChildren()) : null;
    }

    private static String fixFullName(String fullName) {
        int index;
        if (fullName != null && fullName.length() > ".root".length() && (index = fullName.indexOf(".root")) > -1 && (index = (fullName = fullName.substring(0, index)).indexOf(".dataProvider")) > -1) {
            fullName = fullName.substring(0, index);
        }
        return fullName;
    }

    public static IDataControlChild findChild(IDataControlObject dataControlObject, String fullName) {
        return dataControlObject != null && fullName != null ? ObjectImplUtil.findDataControlChild(new HashSet<String>(), fullName, dataControlObject.getChildren()) : null;
    }

    public static boolean needsIterator(IStructuredTypeObject sto) {
        if (sto instanceof IDataControlStructureObject) {
            Object decoratedObject = ((IDataControlStructureObject)sto).getDecoratedObject();
            Boolean doSwitch = (Boolean)new DtrtSwitch<Boolean>(){

                @Override
                protected Boolean doSwitch(OperationDefinition obj) {
                    return JSR227Util.operationRequiresIterator((OperationDefinition)obj);
                }

                @Override
                protected Boolean doSwitch(NamedDefinition def) {
                    return Boolean.TRUE;
                }

                @Override
                protected Boolean defaultCase(Object obj) {
                    return true;
                }
            }.doSwitch(decoratedObject);
            return doSwitch != null && doSwitch != false;
        }
        if (sto instanceof IDataControl) {
            return false;
        }
        return sto instanceof IVariable;
    }

    public static int getDefinition(IStructuredTypeObject structuredTypeObject) {
        if (structuredTypeObject instanceof IDataControlStructureObject) {
            Object decoratedObject = ((IDataControlStructureObject)structuredTypeObject).getDecoratedObject();
            if (decoratedObject instanceof NamedDefinition) {
                return ((NamedDefinition)decoratedObject).getDefinitionType();
            }
            if (decoratedObject instanceof IDataControl) {
                return 50;
            }
        } else if (structuredTypeObject instanceof IVariableObject) {
            return 80;
        }
        return -1;
    }

    public static boolean isValidChild(IDataControlObject parent, IDataControlObject child) {
        Object decoratedObject = ((IDataControlStructureObject)child).getDecoratedObject();
        if (decoratedObject instanceof NamedDefinition && ((NamedDefinition)decoratedObject).getDefinitionType() == 30) {
            IDataControlObject curParent = child.getParent();
            if (curParent == null) {
                return false;
            }
            if (parent == curParent || parent instanceof IDataControl && curParent instanceof IDataControl && ((IDataControl)parent).getId().equals(((IDataControl)curParent).getId())) {
                return true;
            }
            if (parent instanceof IDataControlStructureObject) {
                if (child instanceof IDataControlStructureObject && ((IDataControlStructureObject)child).getDecoratedObject() instanceof OperationDefinition) {
                    return ObjectImplUtil.isValidOperationParent((IDataControlStructureObject)parent, (IDataControlStructureObject)child);
                }
                if (curParent instanceof IDataControlStructureObject) {
                    return ObjectImplUtil.arePathsAndTypesSame((IDataControlStructureObject)parent, (IDataControlStructureObject)curParent);
                }
            }
        }
        return false;
    }

    public static boolean isValidOperation(IDataControlObject parent, IDataControlObject child) {
        if (parent instanceof IDataControlStructureObject && child instanceof IDataControlStructureObject) {
            return ObjectImplUtil.isValidOperationParent((IDataControlStructureObject)parent, (IDataControlStructureObject)child);
        }
        return false;
    }

    public static boolean isValidOperationParent(IDataControlStructureObject parent, IDataControlStructureObject child) {
        Object decoratedObject2;
        IDataControlObject operation;
        OperationDefinition decoratedObject = (OperationDefinition)child.getDecoratedObject();
        ActionOptions actionOption = ActionOptions.get(decoratedObject.getOperationId());
        if (actionOption != null && (operation = ObjectImplUtil.findOperation(actionOption, null, (IDataControlObject)parent, decoratedObject, 0)) instanceof IDataControlStructureObject && (decoratedObject2 = ((IDataControlStructureObject)operation).getDecoratedObject()) instanceof OperationDefinition) {
            return ObjectImplUtil.isSamePathToDC((NamedDefinition)decoratedObject, (NamedDefinition)((OperationDefinition)decoratedObject2));
        }
        return false;
    }

    public static String getResolvedDcId(Application application, oracle.adfdt.model.objects.DataControl dataControl) {
        return application.installDataControl(dataControl);
    }

    private static boolean isSamePathToDC(NamedDefinition op1, NamedDefinition op2) {
        if (op1 != null && op2 != null) {
            if (op1.getName() != null && op1.getName().equals(op2.getName())) {
                return ObjectImplUtil.isSamePathToDC((NamedDefinition)op1.getDefinitionParent(), (NamedDefinition)op2.getDefinitionParent());
            }
            return false;
        }
        return op1 == op2;
    }

    public static boolean arePathsAndTypesSame(IDataControlObject first, IDataControlObject second) {
        return DTRTUtil.equals((Object)first, (Object)second);
    }

    private static boolean arePathsAndTypesSame(IDataControlStructureObject first, IDataControlStructureObject second) {
        if (first.getFullName().equals(second.getFullName())) {
            NamedDefinition parentDef = (NamedDefinition)first.getDecoratedObject();
            NamedDefinition curParentDef = (NamedDefinition)second.getDecoratedObject();
            if (parentDef != null && curParentDef != null && parentDef.getDefinitionType() == curParentDef.getDefinitionType()) {
                IDataControlObject firstParent = first.getParent();
                IDataControlObject secondParent = second.getParent();
                if (firstParent != null && secondParent != null) {
                    return ObjectImplUtil.arePathsAndTypesSame(firstParent, secondParent);
                }
                return firstParent == secondParent;
            }
        }
        return false;
    }

    private static IDataControlChild findDataControlChild(Set<String> checkedObjects, String fullName, List<? extends IDataControlChild> children) {
        for (IDataControlChild iDataControlChild : children) {
            IDataControlChild ret = ObjectImplUtil.findDataControlChild(checkedObjects, fullName, iDataControlChild);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private static IDataControlChild findDataControlChild(Set<String> checkedObjects, String fullName, IDataControlChild dataControlChild) {
        if (dataControlChild instanceof IDataControlStructureObject) {
            IDataControlStructureObject child = (IDataControlStructureObject)dataControlChild;
            String childFullName = child.getFullName();
            if (childFullName != null) {
                if (fullName.equals(childFullName)) {
                    return child;
                }
                if (childFullName.startsWith(fullName) && checkedObjects.add(childFullName)) {
                    return ObjectImplUtil.findDataControlChild(checkedObjects, fullName, child.getChildren());
                }
            }
        } else {
            assert (dataControlChild.getStructureObject() == null) : dataControlChild;
            return ObjectImplUtil.findDataControlChild(checkedObjects, fullName, dataControlChild.getChildren());
        }
        return null;
    }
}

