/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import oracle.eclipse.tools.adf.dtrt.vbundle.util.OracleXMLDocumentRecorder;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.BaseManagedXMLFile;
import oracle.xml.jaxp.JXDocumentBuilderFactory;
import oracle.xml.parser.v2.SAXParser;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

class ManagedXMLFile
extends BaseManagedXMLFile {
    private static final ThreadLocal<DocumentBuilder> TL_DOCUMENT_BUILDER = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                JXDocumentBuilderFactory factory = new JXDocumentBuilderFactory();
                factory.setIgnoreElementContentWhitespace(false);
                factory.setIgnoringComments(false);
                return factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public ManagedXMLFile(IFile file) {
        super(file);
    }

    public static DocumentBuilder getDocumentBuilder() {
        return TL_DOCUMENT_BUILDER.get();
    }

    public Document createContent() {
        return ManagedXMLFile.getDocumentBuilder().newDocument();
    }

    protected Transformer getTransformer() {
        return OracleXMLDocumentRecorder.TL_TRANSFORMER.get();
    }

    protected Source toSource(InputStream inputStream) {
        SAXParser saxParser = new SAXParser();
        saxParser.setEntityResolver(ENTITY_RESOLVER);
        return new SAXSource((XMLReader)saxParser, new InputSource(inputStream));
    }
}

