/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.ModelDesignTimeContext;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.adfdt.transaction.SimpleTransactionManager;
import oracle.adfdt.transaction.TransactionManager;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelperClient;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IChangeSummary;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IElementChange;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IManagerListener;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ADFDesignTimeContextImpl;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ChangeSummary;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.DTRTManagerImpl;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementChange;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementData;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementType;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ModelDesignTimeContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.IManagedFile;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

abstract class ElementManager
implements IDTRTManager,
ITypeHelperClient {
    private static final int NOTIFICATION_KIND_EXTERNAL_CHANGE = 0;
    private static final int NOTIFICATION_KIND_STRUCTURE_LOADING = 1;
    private static final int NOTIFICATION_KIND_STRUCTURE_CHANGE = 2;
    private final String id;
    private ModelDesignTimeContextImpl modelDesignTimeContext;
    private ADFDesignTimeContextImpl adfDesignTimeContext;
    private TransactionManager transactionManager;
    private final ElementMap elementMap = new ElementMap();
    private Collection<IFile> filesToBeDeleted;
    private final Set<MonitoredStructure> monitoredStructures = new HashSet<MonitoredStructure>();
    private int applyIndex;
    private boolean recording;
    private Collection<ElementChange> changesWhileRecording;
    private ITypeHelper typeHelper;
    private StructureProvider structureProvider;
    private Map<JDTUtil.TypeKey, Map<Object, Object>> typeCache;
    private TypedListenerList<IManagerListener> listeners;
    private int[] notificationArray = new int[3];

    public ElementManager() {
        this.id = String.valueOf(super.toString()) + System.nanoTime();
        this.listeners = new TypedListenerList();
    }

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.structureProvider != null) {
            this.structureProvider.dispose();
            this.structureProvider = null;
        }
        if (this.typeHelper != null) {
            if (!JDTUtil.dispose((ITypeHelper)this.typeHelper)) {
                this.typeHelper.reset();
            }
            this.typeHelper = null;
        }
        if (this.typeCache != null) {
            this.typeCache.clear();
            this.typeCache = null;
        }
        if (this.modelDesignTimeContext != null) {
            this.modelDesignTimeContext.dispose();
            this.modelDesignTimeContext = null;
        }
        if (this.adfDesignTimeContext != null) {
            this.adfDesignTimeContext.dispose();
            this.adfDesignTimeContext = null;
        }
        this.transactionManager = null;
        for (Object element : this.elementMap.getAllElements()) {
            this.basicUnmanage(element, ElementType.getElementData(element));
            ElementType.clearElementData(element);
        }
        this.elementMap.clear();
        this.reset();
    }

    @Override
    public final void reset() {
        if (this.structureProvider != null) {
            this.structureProvider.reset();
        }
        if (this.typeHelper != null) {
            this.typeHelper.reset();
        }
        if (this.typeCache != null) {
            this.typeCache.clear();
        }
        if (!this.elementMap.isEmpty()) {
            for (Object element : this.elementMap.getAllElements()) {
                this.basicUnmanage(element, ElementType.getElementData(element));
            }
            this.elementMap.clear();
        }
        if (this.filesToBeDeleted != null) {
            this.filesToBeDeleted.clear();
            this.filesToBeDeleted = null;
        }
        if (this.changesWhileRecording != null) {
            this.changesWhileRecording.clear();
            this.changesWhileRecording = null;
        }
        if (this.monitoredStructures != null) {
            DTRTUtil.dispose(this.monitoredStructures);
            this.monitoredStructures.clear();
        }
        this.applyIndex = 0;
        this.recording = false;
    }

    protected final TypedListenerList<IManagerListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void addListener(IManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public final void handleStructureLoading() {
        this.notifyStructureLoading();
    }

    protected final void handleExternalChange() {
        this.notify(0);
        if (this.hasNotificationRequest(1, false)) {
            this.notify(1);
        }
    }

    protected final void handleMonitoredStructureChange() {
        this.notify(2);
        if (this.hasNotificationRequest(1, false)) {
            this.notify(1);
        }
    }

    private void notifyStructureLoading() {
        if (this.isNotifying(0)) {
            this.queueNotificationRequest(1);
        } else if (this.isNotifying(2)) {
            this.queueNotificationRequest(1);
        } else {
            this.notify(1);
        }
    }

    private boolean isNotifying(int notificationKind) {
        return this.notificationArray[notificationKind] > 0;
    }

    private boolean hasNotificationRequest(int notificationKind, boolean clear) {
        int value = this.notificationArray[notificationKind];
        if (clear) {
            this.notificationArray[notificationKind] = 0;
        }
        return value > 1;
    }

    private void queueNotificationRequest(int notificationKind) {
        int n = notificationKind;
        this.notificationArray[n] = this.notificationArray[n] + 1;
    }

    private void notify(int notificationKind) {
        if (!this.isNotifying(notificationKind)) {
            this.queueNotificationRequest(notificationKind);
            for (IManagerListener listener : this.getListeners()) {
                try {
                    switch (notificationKind) {
                        case 0: {
                            listener.handleExternalChange(this);
                            break;
                        }
                        case 2: {
                            listener.handleStructureChange(this);
                            break;
                        }
                        case 1: {
                            listener.handleStructureLoading(this);
                        }
                    }
                }
                catch (Exception e) {
                    assert (false) : e;
                    DTRTvBundle.log(e);
                }
            }
            if (this.hasNotificationRequest(notificationKind, true)) {
                this.notify(notificationKind);
            }
        } else {
            this.queueNotificationRequest(notificationKind);
        }
    }

    @Override
    public boolean areEqualElements(Object e1, Object e2) {
        if (!DTRTUtil.equals((Object)e1, (Object)e2)) {
            if (e1 == null || e2 == null) {
                return false;
            }
            if (!DTRTUtil.equals((Object)ElementType.getElementData(e1), (Object)ElementType.getElementData(e2))) {
                return false;
            }
        }
        return true;
    }

    public final String getId() {
        return this.id;
    }

    @Override
    public final URI getElementURI(Object element) {
        ElementData elementData = ElementType.getElementData(element);
        return elementData != null ? elementData.getURI() : null;
    }

    @Override
    public final IFile getElementFile(Object element) {
        ElementData elementData = ElementType.getElementData(element);
        return elementData != null ? elementData.getFile() : null;
    }

    @Override
    public Object getElement(IElementChange elementChange) {
        return elementChange instanceof ElementChange ? this.getElement(((ElementChange)elementChange).getElementData()) : null;
    }

    public final Object getElement(ElementData elementData) {
        return elementData != null ? this.getElement(elementData.getType(), elementData.getURI()) : null;
    }

    protected final <T> T getElement(ElementType<T> elementType, URI elementURI) {
        return this.elementMap.getElement(elementType, elementURI);
    }

    protected final Collection<IFile> getFilesToBeDeleted() {
        return this.filesToBeDeleted == null ? (this.filesToBeDeleted = new HashSet<IFile>()) : this.filesToBeDeleted;
    }

    protected final void manage(Object element) {
        if (element != null) {
            assert (!DTRTUtil.isEmpty((String)ElementType.getFullName(element)));
            assert (!this.isManagedElement(element)) : element;
            ElementData elementData = ElementType.getElementData(element);
            if (elementData != null) {
                this.elementMap.putElement(elementData, element, this.getProject());
                return;
            }
        }
        throw new IllegalArgumentException("Unknown element: " + element);
    }

    @Override
    public final boolean isManagedElement(Object element) {
        if (element == null) {
            return false;
        }
        ElementData elementData = ElementType.getElementData(element);
        if (elementData == null || elementData.getManagedFile() == null) {
            return false;
        }
        return this.elementMap.isSet(elementData);
    }

    private <T> void basicUnmanage(T element, ElementData elementData) {
        if (elementData != null) {
            IManagedFile managedFile = elementData.getManagedFile();
            if (managedFile != null) {
                managedFile.dispose();
                ElementType.clearElementData(element);
            }
            this.elementMap.unset(elementData);
        }
        ElementType.clearContent(element);
    }

    protected final <T> void unmanage(T element) {
        this.unmanage(element, false);
    }

    private <T> void unmanage(T element, boolean markForDeletion) {
        ElementData elementData;
        if (element != null && (elementData = ElementType.getElementData(element)) != null && ElementType.getContent(element) != null) {
            if (this.recording) {
                assert (this.changesWhileRecording != null);
                IManagedFile managedFile = elementData.getManagedFile();
                assert (managedFile != null);
                assert (managedFile.isRecording());
                Object changeDetails = managedFile.endRecording(element);
                if (changeDetails == null) {
                    changeDetails = managedFile.takeSnapshot(element);
                }
                String fullName = ElementType.getFullName(element);
                this.basicUnmanage(element, elementData);
                this.changesWhileRecording.add(new ElementChange(elementData, changeDetails, element, fullName, markForDeletion));
            } else {
                assert (this.changesWhileRecording == null);
                this.basicUnmanage(element, elementData);
            }
        }
    }

    protected final <T> List<T> getManagedElements(ElementType<T> elementType) {
        return this.elementMap.getElements(elementType);
    }

    protected final <T> Collection<T> getManagedElements(ElementType<T> elementType, String fullName) {
        if (elementType != null && fullName != null && !this.elementMap.isEmpty()) {
            LinkedList<T> elements = new LinkedList<T>();
            for (T element : this.elementMap.getElements(elementType)) {
                if (!fullName.equals(ElementType.getFullName(element))) continue;
                elements.add(element);
            }
            return DTRTUtil.toUnmodifiablePrunedList(elements);
        }
        return Collections.emptyList();
    }

    protected final <E, C> E initializeElement(ElementType<E> elementType, IFile file, boolean create) {
        assert (file != null);
        IManagedFile<E, ?> managedFile = elementType.createManagedFile(file);
        return this.initializeElement(managedFile, elementType.createElement(file), create);
    }

    /*
     * Exception decompiling
     */
    private <E, C> E initializeElement(IManagedFile<E, C> managedFile, E template, boolean create) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final void beginRecording() throws IllegalStateException {
        if (this.recording) {
            throw new IllegalStateException("Already recording changes");
        }
        assert (this.changesWhileRecording == null);
        this.changesWhileRecording = new ArrayList<ElementChange>();
        ElementManagerVisitor<Object> visitor = new ElementManagerVisitor<Object>(this){

            @Override
            protected <E> Object visit(E element, IManagedFile<E, ?> managedFile, IProgressMonitor monitor) throws InterruptedException, CoreException {
                managedFile.beginRecording(element);
                return null;
            }
        };
        try {
            visitor.run(null);
            this.recording = true;
        }
        catch (Exception e) {
            DTRTvBundle.log(e);
        }
    }

    @Override
    public final boolean isRecording() {
        return this.recording;
    }

    @Override
    public void abortRecording() {
        if (this.recording) {
            assert (this.changesWhileRecording != null);
            ElementManagerVisitor<Object> visitor = new ElementManagerVisitor<Object>(this){

                @Override
                protected <E> Object visit(E element, IManagedFile<E, ?> managedFile, IProgressMonitor monitor) throws InterruptedException, CoreException {
                    managedFile.abortRecording(element);
                    return Boolean.TRUE;
                }
            };
            try {
                visitor.run(null);
            }
            catch (Exception exception) {}
            this.changesWhileRecording.clear();
            this.changesWhileRecording = null;
            this.recording = false;
        }
    }

    @Override
    public final ChangeSummary endRecording(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.recording) {
            assert (this.changesWhileRecording != null);
            ElementManagerVisitor<ElementChange> visitor = new ElementManagerVisitor<ElementChange>(this){

                @Override
                protected <E> ElementChange visit(E element, IManagedFile<E, ?> managedFile, IProgressMonitor monitor) throws InterruptedException, CoreException {
                    Object details = managedFile.endRecording(element);
                    return details == null ? null : new ElementChange(ElementType.getElementData(element), details, false);
                }
            };
            Collection<ElementChange> changes = visitor.run(monitor);
            changes.addAll(this.changesWhileRecording);
            this.changesWhileRecording.clear();
            this.changesWhileRecording = null;
            this.recording = false;
            if (!changes.isEmpty()) {
                return new ChangeSummary(this.getId(), ++this.applyIndex, changes);
            }
        }
        return null;
    }

    @Override
    public final boolean canApply(IChangeSummary changeSummary) {
        if (changeSummary instanceof ChangeSummary) {
            try {
                this.doCanApply((ChangeSummary)changeSummary);
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private void doCanApply(ChangeSummary changeSummary) throws IllegalArgumentException, IllegalStateException {
        if (this.recording) {
            throw new IllegalStateException("Cannot apply while recording changes");
        }
        if (!this.getId().equals(changeSummary.getManagerId())) {
            throw new IllegalArgumentException("Cannot apply the changes from a different manager");
        }
        if (changeSummary.getIndex() == 0) {
            throw new IllegalArgumentException("The specified change summary is not meant to be applied");
        }
        if (changeSummary.getIndex() > 0) {
            if (changeSummary.getIndex() != this.applyIndex) {
                throw new IllegalArgumentException("Can only apply the last change summary");
            }
        } else if (changeSummary.getIndex() != -1 * (this.applyIndex + 1)) {
            throw new IllegalArgumentException("Can only reapply the last applied change summary");
        }
        for (ElementChange elementChange : changeSummary.getChanges()) {
            if (elementChange.getUnmanagedElement() == null) {
                if (elementChange.getElementData().getManagedFile() != null) continue;
                throw new IllegalStateException("The change is meant for a managed element: " + elementChange);
            }
            if (elementChange.getElementData().getManagedFile() == null) continue;
            throw new IllegalStateException("The change is meant for an unmanaged element: " + elementChange);
        }
    }

    @Override
    public final ChangeSummary apply(IChangeSummary summary) throws IllegalArgumentException, IllegalStateException {
        return this.doApply(summary);
    }

    private <E, C> ChangeSummary doApply(IChangeSummary summary) throws IllegalArgumentException, IllegalStateException {
        if (summary instanceof ChangeSummary) {
            ChangeSummary changeSummary = (ChangeSummary)summary;
            this.doCanApply(changeSummary);
            this.applyIndex = changeSummary.getIndex() > 0 ? --this.applyIndex : ++this.applyIndex;
            assert (this.applyIndex >= 0);
            ArrayList<ElementChange> revertedChanges = new ArrayList<ElementChange>(changeSummary.getChanges().size());
            for (ElementChange elementChange : changeSummary.getChanges()) {
                ElementChange revertedChange;
                Object content;
                Object managedFile;
                Object element;
                ElementData elementData = elementChange.getElementData();
                assert (elementData != null);
                if (elementChange.getUnmanagedElement() == null) {
                    assert (elementData.getManagedFile() != null);
                    element = this.getElement(elementData);
                    managedFile = elementData.getManagedFile();
                    content = ElementType.getContent(element);
                } else {
                    element = elementChange.getUnmanagedElement();
                    managedFile = elementData.getType().createManagedFile(elementData.getFile());
                    content = managedFile.createContent();
                }
                assert (managedFile != null);
                assert (element != null);
                assert (content != null);
                Object revertedChangeDetails = managedFile.applyByContent(content, elementChange.getDetails());
                if (ElementType.isEmptyContent(content)) {
                    boolean markForDeletion;
                    boolean wasLoaded = managedFile.fileWasLoaded();
                    IFile file = managedFile.getFile();
                    String fullName = ElementType.getFullName(element);
                    this.basicUnmanage(element, elementData);
                    boolean bl = markForDeletion = (elementChange.isMarkedForDeletion() || !wasLoaded) && file.isAccessible();
                    if (markForDeletion) {
                        this.getFilesToBeDeleted().add(file);
                    }
                    elementData.setManagedFile(null);
                    revertedChange = new ElementChange(elementData, revertedChangeDetails, element, fullName, markForDeletion);
                } else {
                    if (elementChange.getUnmanagedElement() != null) {
                        this.getFilesToBeDeleted().remove(elementData.getFile());
                        this.initializeElement((IManagedFile<E, C>)managedFile, (E)element, true);
                        ElementType.initializeCreatedElement(element, elementChange.getFullName());
                        this.manage(element);
                    }
                    element = ElementType.initializeElement(this, managedFile, element, content);
                    elementData.setManagedFile((IManagedFile<?, ?>)managedFile);
                    revertedChange = new ElementChange(elementData, revertedChangeDetails, elementChange.isMarkedForDeletion());
                }
                if (element instanceof BeanStructure && this.structureProvider != null) {
                    this.structureProvider.reset(elementData.getURI());
                }
                revertedChanges.add(revertedChange);
            }
            return new ChangeSummary(this.getId(), -1 * changeSummary.getIndex(), revertedChanges);
        }
        return null;
    }

    @Override
    public final boolean delete(Object element) throws Exception {
        IManagedFile managedFile;
        if (this.isManagedElement(element) && (managedFile = ElementType.getElementData(element).getManagedFile()) != null) {
            IFile file = managedFile.getFile();
            this.handleAboutToBeDeleted(element, file);
            this.unmanage(element, true);
            if (file.isAccessible()) {
                this.getFilesToBeDeleted().add(file);
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean isAccessible(IFile file) {
        return file != null && !this.getFilesToBeDeleted().contains(file) && file.isAccessible();
    }

    protected abstract void handleAboutToBeDeleted(Object var1, IFile var2) throws Exception;

    protected abstract boolean shouldBeSourceFile(Object var1);

    public final ModelDesignTimeContext getModelDesignTimeContext() {
        if (this.modelDesignTimeContext == null && !this.isDisposed()) {
            this.modelDesignTimeContext = new ModelDesignTimeContextImpl((DTRTManagerImpl)this);
        }
        return this.modelDesignTimeContext;
    }

    @Override
    public final ADFDesignTimeContext getADFDesignTimeContext() {
        if (this.adfDesignTimeContext == null && !this.isDisposed()) {
            this.adfDesignTimeContext = new ADFDesignTimeContextImpl((DTRTManagerImpl)this);
        }
        return this.adfDesignTimeContext;
    }

    final TransactionManager getTransactionManager() {
        if (this.transactionManager == null && !this.isDisposed()) {
            this.transactionManager = new SimpleTransactionManager();
        }
        return this.transactionManager;
    }

    @Override
    public boolean isStale(Object element) {
        IManagedFile managedFile;
        ElementData elementData;
        if (element != null && ElementType.getContent(element) != null && (elementData = ElementType.getElementData(element)) != null && (managedFile = elementData.getManagedFile()) != null) {
            return managedFile.hasChangedExternally();
        }
        return false;
    }

    @Override
    public final StructureProvider getStructureProvider() {
        if (this.structureProvider == null && !this.isDisposed()) {
            this.structureProvider = new StructureProvider(this);
        }
        return this.structureProvider;
    }

    @Override
    public final ITypeHelper getTypeHelper() {
        return this.typeHelper == null ? (this.typeHelper = JDTUtil.createTypeHelper((ITypeHelperClient)this)) : this.typeHelper;
    }

    @Override
    public final <T> T cacheValue(IType type, Object key, T value) {
        if (type != null && key != null) {
            JDTUtil.TypeKey typeKey;
            Map<Object, Object> map;
            if (this.typeCache == null) {
                this.typeCache = new HashMap<JDTUtil.TypeKey, Map<Object, Object>>();
            }
            if ((map = this.typeCache.get(typeKey = new JDTUtil.TypeKey(type))) == null) {
                map = new HashMap<Object, Object>();
                this.typeCache.put(typeKey, map);
            }
            map.put(key, value);
            return value;
        }
        return null;
    }

    @Override
    public final Object getCachedValue(IType type, Object key) {
        Map<Object, Object> map;
        if (this.typeCache != null && type != null && key != null && (map = this.typeCache.get(new JDTUtil.TypeKey(type))) != null) {
            return map.get(key);
        }
        return null;
    }

    private boolean uncacheValues(IType type) {
        if (this.typeCache != null && type != null) {
            Map<Object, Object> map = this.typeCache.remove(new JDTUtil.TypeKey(type));
            return map != null && !map.isEmpty();
        }
        return false;
    }

    public final void handleCachedJavaElement(ITypeHelper typeHelper, IType type, IJavaElement javaElement) {
        IResource resource;
        assert (typeHelper == this.typeHelper);
        Object value = this.getCachedValue(type, ElementManager.class);
        if (value == null && (resource = type.getResource()) != null) {
            this.cacheValue(type, ElementManager.class, resource);
            this.monitoredStructures.add(new MonitoredStructure(resource, type));
        }
    }

    protected final Collection<? extends MonitoredStructure> getMonitoredStructures() {
        return Collections.unmodifiableCollection(new LinkedList<MonitoredStructure>(this.monitoredStructures));
    }

    @Override
    public final void resetStructures() {
        for (MonitoredStructure monitoredStructure : this.getMonitoredStructures()) {
            IType type;
            if (monitoredStructure == null || !monitoredStructure.isModified() || !(this.typeHelper.reset(type = monitoredStructure.getType()) | this.uncacheValues(type))) continue;
            if (this.structureProvider != null) {
                this.structureProvider.reset(type);
            }
            if (monitoredStructure.getResource().isAccessible()) continue;
            this.monitoredStructures.remove(monitoredStructure);
            monitoredStructure.dispose();
        }
    }

    protected abstract class ElementManagerVisitor<T> {
        protected ElementManagerVisitor() {
        }

        public Collection<T> run(IProgressMonitor monitor) throws InterruptedException, CoreException {
            return this.run(null, monitor);
        }

        public Collection<T> run(Collection<? extends IFile> filter, IProgressMonitor monitor) throws InterruptedException, CoreException {
            Collection<T> collection = this.createCollection();
            List<?> elements = ElementManager.this.elementMap.getAllElements();
            if (!elements.isEmpty()) {
                this.visit(filter, collection, elements, monitor);
            }
            return collection;
        }

        private boolean visit(Collection<? extends IFile> filter, Collection<T> collection, Collection<?> elements, IProgressMonitor monitor) throws InterruptedException, CoreException {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)collection.size());
            for (Object element : elements) {
                T visitReturn = this.visit(filter, element, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                if (visitReturn != null) {
                    collection.add(visitReturn);
                    if (!this.continueVisiting(collection)) {
                        return false;
                    }
                }
                ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
            return true;
        }

        private <E> T visit(Collection<? extends IFile> filter, E element, IProgressMonitor monitor) throws InterruptedException, CoreException {
            assert (element != null);
            assert (ElementType.getContent(element) != null) : element;
            ElementData elementData = ElementType.getElementData(element);
            IManagedFile managedFile = elementData != null ? elementData.getManagedFile() : null;
            return managedFile != null && (filter == null || filter.contains(managedFile.getFile())) ? (T)this.visit(element, managedFile, monitor) : null;
        }

        protected abstract <E> T visit(E var1, IManagedFile<E, ?> var2, IProgressMonitor var3) throws InterruptedException, CoreException;

        protected boolean continueVisiting(Collection<T> collection) {
            return true;
        }

        protected Collection<T> createCollection() {
            return new LinkedList();
        }
    }

    private static final class ElementMap
    extends IdentityHashMap<ElementType<?>, List<Pair<URI, ?>>> {
        private static final long serialVersionUID = 1L;

        private ElementMap() {
        }

        private Object getElement(List<Pair<URI, ?>> pairs, URI uri, boolean remove) {
            if (pairs != null && uri != null) {
                Iterator<Pair<URI, ?>> i = pairs.iterator();
                while (i.hasNext()) {
                    Pair<URI, ?> pair = i.next();
                    if (!uri.equals(pair.getFirst())) continue;
                    if (remove) {
                        i.remove();
                    }
                    return pair.getSecond();
                }
            }
            return null;
        }

        @Override
        public synchronized void clear() {
            if (!this.isEmpty()) {
                for (List values : this.values()) {
                    values.clear();
                }
                super.clear();
            }
        }

        public synchronized <E> E getElement(ElementType<E> elementType, URI uri) {
            if (!this.isEmpty() && elementType != null && uri != null) {
                return (E)this.getElement((List)this.get(elementType), uri, false);
            }
            return null;
        }

        public synchronized <E> List<E> getElements(ElementType<E> elementType) {
            List pairs;
            if (!this.isEmpty() && elementType != null && (pairs = (List)this.get(elementType)) != null) {
                ArrayList<Object> list = new ArrayList<Object>(pairs.size());
                for (Pair pair : pairs) {
                    list.add(pair.getSecond());
                }
                return Collections.unmodifiableList(list);
            }
            return Collections.emptyList();
        }

        public synchronized List<?> getAllElements() {
            if (!this.isEmpty()) {
                LinkedList<Object> list = new LinkedList<Object>();
                for (List values : this.values()) {
                    for (Pair pair : values) {
                        list.add(pair.getSecond());
                    }
                }
                return Collections.unmodifiableList(list);
            }
            return Collections.emptyList();
        }

        public synchronized boolean isSet(ElementData elementData) {
            return !this.isEmpty() && elementData != null && this.getElement((List)this.get(elementData.getType()), elementData.getURI(), false) != null;
        }

        public synchronized void unset(ElementData elementData) {
            if (!this.isEmpty() && elementData != null) {
                this.getElement((List)this.get(elementData.getType()), elementData.getURI(), true);
            }
        }

        public synchronized void putElement(ElementData elementData, Object element, IProject managerProject) {
            assert (managerProject != null);
            if (elementData != null && element != null) {
                assert (elementData.getType().getType().isInstance(element)) : elementData + " - " + element;
                ElementType<?> elementType = elementData.getType();
                LinkedList<Pair> pairs = (LinkedList<Pair>)this.get(elementType);
                if (pairs == null) {
                    pairs = new LinkedList<Pair>();
                    this.put(elementData.getType(), pairs);
                }
                Pair newPair = new Pair((Object)elementData.getURI(), element);
                boolean isInManagerProject = elementData.getFile().getProject().equals((Object)managerProject);
                boolean added = false;
                if (isInManagerProject && !pairs.isEmpty()) {
                    int i = 0;
                    int max = pairs.size();
                    while (i < max) {
                        Pair pair = (Pair)pairs.get(i);
                        IFile file = ElementData.computeElementFile(elementType, (URI)pair.getFirst());
                        assert (file != null);
                        if (!file.getProject().equals((Object)managerProject)) {
                            pairs.add(i, newPair);
                            added = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!added) {
                    pairs.add(newPair);
                }
            }
        }
    }

    static class MonitoredStructure
    implements IDisposable {
        private IType type;
        private IResource resource;
        private long timestamp;

        public MonitoredStructure(IResource resource, IType type) {
            this.type = type;
            this.resource = resource;
            this.timestamp = resource.getModificationStamp();
        }

        public void dispose() {
            this.type = null;
            this.resource = null;
        }

        public IResource getResource() {
            return this.resource;
        }

        public IType getType() {
            return this.type;
        }

        public boolean isModified() {
            long currentTimestamp = this.resource.getModificationStamp();
            if (currentTimestamp != this.timestamp) {
                this.timestamp = currentTimestamp;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MonitoredStructure other = (MonitoredStructure)obj;
            return DTRTUtil.equals((Object)this.resource, (Object)other.resource);
        }
    }
}

